/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs;

import de.aristaflow.adept2.model.timemodel.tcn.CSTN;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabelPicker;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class TimePointDialog
extends TitleAreaDialog {
    private LabelPicker labelPicker;
    private Spinner spinnerChoices;
    private Text text;
    private Combo combo;
    private Text txtEventID;
    private Button btnObservationTimePoint;
    private LabeledTimePoint timePoint;
    private List<Label.ChoiceVariable> observations;

    public TimePointDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create a Time Point");
    }

    public void create() {
        super.create();
        this.setTitle("Create a new Time Point");
        if (this.observations != null) {
            this.labelPicker.setEnabled(true);
            this.labelPicker.setChoiceVariables(this.observations);
        } else {
            this.labelPicker.setEnabled(false);
        }
    }

    public void init(TCN<LabeledTimePoint, LabeledEdge> tcn) {
        if (tcn instanceof CSTN) {
            CSTN cstn = (CSTN)tcn;
            this.observations = cstn.getObservations();
        } else {
            this.observations = null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(3, false));
        Group grpNodeInstance = new Group(composite, 0);
        grpNodeInstance.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        grpNodeInstance.setLayout((Layout)new GridLayout(2, false));
        grpNodeInstance.setText("Node Instance");
        org.eclipse.swt.widgets.Label lblNodeId = new org.eclipse.swt.widgets.Label((Composite)grpNodeInstance, 0);
        lblNodeId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNodeId.setText("Node ID");
        this.text = new Text((Composite)grpNodeInstance, 2048);
        this.text.setText("0");
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TimePointDialog.this.checkValid();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.trim().length() == 0) {
                    return;
                }
                try {
                    Integer.parseInt(e.text);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                    return;
                }
            }
        });
        GridData gd_text = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_text.widthHint = 150;
        this.text.setLayoutData((Object)gd_text);
        org.eclipse.swt.widgets.Label lblIteration = new org.eclipse.swt.widgets.Label((Composite)grpNodeInstance, 0);
        lblIteration.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIteration.setText("Iteration");
        this.combo = new Combo((Composite)grpNodeInstance, 0);
        this.combo.setEnabled(false);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        org.eclipse.swt.widgets.Label lblEventId = new org.eclipse.swt.widgets.Label(composite, 0);
        lblEventId.setText("Event ID");
        this.txtEventID = new Text(composite, 2048);
        this.txtEventID.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TimePointDialog.this.checkValid();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridData gd_txtEventID = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtEventID.widthHint = 150;
        this.txtEventID.setLayoutData((Object)gd_txtEventID);
        new org.eclipse.swt.widgets.Label(composite, 0);
        this.btnObservationTimePoint = new Button(composite, 32);
        this.btnObservationTimePoint.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnObservationTimePoint.setText("Observation Time Point");
        new org.eclipse.swt.widgets.Label(composite, 0);
        new org.eclipse.swt.widgets.Label(composite, 0);
        final org.eclipse.swt.widgets.Label lblChoices = new org.eclipse.swt.widgets.Label(composite, 0);
        lblChoices.setEnabled(false);
        lblChoices.setText("Number of Choices");
        this.spinnerChoices = new Spinner(composite, 2048);
        this.spinnerChoices.setEnabled(false);
        this.spinnerChoices.setMaximum(10);
        this.spinnerChoices.setMinimum(2);
        this.btnObservationTimePoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                lblChoices.setEnabled(TimePointDialog.this.btnObservationTimePoint.getSelection());
                TimePointDialog.this.spinnerChoices.setEnabled(TimePointDialog.this.btnObservationTimePoint.getSelection());
            }
        });
        org.eclipse.swt.widgets.Label lblLabel = new org.eclipse.swt.widgets.Label(composite, 0);
        lblLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblLabel.setText("Label");
        this.labelPicker = new LabelPicker(composite, 0);
        this.labelPicker.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.checkValid();
        return dialogArea;
    }

    protected void checkValid() {
        String nodeID = this.text.getText();
        if (nodeID.trim().length() == 0) {
            this.setErrorMessage("Node ID must be a number!");
            return;
        }
        try {
            Integer.parseInt(nodeID);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Node ID must be a number!");
            return;
        }
        if (this.txtEventID.getText().trim().length() == 0) {
            this.setErrorMessage("Event ID cannot be empty!");
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String errorMessage) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(errorMessage == null);
        }
        super.setErrorMessage(errorMessage);
    }

    public LabeledTimePoint createTimePoint() {
        DefaultLabeledNode timePoint;
        int nodeID = Integer.parseInt(this.text.getText().trim());
        IterationChain iteration = new IterationChain(0);
        NodeInstance nodeInstance = new NodeInstance(nodeID, iteration, -1);
        String eventID = this.txtEventID.getText().trim();
        Label label = this.labelPicker.getLabel();
        if (this.btnObservationTimePoint.getSelection()) {
            int choices = this.spinnerChoices.getSelection();
            long[] edgeCodes = new long[choices];
            int i = 0;
            while (i < choices) {
                edgeCodes[i] = i;
                ++i;
            }
            timePoint = new DefaultObservationTimePoint(nodeInstance, eventID, label, edgeCodes);
        } else {
            timePoint = new DefaultLabeledNode(nodeInstance, eventID, label);
        }
        return timePoint;
    }

    protected void okPressed() {
        this.timePoint = this.createTimePoint();
        super.okPressed();
    }

    public LabeledTimePoint getTimePoint() {
        return this.timePoint;
    }
}

