/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.timemanager.TimeModellingService;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.timemodel.GuardedInterval;
import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.aristaflow.adept2.model.timemodel.tcn.graphml.GraphMLExport;
import de.aristaflow.adept2.model.timemodel.tcn.graphml.GraphMLImport;
import de.aristaflow.adept2.model.timemodel.tcn.xml.TCNXMLExport;
import de.aristaflow.adept2.model.timemodel.tcn.xml.TCNXMLImport;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.processvisualisation.preferences.LocalTimeModellingService;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.util.StreamTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.CSTNUEditorActivator;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.ConstraintPairDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabeledEdgeDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.TimePointDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editorinputs.TemplateTimeModelEditorInput;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentLabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.HighlightManager;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ImplicitEdgeFilter;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SWTResourceManager;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.inputs.XMLRootHandler;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.layouts.JungZestLayoutWrapper;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.layouts.StaticCSTNULayout;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.Filter;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutItem;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSTNUEditor
extends EditorPart
implements IZoomableWorkbenchPart,
ITabbedPropertySheetPageContributor,
ISelectionProvider,
ISelectionChangedListener,
IPersistableEditor {
    public static String ID = "de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUEditor";
    private Composite parentComposite;
    private TimeManager timeManager;
    TemplateTimeModel templateTimeModel;
    private GraphViewer solutionViewer;
    GraphViewer baseViewer;
    private LayoutAlgorithm currentLayoutAlgorithm;
    LayoutAlgorithm[] layoutObjects;
    private boolean dirty;
    private Combo layoutCombo;
    private Text errorText;
    private Composite errorComposite;
    private MenuItem mntmSaveAs;
    private MenuItem mntmAddEdge;
    private Menu baseViewerMenu;
    private MenuItem mntmRemoveTimePoint;
    private boolean editingEnabled;
    private TimeModellingService timeModellingService;
    private MenuItem mntmRemoveEdge;
    private SashForm rightContentArea;
    private Composite solutionViewerComposite;
    private Set<ISelectionChangedListener> selectionListener;
    private ISelection currentSelection;
    private CSTNUEditorPreferences editorPreferences;
    private Button btnSinglearrow;
    private boolean singleArrow;
    private Button btnCalculateDuration;
    private IDialogSettings dialogSettings;
    private Button btnSolutionShowImplicitConstraints;
    private Button btnBaseShowImplicitConstraints;
    private TCN<LabeledTimePoint, LabeledEdge> tcn;

    public CSTNUEditor() {
        LayoutAlgorithm[] layoutAlgorithmArray = this.layoutObjects = new LayoutAlgorithm[]{new StaticCSTNULayout(1), new SpringLayoutAlgorithm(1), new DirectedGraphLayoutAlgorithm(1), new GridLayoutAlgorithm(1), new HorizontalLayoutAlgorithm(1), new VerticalLayoutAlgorithm(1), new HorizontalShift(1), new TreeLayoutAlgorithm(1), new HorizontalTreeLayoutAlgorithm(1), new RadialLayoutAlgorithm(1), new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new DirectedGraphLayoutAlgorithm(1), new HorizontalShift(1)}), new JungZestLayoutWrapper(1, 0), new JungZestLayoutWrapper(1, 6), new JungZestLayoutWrapper(1, 1), new JungZestLayoutWrapper(1, 2), new JungZestLayoutWrapper(1, 3), new JungZestLayoutWrapper(1, 4), new JungZestLayoutWrapper(1, 7), new JungZestLayoutWrapper(1, 8)};
        int n = this.layoutObjects.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutAlgorithm layout = layoutAlgorithmArray[n2];
            layout.setFilter(new Filter(){

                public boolean isObjectFiltered(LayoutItem object) {
                    if (object.getGraphData() instanceof GraphItem) {
                        final GraphItem item = (GraphItem)object.getGraphData();
                        final boolean[] result = new boolean[1];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                LabeledEdge edge;
                                result[0] = item.getData() instanceof LabeledEdge ? !TCNEdge.FlowDirection.FORWARD.equals((Object)(edge = (LabeledEdge)item.getData()).getFlowDirection()) : false;
                            }
                        });
                        return result[0];
                    }
                    return false;
                }
            });
            ++n2;
        }
        this.dirty = false;
        this.selectionListener = new HashSet<ISelectionChangedListener>();
        this.editorPreferences = new CSTNUEditorPreferences(CSTNUEditorActivator.getDefault().getPreferenceStore());
        this.dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)CSTNUEditorActivator.getDefault().getDialogSettings(), (String)"CSTNUEditor");
        this.singleArrow = this.dialogSettings.getBoolean("SingleArrow");
        TimeModelPreferences timeModelPreferences = new TimeModelPreferences();
        this.timeModellingService = new LocalTimeModellingService(this.getTimeManager(), timeModelPreferences);
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)input;
            try {
                TCN tcn = (TCN)this.baseViewer.getInput();
                String contentType = this.getContentType(storageInput);
                InputStream inputStream = null;
                try {
                    inputStream = contentType.equals("graphml") ? this.saveTCNToGraphML((TCN<LabeledTimePoint, LabeledEdge>)tcn, monitor) : this.saveTCNToXML((TCN<LabeledTimePoint, LabeledEdge>)tcn, monitor);
                    if (inputStream != null) {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(storageInput.getStorage().getFullPath());
                        file.setContents(inputStream, true, true, monitor);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
                e.printStackTrace();
            }
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
        try {
            TCN tcn = (TCN)this.baseViewer.getInput();
            this.doSaveAs((TCN<LabeledTimePoint, LabeledEdge>)tcn);
        }
        catch (Exception ex) {
            CSTNUEditorActivator.handleError(this.getEditorSite().getShell(), ex);
        }
    }

    public void doSaveAs(TCN<LabeledTimePoint, LabeledEdge> tcn) throws CoreException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 8192);
        String initialPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        dialog.setText("Save As");
        if (initialPath != null) {
            dialog.setFilterPath(initialPath);
        }
        dialog.setFilterExtensions(new String[]{"*.xml", "*.graphml"});
        dialog.setFilterNames(new String[]{"CSTNU", "GraphML"});
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        int fileType = dialog.getFilterIndex();
        File file = new File(fileName);
        if (file.exists()) {
            MessageDialog confirm = new MessageDialog(null, "Confirm file overwrite", null, "The file " + file + " already exists. Overwrite the file?", 3, new String[]{"Overwrite", "Cancel"}, 0);
            if (confirm.open() != 0) {
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new CoreException(CSTNUEditorActivator.getErrorStatus(e));
            }
        }
        try {
            this.saveToFile(tcn, file, fileType, this.getProgressMonitor());
        }
        catch (IOException e) {
            throw new CoreException(CSTNUEditorActivator.getErrorStatus(e));
        }
    }

    protected void saveToFile(TCN<LabeledTimePoint, LabeledEdge> tcn, File file, int fileType, IProgressMonitor progressMonitor) throws IOException, CoreException {
        InputStream inputStream = null;
        try {
            switch (fileType) {
                case 1: {
                    inputStream = this.saveTCNToGraphML(tcn, progressMonitor);
                    break;
                }
                default: {
                    inputStream = this.saveTCNToXML(tcn, progressMonitor);
                }
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                StreamTools.copyStreamToStream((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, progressMonitor);
        this.setDirty(false);
    }

    private InputStream saveTCNToGraphML(TCN<LabeledTimePoint, LabeledEdge> tcn, IProgressMonitor progressMonitor) {
        GraphMLExport graphExport = new GraphMLExport(this.getTimeManager().getTimeModellingService().getTimeModelFactory().getTimeModelOperations());
        try {
            return graphExport.getInputStreamForTCN(tcn);
        }
        catch (IOException e) {
            new ErrorDialog(this.getSite().getShell(), "Error saving model.", "An IOException occurred while saving the model to file!", (IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", e.getMessage(), (Throwable)e), 4).open();
            return null;
        }
        catch (IllegalArgumentException e) {
            new ErrorDialog(this.getSite().getShell(), "Error saving model.", "An error occurred while saving the model to file!", (IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", e.getMessage(), (Throwable)e), 4).open();
            return null;
        }
    }

    private InputStream saveTCNToXML(TCN<LabeledTimePoint, LabeledEdge> tcn, Object object) {
        TCNXMLExport xmlExport = new TCNXMLExport();
        try {
            Document document = xmlExport.getDocumentForTCN(tcn);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLHelperTools.writeDocumentToStream((Document)document, (OutputStream)out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (XMLFormatException e) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TemplateInput || input instanceof IStorageEditorInput || input instanceof TemplateTimeModelEditorInput)) {
            throw new PartInitException("Wrong IEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void setInput(IEditorInput input) throws RuntimeException {
        this.setInputWithNotify(input);
    }

    protected void setInputWithNotify(IEditorInput input) throws RuntimeException {
        if (!(input instanceof TemplateInput || input instanceof IStorageEditorInput || input instanceof TemplateTimeModelEditorInput)) {
            throw new RuntimeException("Wrong IEditorInput");
        }
        try {
            this.doSetInput(input);
            this.firePropertyChange(258);
        }
        catch (CoreException x) {
            CSTNUEditorActivator.handleError(this.getSite().getShell(), "Error Opening Editor Input", "An error occurred while opening the editor input!", x.getStatus());
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            super.setInput(input);
            this.setDirty(false);
            this.initializeTitle(input);
            this.updatePartControl(input);
        }
    }

    private void updatePartControl(IEditorInput input) throws CoreException {
        if (this.solutionViewer == null || this.baseViewer == null) {
            return;
        }
        if (input instanceof TemplateInput) {
            this.initializeContentFromTemplate((TemplateInput)input);
        } else if (input instanceof IStorageEditorInput) {
            this.initializeContentFromFile((IStorageEditorInput)input);
        } else if (input instanceof TemplateTimeModelEditorInput) {
            this.initializeContentFromTimeModel((TemplateTimeModelEditorInput)input);
        }
    }

    private void initializeContentFromTimeModel(TemplateTimeModelEditorInput input) {
        TemplateTimeModel timeModel;
        this.setEditingEnabled(false);
        this.templateTimeModel = timeModel = input.getTimeModel();
        TCN cstnu = ((TCNTemplateTimeModel)this.templateTimeModel).getBaseTimeModel();
        this.doInitContent((TCN<LabeledTimePoint, LabeledEdge>)cstnu);
    }

    private void initializeContentFromFile(IStorageEditorInput input) throws CoreException {
        block10: {
            this.setEditingEnabled(true);
            try {
                InputStream inputStream = input.getStorage().getContents();
                String contentType = this.getContentType(input);
                try {
                    try {
                        if ("cstnu".equalsIgnoreCase(contentType)) {
                            this.initializeContentFromCSTNU(inputStream);
                            break block10;
                        }
                        if ("graphml".equalsIgnoreCase(contentType)) {
                            this.initilizeContentFromGraphML(inputStream);
                            break block10;
                        }
                        throw new CoreException((IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", "Unsupported File Type"));
                    }
                    catch (XMLFormatException e) {
                        throw new CoreException((IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", "Error loading file.", (Throwable)e));
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", "Error loading file.", (Throwable)e));
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", "Error loading file.", (Throwable)e));
            }
        }
    }

    private String getContentType(IStorageEditorInput input) throws CoreException, IOException {
        String rootElementName;
        InputStream inputStream = input.getStorage().getContents();
        try {
            XMLRootHandler handler = new XMLRootHandler(true);
            try {
                if (!handler.parseContents(new InputSource(inputStream))) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }
            catch (SAXException sAXException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            rootElementName = handler.getRootName();
        }
        finally {
            inputStream.close();
        }
        return rootElementName;
    }

    protected void setEditingEnabled(boolean enabled) {
        this.editingEnabled = enabled;
        this.baseViewerMenu.setEnabled(enabled);
        this.mntmAddEdge.setEnabled(enabled);
        this.mntmSaveAs.setEnabled(enabled);
        this.mntmRemoveTimePoint.setEnabled(enabled);
    }

    private void initilizeContentFromGraphML(InputStream inputStream) throws XMLFormatException, IOException {
        GraphMLImport graphImport = new GraphMLImport(this.getTimeManager().getTimeModellingService().getTimeModelFactory().getTimeModelOperations());
        TCN tcn = graphImport.getTCNFromStream(inputStream);
        this.doInitContent((TCN<LabeledTimePoint, LabeledEdge>)tcn);
    }

    private void initializeContentFromCSTNU(InputStream inputStream) throws XMLFormatException, IOException {
        TCNXMLImport xmlImport = new TCNXMLImport();
        TCN tcn = xmlImport.getTCNFromStream(inputStream);
        this.doInitContent((TCN<LabeledTimePoint, LabeledEdge>)tcn);
    }

    private void initializeContentFromTemplate(final TemplateInput input) {
        this.setEditingEnabled(false);
        this.getProgressMonitor().beginTask("Create CSTNU", -1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TemplateInput.Holder templateHolder = input.load();
                    Template template = templateHolder.template;
                    CSTNUEditor.this.templateTimeModel = CSTNUEditor.this.timeModellingService.createTimeModelForTemplate(template);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CSTNUEditor.this.getProgressMonitor().worked(1);
                            try {
                                TCN cstnu = ((TCNTemplateTimeModel)(this).CSTNUEditor.this.templateTimeModel).getBaseTimeModel();
                                CSTNUEditor.this.doInitContent((TCN<LabeledTimePoint, LabeledEdge>)cstnu);
                            }
                            catch (Exception e) {
                                CSTNUEditor.this.getProgressMonitor().setCanceled(false);
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"An error occurred", (String)e.getMessage());
                            }
                            CSTNUEditor.this.getProgressMonitor().done();
                        }
                    });
                }
                catch (Exception e) {
                    final String message = String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage();
                    e.printStackTrace();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"An error occurred", (String)message);
                        }
                    });
                }
            }
        }).start();
    }

    IProgressMonitor getProgressMonitor() {
        IActionBars bars = this.getEditorSite().getActionBars();
        IStatusLineManager statusLine = bars.getStatusLineManager();
        IProgressMonitor pm = statusLine.getProgressMonitor();
        return pm;
    }

    protected void doInitContent(TCN<LabeledTimePoint, LabeledEdge> tcn) {
        boolean positionsAvailable;
        Iterator iterator = tcn.getTimePoints().iterator();
        LabeledTimePoint node = (LabeledTimePoint)iterator.next();
        boolean bl = positionsAvailable = node.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting") != null;
        if (iterator.hasNext()) {
            node = (LabeledTimePoint)iterator.next();
            positionsAvailable |= node.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting") != null;
        }
        if (positionsAvailable) {
            this.setLayoutAlgorithm(0);
        } else {
            this.setLayoutAlgorithm(15);
        }
        if (!(tcn instanceof AbstractTCN)) {
            this.setEditingEnabled(false);
        }
        this.baseViewer.setInput(tcn);
        this.baseViewer.getGraphControl().layout(true);
        this.tcn = tcn;
    }

    TimeManager getTimeManager() {
        if (this.timeManager == null) {
            this.timeManager = CSTNUEditorActivator.getTimeManager();
        }
        return this.timeManager;
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                CSTNUEditor.this.getSite().getPage().closeEditor((IEditorPart)CSTNUEditor.this, save);
            }
        });
    }

    private void initializeTitle(IEditorInput input) {
        this.setPartName(input.getName());
        if (input.getImageDescriptor() != null) {
            this.setTitleImage(JFaceResources.getResources().createImageWithDefault(input.getImageDescriptor()));
        }
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.baseViewer;
    }

    public void dispose() {
        this.dialogSettings.put("SingleArrow", this.singleArrow);
        super.dispose();
        if (this.getEditorInput() != null && this.getEditorInput().getImageDescriptor() != null) {
            JFaceResources.getResources().destroyImage(this.getEditorInput().getImageDescriptor());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.createContent(this.parentComposite);
        try {
            this.updatePartControl(this.getEditorInput());
        }
        catch (CoreException e) {
            e.printStackTrace();
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error initalizing Content", (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    protected Composite createContent(Composite parentComposite) {
        GridLayout gl_parentComposite = new GridLayout(1, false);
        gl_parentComposite.horizontalSpacing = 0;
        gl_parentComposite.verticalSpacing = 0;
        gl_parentComposite.marginWidth = 0;
        gl_parentComposite.marginHeight = 0;
        parentComposite.setLayout((Layout)gl_parentComposite);
        SashForm contentArea = new SashForm(parentComposite, 0);
        contentArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout parentLayout = new GridLayout(2, false);
        parentLayout.verticalSpacing = 0;
        parentLayout.horizontalSpacing = 0;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        contentArea.setLayout((Layout)parentLayout);
        this.createLeftArea((Composite)contentArea);
        this.createRightArea((Composite)contentArea);
        Composite composite = new Composite(parentComposite, 2048);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSinglearrow = new Button(composite, 32);
        this.btnSinglearrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                CSTNUEditor.this.setSingleArrow(button.getSelection());
            }
        });
        this.btnSinglearrow.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnSinglearrow.setText("Single Arrow");
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.btnSinglearrow.setSelection(this.singleArrow);
        this.setSingleArrow(this.btnSinglearrow.getSelection());
        this.baseViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.solutionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return contentArea;
    }

    protected Composite createRightArea(Composite contentArea) {
        Composite rightArea = new Composite(contentArea, 0);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 1;
        rightArea.setLayoutData((Object)layoutData);
        String[] items = new String[this.layoutObjects.length];
        int i = 0;
        while (i < this.layoutObjects.length) {
            items[i] = this.layoutObjects[i] instanceof JungZestLayoutWrapper ? this.layoutObjects[i].toString() : this.layoutObjects[i].getClass().getSimpleName();
            ++i;
        }
        GridLayout gl_rightArea = new GridLayout(1, false);
        gl_rightArea.marginWidth = 0;
        gl_rightArea.marginHeight = 0;
        rightArea.setLayout((Layout)gl_rightArea);
        this.rightContentArea = new SashForm(rightArea, 512);
        this.rightContentArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayoutFactory factory = GridLayoutFactory.fillDefaults().spacing(0, 0);
        this.rightContentArea.setLayout((Layout)factory.create());
        final ImplicitEdgeFilter edgeFilter = new ImplicitEdgeFilter();
        this.solutionViewerComposite = new Composite((Composite)this.rightContentArea, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.verticalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        this.solutionViewerComposite.setLayout((Layout)gl_composite);
        Composite buttonBar = new Composite(this.solutionViewerComposite, 0);
        GridLayout gl_buttonBar = new GridLayout(2, false);
        gl_buttonBar.marginWidth = 0;
        gl_buttonBar.marginHeight = 0;
        buttonBar.setLayout((Layout)gl_buttonBar);
        GridData gd_buttonBar = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_buttonBar.heightHint = 25;
        buttonBar.setLayoutData((Object)gd_buttonBar);
        this.btnCalculateDuration = new Button(buttonBar, 0);
        this.btnCalculateDuration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSTNUEditor.this.calculateDuration();
            }
        });
        this.btnCalculateDuration.setText("Calculate Duration");
        this.btnCalculateDuration.setEnabled(false);
        this.btnSolutionShowImplicitConstraints = new Button(buttonBar, 32);
        this.btnSolutionShowImplicitConstraints.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.btnSolutionShowImplicitConstraints.setText("Show Implicit Constraints");
        this.btnSolutionShowImplicitConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    CSTNUEditor.this.solutionViewer.removeFilter(edgeFilter);
                } else {
                    CSTNUEditor.this.solutionViewer.addFilter(edgeFilter);
                }
            }
        });
        this.btnSolutionShowImplicitConstraints.setSelection(this.dialogSettings.getBoolean("Right.ShowImplicit"));
        if (this.btnSolutionShowImplicitConstraints.getSelection()) {
            this.solutionViewer.addFilter((ViewerFilter)edgeFilter);
        }
        this.solutionViewer = new GraphViewer(this.solutionViewerComposite, 0);
        Control control = this.solutionViewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Menu solutionViewerMenu = new Menu(control);
        control.setMenu(solutionViewerMenu);
        this.mntmSaveAs = new MenuItem(solutionViewerMenu, 0);
        this.mntmSaveAs.setText("Save As");
        this.mntmSaveAs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TCN tcn = (TCN)CSTNUEditor.this.solutionViewer.getInput();
                    CSTNUEditor.this.doSaveAs((TCN<LabeledTimePoint, LabeledEdge>)tcn);
                }
                catch (CoreException e1) {
                    CSTNUEditorActivator.handleError(CSTNUEditor.this.getEditorSite().getShell(), e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.solutionViewer.setLayoutAlgorithm((LayoutAlgorithm)new StaticCSTNULayout(1));
        this.solutionViewer.getGraphControl().addSelectionListener((SelectionListener)new HighlightManager());
        if (!this.btnSolutionShowImplicitConstraints.getSelection()) {
            this.solutionViewer.addFilter((ViewerFilter)edgeFilter);
        }
        this.errorComposite = new Composite((Composite)this.rightContentArea, 0);
        this.errorComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblModelIsInconsistent = new Label(this.errorComposite, 0);
        lblModelIsInconsistent.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        lblModelIsInconsistent.setForeground(SWTResourceManager.getColor(3));
        lblModelIsInconsistent.setText("Model is Inconsistent!");
        lblModelIsInconsistent.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.errorText = new Text(this.errorComposite, 2888);
        GridData gd_errorText = new GridData(4, 4, false, true, 1, 1);
        gd_errorText.widthHint = 100;
        this.errorText.setLayoutData((Object)gd_errorText);
        this.rightContentArea.setWeights(new int[]{2, 1});
        this.setErrorMessage(null);
        return rightArea;
    }

    protected void calculateDuration() {
        LabeledTimePoint targetNode;
        LabeledTimePoint sourceNode;
        TCN cstnu = (TCN)this.solutionViewer.getInput();
        if (cstnu == null) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Cannot calculate duration of the network!", (String)"Please check that the network has been checked for controllability!", (IStatus)CSTNUEditorActivator.getErrorStatus("Check network for controllability first!"));
            return;
        }
        try {
            sourceNode = (LabeledTimePoint)cstnu.getTimeBaseEvent();
            if (sourceNode == null) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Cannot calculate duration of the network!", (String)"The network does not have a unique source node", (IStatus)CSTNUEditorActivator.getErrorStatus("The network does not have a unique source node"));
                return;
            }
            targetNode = (LabeledTimePoint)TCNAlgorithms.getTargetTimePoint((TCN)cstnu);
            if (targetNode == null) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Cannot calculate duration of the network!", (String)"The network does not have a unique destination node", (IStatus)CSTNUEditorActivator.getErrorStatus("The network does not have a unique destination node"));
                return;
            }
        }
        catch (IllegalArgumentException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error!", (String)e.getMessage(), (IStatus)CSTNUEditorActivator.getErrorStatus(e));
            return;
        }
        GuardedInterval restrictableDuration = TCNAlgorithms.getRestrictableDuration((TCN)cstnu, (TCNTimePoint)sourceNode, (TCNTimePoint)targetNode);
        CSTNULabelProvider labelProvider = this.getGraphLabelProvider(this.singleArrow);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Overall Duration:\t");
        stringBuilder.append("[[").append(labelProvider.getValueString((TimeDistance)restrictableDuration.getFlexibleMinimum())).append(", ").append(labelProvider.getValueString((TimeDistance)restrictableDuration.getGuardedMinimum())).append("] [").append(labelProvider.getValueString((TimeDistance)restrictableDuration.getGuardedMaximum())).append(", ").append(labelProvider.getValueString((TimeDistance)restrictableDuration.getFlexibleMaximum())).append("]]").append("\n\n").append("Contingency:\t  ").append(labelProvider.getValueString((TimeDistance)restrictableDuration.getContingency()));
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"STNPSU Duration Range", (String)stringBuilder.toString());
    }

    protected void setErrorMessage(String message) {
        if (message == null) {
            this.errorComposite.setVisible(false);
            this.errorText.setText("");
            this.rightContentArea.setMaximizedControl((Control)this.solutionViewerComposite);
        } else {
            this.errorComposite.setVisible(true);
            this.errorText.setText(message);
            this.rightContentArea.setMaximizedControl(null);
        }
        this.errorComposite.getParent().layout(true, true);
    }

    protected Composite createLeftArea(Composite contentArea) {
        Composite leftArea = new Composite(contentArea, 0);
        GridLayout gl_leftArea = new GridLayout(1, true);
        gl_leftArea.horizontalSpacing = 0;
        gl_leftArea.verticalSpacing = 0;
        gl_leftArea.marginHeight = 0;
        gl_leftArea.marginWidth = 0;
        leftArea.setLayout((Layout)gl_leftArea);
        leftArea.setLayoutData((Object)new GridData(4));
        Composite buttonBar = new Composite(leftArea, 0);
        GridLayout gl_buttonBar = new GridLayout(3, false);
        gl_buttonBar.marginWidth = 0;
        gl_buttonBar.marginHeight = 0;
        buttonBar.setLayout((Layout)gl_buttonBar);
        GridData gd_buttonBar = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_buttonBar.heightHint = 25;
        gd_buttonBar.minimumHeight = 25;
        buttonBar.setLayoutData((Object)gd_buttonBar);
        leftArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.layoutCombo = new Combo(buttonBar, 8);
        GridData gd_layoutCombo = new GridData(4, 0x1000000, false, true, 1, 1);
        gd_layoutCombo.minimumWidth = 250;
        this.layoutCombo.setLayoutData((Object)gd_layoutCombo);
        String[] items = new String[this.layoutObjects.length];
        int i = 0;
        while (i < this.layoutObjects.length) {
            items[i] = this.layoutObjects[i] instanceof JungZestLayoutWrapper ? this.layoutObjects[i].toString() : this.layoutObjects[i].getClass().getSimpleName();
            ++i;
        }
        this.layoutCombo.setItems(items);
        this.layoutCombo.select(0);
        this.layoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo source = (Combo)e.widget;
                int index = source.getSelectionIndex();
                CSTNUEditor.this.setLayoutAlgorithm(index);
            }
        });
        this.btnBaseShowImplicitConstraints = new Button(buttonBar, 32);
        this.btnBaseShowImplicitConstraints.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.btnBaseShowImplicitConstraints.setText("Show Implicit Constraints");
        Button btnCheckControllability = new Button(buttonBar, 0);
        btnCheckControllability.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnCheckControllability.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSTNUEditor.this.doCheckControllability();
            }
        });
        btnCheckControllability.setText("Check Controllability");
        Composite graphArea = new Composite(leftArea, 0);
        graphArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 1;
        graphArea.setLayoutData((Object)layoutData);
        graphArea.setLayout((Layout)new FillLayout(768));
        this.baseViewer = new GraphViewer(graphArea, 0);
        Control control = this.baseViewer.getControl();
        this.baseViewerMenu = new Menu(control);
        control.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (CSTNUEditor.this.editingEnabled) {
                    CSTNUEditor.this.baseViewerMenu.setLocation(e.x, e.y);
                    CSTNUEditor.this.baseViewerMenu.setData((Object)new Point(e.x, e.y));
                    CSTNUEditor.this.baseViewerMenu.setVisible(true);
                }
            }
        });
        this.mntmSaveAs = new MenuItem(this.baseViewerMenu, 0);
        this.mntmSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = ((MenuItem)e.widget).getParent();
                Point point = (Point)menu.getData();
                point = CSTNUEditor.this.baseViewer.getGraphControl().toControl(point);
                CSTNUEditor.this.addTimePoint(point.x, point.y);
            }
        });
        this.mntmSaveAs.setText("Add Time Point");
        this.mntmRemoveTimePoint = new MenuItem(this.baseViewerMenu, 0);
        this.mntmRemoveTimePoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSTNUEditor.this.removeTimePoint();
            }
        });
        this.mntmRemoveTimePoint.setText("Remove Time Point");
        this.mntmAddEdge = new MenuItem(this.baseViewerMenu, 0);
        this.mntmAddEdge.setEnabled(false);
        this.mntmAddEdge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CSTNUEditor.this.singleArrow) {
                    CSTNUEditor.this.addEdgePair();
                } else {
                    CSTNUEditor.this.addEdge();
                }
            }
        });
        this.mntmAddEdge.setText("Add Edge");
        this.mntmRemoveEdge = new MenuItem(this.baseViewerMenu, 0);
        this.mntmRemoveEdge.setEnabled(false);
        this.mntmRemoveEdge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSTNUEditor.this.removeEdge();
            }
        });
        this.mntmRemoveEdge.setText("Remove Edge");
        this.baseViewer.setLayoutAlgorithm(this.layoutObjects[this.layoutCombo.getSelectionIndex()], false);
        this.baseViewer.getGraphControl().getLightweightSystem().getUpdateManager().addUpdateListener(new UpdateListener(){

            public void notifyValidating() {
                for (GraphNode modelNode : CSTNUEditor.this.baseViewer.getGraphControl().getNodes()) {
                    CSTNUEditor.this.updateLocation(modelNode);
                }
            }

            public void notifyPainting(Rectangle damage, Map dirtyRegions) {
            }
        });
        this.baseViewer.getGraphControl().addSelectionListener((SelectionListener)new HighlightManager());
        this.baseViewer.getGraphControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objects;
                boolean addEdge = false;
                boolean removeTimePoint = false;
                boolean removeEdge = false;
                IStructuredSelection selection = (IStructuredSelection)CSTNUEditor.this.baseViewer.getSelection();
                if (selection.size() == 2 && (objects = selection.toArray())[0] instanceof LabeledTimePoint && objects[1] instanceof LabeledTimePoint) {
                    addEdge = true;
                }
                if (selection.size() == 1) {
                    Object object = selection.getFirstElement();
                    if (object instanceof LabeledTimePoint) {
                        removeTimePoint = true;
                    }
                    if (object instanceof LabeledEdge) {
                        removeEdge = true;
                    }
                    if (object instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
                        removeEdge = true;
                    }
                }
                CSTNUEditor.this.mntmRemoveTimePoint.setEnabled(removeTimePoint);
                CSTNUEditor.this.mntmAddEdge.setEnabled(addEdge);
                CSTNUEditor.this.mntmRemoveEdge.setEnabled(removeEdge);
            }
        });
        this.baseViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                if (CSTNUEditor.this.editingEnabled && !(selection = (IStructuredSelection)event.getSelection()).isEmpty() && selection.size() == 1) {
                    Object object = selection.getFirstElement();
                    if (object instanceof LabeledEdge) {
                        LabeledEdge edge = (LabeledEdge)object;
                        CSTNUEditor.this.editEdge(edge);
                    }
                    if (object instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
                        SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)object;
                        CSTNUEditor.this.editConstraintPair(pair);
                    }
                }
            }
        });
        final ImplicitEdgeFilter edgeFilter = new ImplicitEdgeFilter();
        this.baseViewer.addFilter((ViewerFilter)edgeFilter);
        this.btnBaseShowImplicitConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    CSTNUEditor.this.baseViewer.removeFilter(edgeFilter);
                } else {
                    CSTNUEditor.this.baseViewer.addFilter(edgeFilter);
                }
            }
        });
        this.btnBaseShowImplicitConstraints.setSelection(this.dialogSettings.getBoolean("Left.ShowImplicit"));
        if (this.btnBaseShowImplicitConstraints.getSelection()) {
            this.baseViewer.removeFilter((ViewerFilter)edgeFilter);
        }
        this.baseViewer.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    CSTNUEditor.this.setLayoutAlgorithm(0);
                    CSTNUEditor.this.solutionViewer.getGraphControl().applyLayout();
                }
            }
        });
        return leftArea;
    }

    private CSTNULabelProvider getGraphLabelProvider(boolean singleArrow) {
        if (singleArrow) {
            switch (this.editorPreferences.getSingleArrowType()) {
                case SEPERATE_CONTINGENT: {
                    return new ContingentLabelProvider(this.editorPreferences);
                }
            }
            return new SingleArrowCSTNULabelProvider(this.editorPreferences);
        }
        return new CSTNULabelProvider(this.editorPreferences);
    }

    private CSTNUContentProvider getGraphContentProvider(boolean singleArrow) {
        if (singleArrow) {
            switch (this.editorPreferences.getSingleArrowType()) {
                case SEPERATE_CONTINGENT: {
                    return new ContingentContentProvider();
                }
            }
            return new SingleArrowCSTNUContentProvider();
        }
        return new CSTNUContentProvider();
    }

    protected void editConstraintPair(SingleArrowCSTNUContentProvider.ConstraintPair constraintPair) {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        ConstraintPairDialog dialog = new ConstraintPairDialog(this.getEditorSite().getShell(), this.getGraphLabelProvider(this.btnSinglearrow.getSelection()));
        dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)tcn, constraintPair);
        dialog.create();
        if (dialog.open() == 0) {
            SingleArrowCSTNUContentProvider.ConstraintPair newPair = dialog.getConstraintPair();
            LabeledEdge newEdge = newPair.getForward();
            if (newEdge != null) {
                if (tcn instanceof ChangeableSTNU) {
                    ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
                } else {
                    tcn.updateConstraint((TCNEdge)newEdge);
                }
            }
            if ((newEdge = newPair.getBackward()) != null) {
                if (tcn instanceof ChangeableSTNU) {
                    ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
                } else {
                    tcn.updateConstraint((TCNEdge)newEdge);
                }
            }
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    protected void removeEdge() {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.baseViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof LabeledEdge) {
            LabeledEdge edge = (LabeledEdge)object;
            tcn.removeEdge((TCNEdge)edge);
            this.baseViewer.refresh(false);
            this.notifyEdit();
        } else if (object instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
            SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)object;
            if (pair.getForward() != null) {
                tcn.removeEdge((TCNEdge)pair.getForward());
            }
            if (pair.getBackward() != null) {
                tcn.removeEdge((TCNEdge)pair.getBackward());
            }
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    protected void editEdge(LabeledEdge oldEdge) {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        LabeledEdgeDialog dialog = new LabeledEdgeDialog(this.getEditorSite().getShell());
        dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)tcn, oldEdge);
        dialog.create();
        if (dialog.open() == 0) {
            LabeledEdge newEdge = dialog.getLabeledEdge();
            if (tcn instanceof ChangeableSTNU) {
                ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
            } else {
                tcn.updateConstraint((TCNEdge)newEdge);
            }
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    private void notifyEdit() {
        this.setDirty(true);
        this.solutionViewer.setInput(null);
        this.solutionViewer.refresh();
        this.btnCalculateDuration.setEnabled(false);
        this.setErrorMessage(null);
    }

    protected void removeTimePoint() {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.baseViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof LabeledTimePoint) {
            LabeledTimePoint timePoint = (LabeledTimePoint)object;
            tcn.removeTimePoint((TCNTimePoint)timePoint);
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    protected void addEdge() {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.baseViewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        if (!(objects[0] instanceof LabeledTimePoint)) {
            return;
        }
        LabeledTimePoint from = (LabeledTimePoint)objects[0];
        if (!(objects[1] instanceof LabeledTimePoint)) {
            return;
        }
        LabeledTimePoint to = (LabeledTimePoint)objects[1];
        LabeledEdgeDialog dialog = new LabeledEdgeDialog(this.getEditorSite().getShell());
        LabeledEdge oldEdge = (LabeledEdge)tcn.getEdge((TCNTimePoint)from, (TCNTimePoint)to);
        if (oldEdge == null) {
            dialog.init((TCN<LabeledTimePoint, LabeledEdge>)tcn, from, to);
        } else {
            dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)tcn, oldEdge);
        }
        dialog.create();
        if (dialog.open() == 0) {
            LabeledEdge newEdge = dialog.getLabeledEdge();
            if (tcn instanceof ChangeableSTNU) {
                ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
            } else {
                tcn.updateConstraint((TCNEdge)newEdge);
            }
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    protected void addEdgePair() {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.baseViewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        if (!(objects[0] instanceof LabeledTimePoint)) {
            return;
        }
        LabeledTimePoint from = (LabeledTimePoint)objects[0];
        if (!(objects[1] instanceof LabeledTimePoint)) {
            return;
        }
        LabeledTimePoint to = (LabeledTimePoint)objects[1];
        SingleArrowCSTNUContentProvider.ConstraintPair constraintPair = new SingleArrowCSTNUContentProvider.ConstraintPair(from, to);
        ConstraintPairDialog dialog = new ConstraintPairDialog(this.getEditorSite().getShell(), this.getGraphLabelProvider(this.btnSinglearrow.getSelection()));
        dialog.init((AbstractTCN<LabeledTimePoint, LabeledValueSet, LabeledEdge>)tcn, constraintPair);
        dialog.create();
        if (dialog.open() == 0) {
            SingleArrowCSTNUContentProvider.ConstraintPair newPair = dialog.getConstraintPair();
            LabeledEdge newEdge = newPair.getForward();
            if (newEdge != null) {
                if (tcn instanceof ChangeableSTNU) {
                    ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
                } else {
                    tcn.updateConstraint((TCNEdge)newEdge);
                }
            }
            if ((newEdge = newPair.getBackward()) != null) {
                if (tcn instanceof ChangeableSTNU) {
                    ((ChangeableSTNU)tcn).updateContingentConstraint(newEdge);
                } else {
                    tcn.updateConstraint((TCNEdge)newEdge);
                }
            }
            this.baseViewer.refresh(false);
            this.notifyEdit();
        }
    }

    protected void addTimePoint(int xLocation, int yLocation) {
        AbstractTCN tcn = (AbstractTCN)this.baseViewer.getInput();
        TimePointDialog dialog = new TimePointDialog(this.getEditorSite().getShell());
        dialog.init((TCN<LabeledTimePoint, LabeledEdge>)tcn);
        dialog.create();
        if (dialog.open() == 0) {
            LabeledTimePoint newTimePoint = dialog.getTimePoint();
            HashMap map = new HashMap();
            CSTNULayouting layout = (CSTNULayouting)ModelViewer.createView(map, CSTNULayouting.class);
            layout.setXCoord(xLocation);
            layout.setYCoord(yLocation);
            ((DefaultPluginDataContainer)newTimePoint).addSupportedPlugin("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", "de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", (PluginData)new DefaultPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", map));
            tcn.insertTimePoint((TCNTimePoint)newTimePoint);
            this.baseViewer.refresh(false);
            this.baseViewer.getGraphControl().layout();
            this.notifyEdit();
        }
    }

    protected void updateLocation(GraphNode node) {
        Object element = node.getData();
        if (element instanceof DefaultPluginDataContainer) {
            DefaultPluginDataContainer container = (DefaultPluginDataContainer)element;
            this.updateLocation(node, container);
        }
    }

    protected void setLayoutAlgorithm(int index) {
        LayoutAlgorithm layoutAlgorithm = this.layoutObjects[index];
        if (this.currentLayoutAlgorithm != layoutAlgorithm) {
            this.currentLayoutAlgorithm = layoutAlgorithm;
            this.baseViewer.setLayoutAlgorithm(this.currentLayoutAlgorithm, true);
            this.solutionViewer.getGraphControl().applyLayout();
            this.layoutCombo.select(index);
        }
    }

    protected void updateLocation(GraphNode node, DefaultPluginDataContainer container) {
        if (node.getLocation().x > 0 || node.getLocation().y > 0) {
            PluginData pluginData = container.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting");
            HashMap map = pluginData != null ? new HashMap(pluginData.getPluginData()) : new HashMap();
            boolean change = false;
            CSTNULayouting layoutData = (CSTNULayouting)ModelViewer.createView(map, CSTNULayouting.class);
            if (layoutData.getXCoord() != node.getLocation().x) {
                layoutData.setXCoord(node.getLocation().x);
                change = true;
            }
            if (layoutData.getYCoord() != node.getLocation().y) {
                layoutData.setYCoord(node.getLocation().y);
                change = true;
            }
            if (change) {
                container.addSupportedPlugin("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", "de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", (PluginData)new DefaultPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", map));
                this.setDirty(true);
            }
        } else {
            PluginData pluginData = container.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting");
            if (pluginData != null) {
                CSTNULayouting layoutData = (CSTNULayouting)ModelViewer.createView((Map)pluginData.getPluginData(), CSTNULayouting.class);
                node.setLocation((double)layoutData.getXCoord(), (double)layoutData.getYCoord());
            }
        }
    }

    protected void doCheckControllability() {
        this.setErrorMessage(null);
        IProgressService ps = this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        final TCN cstnu = (TCN)this.baseViewer.getInput();
        this.solutionViewer.setInput(null);
        this.btnCalculateDuration.setEnabled(false);
        final TCNSolver solver = TCNAlgorithms.getSolver((TCN)cstnu);
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Checking controllability...", 5);
                    ChangeableTCN result = (ChangeableTCN)cstnu.clone();
                    monitor.worked(1);
                    try {
                        try {
                            try {
                                solver.solve(result);
                            }
                            catch (InconsistencyException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            Display.getDefault().asyncExec(new Runnable(result){
                                private final /* synthetic */ ChangeableTCN val$result;
                                {
                                    this.val$result = changeableTCN;
                                }

                                @Override
                                public void run() {
                                    CSTNUEditor.this.solutionViewer.setInput((Object)this.val$result);
                                    CSTNUEditor.this.btnCalculateDuration.setEnabled(true);
                                }
                            });
                            throw throwable;
                        }
                        monitor.worked(1);
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.getCause().printStackTrace(pw);
            this.setErrorMessage(sw.toString());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void setFocus() {
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            this.selectionListener.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            this.selectionListener.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.currentSelection = selection;
        this.notifySelectionChanged(this.currentSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySelectionChanged(ISelection selection) {
        ISelectionChangedListener[] listeners;
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            listeners = this.selectionListener.toArray(new ISelectionChangedListener[this.selectionListener.size()]);
        }
        SelectionChangedEvent raiseEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ISelectionChangedListener[] iSelectionChangedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionChangedListener l = iSelectionChangedListenerArray[n2];
            try {
                l.selectionChanged(raiseEvent);
            }
            catch (Exception e) {
                CSTNUEditorActivator.handleError(this.getSite().getShell(), e);
            }
            ++n2;
        }
    }

    protected void setSingleArrow(boolean singleArrow) {
        this.singleArrow = singleArrow;
        this.baseViewer.setLabelProvider(null);
        this.solutionViewer.setLabelProvider(null);
        this.baseViewer.setContentProvider((IContentProvider)this.getGraphContentProvider(singleArrow));
        this.solutionViewer.setContentProvider((IContentProvider)this.getGraphContentProvider(singleArrow));
        this.baseViewer.setLabelProvider((IBaseLabelProvider)this.getGraphLabelProvider(singleArrow));
        this.solutionViewer.setLabelProvider((IBaseLabelProvider)this.getGraphLabelProvider(singleArrow));
    }

    public void saveState(IMemento memento) {
        memento.putBoolean("CSTNUEditor.SingleArrow", this.singleArrow);
    }

    public void restoreState(IMemento memento) {
        Boolean bool = memento.getBoolean("CSTNUEditor.SingleArrow");
        this.singleArrow = bool != null ? bool : false;
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCN() {
        return this.tcn;
    }
}

