/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.RTEDExecutionStrategy;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.aristaflow.adept2.model.timemodel.tcn.xml.TCNXMLExport;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.util.StreamTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.CSTNUEditorActivator;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editorinputs.TCNEditorInput;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentLabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ExecutionSelectionDialog;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.HighlightManager;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ImplicitEdgeFilter;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SWTResourceManager;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.layouts.StaticCSTNULayout;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.w3c.dom.Document;

public class CSTNUInstanceEditor
extends EditorPart
implements IZoomableWorkbenchPart,
ITabbedPropertySheetPageContributor,
ISelectionProvider,
ISelectionChangedListener,
IPersistableEditor {
    public static String ID = "de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUInstaceEditor";
    private Composite parentComposite;
    private CSTNUEditorPreferences editorPreferences;
    private IDialogSettings dialogSettings;
    private boolean singleArrow;
    private TCN<LabeledTimePoint, LabeledEdge> tcn;
    private GraphViewer tcnViewer;
    private boolean dirty;
    private Composite errorComposite;
    private Text errorText;
    private Set<ISelectionChangedListener> selectionListener = new HashSet<ISelectionChangedListener>();
    private ISelection currentSelection;
    private SashForm viewerContentArea;
    private Composite tcnViewerComposite;
    private RTEDExecutionStrategy executionStrategy;

    public CSTNUInstanceEditor() {
        this.editorPreferences = new CSTNUEditorPreferences(CSTNUEditorActivator.getDefault().getPreferenceStore());
        this.dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)CSTNUEditorActivator.getDefault().getDialogSettings(), (String)"CSTNUEditor");
        this.singleArrow = this.dialogSettings.getBoolean("SingleArrow");
        new TimeModelPreferences();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    protected void saveToFile(TCN<LabeledTimePoint, LabeledEdge> tcn, File file, int fileType, IProgressMonitor progressMonitor) throws IOException, CoreException {
        InputStream inputStream = null;
        try {
            switch (fileType) {
                case 1: {
                    break;
                }
                default: {
                    inputStream = this.saveTCNToXML(tcn, progressMonitor);
                }
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                StreamTools.copyStreamToStream((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, progressMonitor);
        this.setDirty(false);
    }

    private InputStream saveTCNToXML(TCN<LabeledTimePoint, LabeledEdge> tcn, Object object) {
        TCNXMLExport xmlExport = new TCNXMLExport();
        try {
            Document document = xmlExport.getDocumentForTCN(tcn);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLHelperTools.writeDocumentToStream((Document)document, (OutputStream)out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (XMLFormatException e) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"An error occurred", (String)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TCNEditorInput)) {
            throw new PartInitException("Wrong IEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void setInput(IEditorInput input) throws RuntimeException {
        this.setInputWithNotify(input);
    }

    protected void setInputWithNotify(IEditorInput input) throws RuntimeException {
        if (!(input instanceof TCNEditorInput)) {
            throw new RuntimeException("Wrong IEditorInput");
        }
        try {
            this.doSetInput(input);
            this.firePropertyChange(258);
        }
        catch (CoreException x) {
            CSTNUEditorActivator.handleError(this.getSite().getShell(), "Error Opening Editor Input", "An error occurred while opening the editor input!", x.getStatus());
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            super.setInput(input);
            this.setDirty(false);
            this.initializeTitle(input);
            this.updatePartControl(input);
        }
    }

    private void updatePartControl(IEditorInput input) throws CoreException {
        if (this.tcnViewer == null) {
            return;
        }
        if (input instanceof TCNEditorInput) {
            this.initializeContentFromTCN((TCNEditorInput)input);
        }
    }

    private void initializeContentFromTCN(TCNEditorInput input) {
        this.tcn = input.getTCN();
        this.doInitContent(this.tcn);
    }

    IProgressMonitor getProgressMonitor() {
        IActionBars bars = this.getEditorSite().getActionBars();
        IStatusLineManager statusLine = bars.getStatusLineManager();
        IProgressMonitor pm = statusLine.getProgressMonitor();
        return pm;
    }

    protected void doInitContent(TCN<LabeledTimePoint, LabeledEdge> tcn) {
        TCNSolver solver1;
        tcn.getTimePoints().iterator();
        this.tcnViewer.setInput(tcn);
        this.tcnViewer.getGraphControl().layout(true);
        this.doCheckControllability();
        TCN<LabeledTimePoint, LabeledEdge> cstnu = tcn;
        TCNSolver solver = solver1 = TCNAlgorithms.getSolver(cstnu);
        try {
            ChangeableSTNU stnu = (ChangeableSTNU)tcn;
            this.executionStrategy = new RTEDExecutionStrategy(solver, stnu);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tcn = tcn;
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                CSTNUInstanceEditor.this.getSite().getPage().closeEditor((IEditorPart)CSTNUInstanceEditor.this, save);
            }
        });
    }

    private void initializeTitle(IEditorInput input) {
        this.setPartName(input.getName());
        if (input.getImageDescriptor() != null) {
            this.setTitleImage(JFaceResources.getResources().createImageWithDefault(input.getImageDescriptor()));
        }
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.tcnViewer;
    }

    public void dispose() {
        this.dialogSettings.put("SingleArrow", this.singleArrow);
        super.dispose();
        if (this.getEditorInput() != null && this.getEditorInput().getImageDescriptor() != null) {
            JFaceResources.getResources().destroyImage(this.getEditorInput().getImageDescriptor());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.createContent(this.parentComposite);
        try {
            this.updatePartControl(this.getEditorInput());
        }
        catch (CoreException e) {
            e.printStackTrace();
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error initalizing Content", (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    protected void createContent(Composite parentComposite) {
        GridLayout gl_parentComposite = new GridLayout(1, false);
        gl_parentComposite.horizontalSpacing = 0;
        gl_parentComposite.verticalSpacing = 0;
        gl_parentComposite.marginWidth = 0;
        gl_parentComposite.marginHeight = 0;
        parentComposite.setLayout((Layout)gl_parentComposite);
        this.createViewerArea(parentComposite);
        this.viewerContentArea.setWeights(new int[]{245, 203});
        Composite composite = new Composite(parentComposite, 2048);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Button btnSinglearrow = new Button(composite, 32);
        btnSinglearrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                CSTNUInstanceEditor.this.setSingleArrow(button.getSelection());
            }
        });
        btnSinglearrow.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        btnSinglearrow.setText("Single Arrow");
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        btnSinglearrow.setSelection(this.singleArrow);
        this.setSingleArrow(btnSinglearrow.getSelection());
        this.tcnViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected Composite createViewerArea(Composite contentArea) {
        Composite rightArea = new Composite(contentArea, 0);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 1;
        rightArea.setLayoutData((Object)layoutData);
        GridLayout gl_rightArea = new GridLayout(1, false);
        gl_rightArea.marginWidth = 0;
        gl_rightArea.marginHeight = 0;
        rightArea.setLayout((Layout)gl_rightArea);
        this.viewerContentArea = new SashForm(rightArea, 512);
        this.viewerContentArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayoutFactory factory = GridLayoutFactory.fillDefaults().spacing(0, 0);
        this.viewerContentArea.setLayout((Layout)factory.create());
        final ImplicitEdgeFilter edgeFilter = new ImplicitEdgeFilter();
        this.tcnViewerComposite = new Composite((Composite)this.viewerContentArea, 0);
        this.tcnViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_tcnViewerComposite = new GridLayout(1, false);
        gl_tcnViewerComposite.verticalSpacing = 0;
        gl_tcnViewerComposite.marginWidth = 0;
        gl_tcnViewerComposite.marginHeight = 0;
        this.tcnViewerComposite.setLayout((Layout)gl_tcnViewerComposite);
        Composite buttonBar = new Composite(this.tcnViewerComposite, 0);
        GridLayout gl_buttonBar = new GridLayout(2, false);
        gl_buttonBar.marginWidth = 0;
        gl_buttonBar.marginHeight = 0;
        buttonBar.setLayout((Layout)gl_buttonBar);
        GridData gd_buttonBar = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_buttonBar.heightHint = 25;
        buttonBar.setLayoutData((Object)gd_buttonBar);
        Button nextStep = new Button(buttonBar, 8);
        nextStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSTNUInstanceEditor.this.performNextStep();
            }
        });
        nextStep.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        nextStep.setText("Next Step");
        Button btnSolutionShowImplicitConstraints = new Button(buttonBar, 32);
        btnSolutionShowImplicitConstraints.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        btnSolutionShowImplicitConstraints.setText("Show Implicit Constraints");
        btnSolutionShowImplicitConstraints.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    CSTNUInstanceEditor.this.tcnViewer.removeFilter(edgeFilter);
                } else {
                    CSTNUInstanceEditor.this.tcnViewer.addFilter(edgeFilter);
                }
            }
        });
        btnSolutionShowImplicitConstraints.setSelection(this.dialogSettings.getBoolean("Right.ShowImplicit"));
        if (btnSolutionShowImplicitConstraints.getSelection()) {
            this.tcnViewer.addFilter((ViewerFilter)edgeFilter);
        }
        this.tcnViewer = new GraphViewer(this.tcnViewerComposite, 0);
        Control control = this.tcnViewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tcnViewer.setLayoutAlgorithm((LayoutAlgorithm)new StaticCSTNULayout(1));
        this.tcnViewer.getGraphControl().addSelectionListener((SelectionListener)new HighlightManager());
        if (!btnSolutionShowImplicitConstraints.getSelection()) {
            this.tcnViewer.addFilter((ViewerFilter)edgeFilter);
        }
        this.tcnViewer.setLayoutAlgorithm((LayoutAlgorithm)new StaticCSTNULayout(1));
        this.errorComposite = new Composite((Composite)this.viewerContentArea, 0);
        this.errorComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.errorComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblModelIsInconsistent = new Label(this.errorComposite, 0);
        lblModelIsInconsistent.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        lblModelIsInconsistent.setForeground(SWTResourceManager.getColor(3));
        lblModelIsInconsistent.setText("Model is Inconsistent!");
        lblModelIsInconsistent.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.errorText = new Text(this.errorComposite, 2888);
        GridData gd_errorText = new GridData(4, 4, false, true, 1, 1);
        gd_errorText.widthHint = 100;
        this.errorText.setLayoutData((Object)gd_errorText);
        this.setErrorMessage(null);
        return this.viewerContentArea;
    }

    protected void doCheckControllability() {
        this.setErrorMessage(null);
        IProgressService ps = this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        final TCN cstnu = (TCN)this.tcnViewer.getInput();
        final TCNSolver solver = TCNAlgorithms.getSolver((TCN)cstnu);
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Checking controllability...", 5);
                    ChangeableTCN result = (ChangeableTCN)cstnu;
                    monitor.worked(1);
                    try {
                        try {
                            try {
                                solver.solve(result);
                            }
                            catch (InconsistencyException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CSTNUInstanceEditor.this.tcnViewer.refresh();
                                }
                            });
                            throw throwable;
                        }
                        monitor.worked(1);
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.getCause().printStackTrace(pw);
            this.setErrorMessage(sw.toString());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected void performNextStep() {
        RTEDExecutionStrategy.ExecutionDecision executionDecision = this.executionStrategy.getExecutionDecision();
        Collection activatedContingents = this.executionStrategy.getActivatedContingents();
        if (activatedContingents.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Execution Decision", (String)("Executing " + executionDecision.getTimepoints() + " at time " + executionDecision.getGoTime()));
            this.execute(executionDecision);
            this.tcnViewer.refresh();
        } else {
            ExecutionSelectionDialog dialog;
            boolean executeContingent;
            if (executionDecision.getTimepoints().isEmpty()) {
                executeContingent = true;
            } else {
                dialog = new MessageDialog(this.getSite().getShell(), "Execution Decision", null, "Wait for one of " + activatedContingents + "\n" + "or execute " + executionDecision.getTimepoints() + " at time " + executionDecision.getGoTime() + "? \n\n", 3, new String[]{"Wait", "Execute"}, 0);
                boolean bl = executeContingent = dialog.open() == 0;
            }
            if (executeContingent) {
                dialog = new ExecutionSelectionDialog(this.getSite().getShell(), this.tcn, activatedContingents);
                if (dialog.open() == 0) {
                    RTEDExecutionStrategy.ExecutionDecision execDec = dialog.getExecutionDecision();
                    this.execute(execDec);
                }
            } else {
                this.execute(executionDecision);
            }
            this.tcnViewer.refresh();
        }
    }

    private void execute(RTEDExecutionStrategy.ExecutionDecision executionDecision) {
        try {
            this.executionStrategy.execute((Collection)executionDecision.getTimepoints(), executionDecision.getGoTime());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error during Execution", (String)("Could not execute execution decision " + executionDecision + "\n" + "Reason: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void setErrorMessage(String message) {
        if (message == null) {
            this.errorComposite.setVisible(false);
            this.errorText.setText("");
            this.viewerContentArea.setMaximizedControl((Control)this.tcnViewerComposite);
        } else {
            this.errorComposite.setVisible(true);
            this.errorText.setText(message);
            this.viewerContentArea.setMaximizedControl(null);
        }
        this.errorComposite.getParent().layout(true, true);
    }

    private CSTNULabelProvider getGraphLabelProvider(boolean singleArrow) {
        if (singleArrow) {
            switch (this.editorPreferences.getSingleArrowType()) {
                case SEPERATE_CONTINGENT: {
                    return new ContingentLabelProvider(this.editorPreferences);
                }
            }
            return new SingleArrowCSTNULabelProvider(this.editorPreferences);
        }
        return new CSTNULabelProvider(this.editorPreferences);
    }

    private CSTNUContentProvider getGraphContentProvider(boolean singleArrow) {
        if (singleArrow) {
            switch (this.editorPreferences.getSingleArrowType()) {
                case SEPERATE_CONTINGENT: {
                    return new ContingentContentProvider();
                }
            }
            return new SingleArrowCSTNUContentProvider();
        }
        return new CSTNUContentProvider();
    }

    public void setFocus() {
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            this.selectionListener.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            this.selectionListener.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.currentSelection = selection;
        this.notifySelectionChanged(this.currentSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySelectionChanged(ISelection selection) {
        ISelectionChangedListener[] listeners;
        Set<ISelectionChangedListener> set = this.selectionListener;
        synchronized (set) {
            listeners = this.selectionListener.toArray(new ISelectionChangedListener[this.selectionListener.size()]);
        }
        SelectionChangedEvent raiseEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ISelectionChangedListener[] iSelectionChangedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionChangedListener l = iSelectionChangedListenerArray[n2];
            try {
                l.selectionChanged(raiseEvent);
            }
            catch (Exception e) {
                CSTNUEditorActivator.handleError(this.getSite().getShell(), e);
            }
            ++n2;
        }
    }

    protected void setSingleArrow(boolean singleArrow) {
        this.singleArrow = singleArrow;
        this.tcnViewer.setLabelProvider(null);
        this.tcnViewer.setContentProvider((IContentProvider)this.getGraphContentProvider(singleArrow));
        this.tcnViewer.setLabelProvider((IBaseLabelProvider)this.getGraphLabelProvider(singleArrow));
    }

    public void saveState(IMemento memento) {
        memento.putBoolean("CSTNUEditor.SingleArrow", this.singleArrow);
    }

    public void restoreState(IMemento memento) {
        Boolean bool = memento.getBoolean("CSTNUEditor.SingleArrow");
        this.singleArrow = bool != null ? bool : false;
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCN() {
        return this.tcn;
    }
}

