/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

public class CSTNULabelProvider
extends LabelProvider
implements ISelfStyleProvider {
    private static final String SEP = " ";
    protected Color controlEdgeColor;
    protected Color contingentEdgeColor;
    protected Color edgeColor;
    protected Color implicitEdgeColor;
    private CSTNUEditorPreferences editorPreferences;
    private CSTNUEditorPreferences.MultiArrowLabel labelType;
    private CSTNUEditorPreferences.ValueRepresentation valueRepresentation;

    public CSTNULabelProvider(CSTNUEditorPreferences editorPreferences) {
        this.editorPreferences = editorPreferences;
        Display display = Display.getCurrent();
        this.edgeColor = display.getSystemColor(16);
        this.controlEdgeColor = display.getSystemColor(2);
        this.contingentEdgeColor = display.getSystemColor(6);
        this.implicitEdgeColor = display.getSystemColor(15);
        this.labelType = editorPreferences.getMultiArrowLabel();
        this.valueRepresentation = editorPreferences.getValueRepresentation();
    }

    public void selfStyleConnection(Object element, GraphConnection connection) {
        this.setUpConnection(element, connection);
        if (element instanceof LabeledEdge) {
            LabeledEdge edge = (LabeledEdge)element;
            if (edge.isControlEdge()) {
                connection.setLineColor(this.controlEdgeColor);
            }
            if (edge.getFlowDirection() == TCNEdge.FlowDirection.BACKWARD) {
                connection.setWeight(-1.0);
            } else if (edge.getFlowDirection() == TCNEdge.FlowDirection.FORWARD && edge.isControlEdge()) {
                connection.setWeight(1.0);
                connection.setLineWidth(2);
            } else if (edge.getFlowDirection() == TCNEdge.FlowDirection.FORWARD) {
                connection.setWeight(0.5);
            } else {
                connection.setWeight(0.0);
            }
            if (edge.isImplicit()) {
                connection.setLineStyle(2);
                connection.setLineColor(this.implicitEdgeColor);
            }
            if (edge.isContingent()) {
                connection.setLineColor(this.contingentEdgeColor);
            }
        }
    }

    protected void setUpConnection(Object element, GraphConnection connection) {
        this.createTargetDecoration(connection, true);
        connection.setLineColor(this.edgeColor);
        Connection connectionFigure = connection.getConnectionFigure();
        for (Object x : connectionFigure.getChildren()) {
            if (!(x instanceof org.eclipse.draw2d.Label)) continue;
            org.eclipse.draw2d.Label lbl = (org.eclipse.draw2d.Label)x;
            ExtendedMidpointLocator locator = new ExtendedMidpointLocator(connectionFigure, 0, lbl);
            connectionFigure.setConstraint((IFigure)lbl, (Object)locator);
        }
        connection.setTooltip((IFigure)new org.eclipse.draw2d.Label(this.getToolTip(element)));
    }

    public void selfStyleNode(Object element, GraphNode node) {
        String toolTip = this.getToolTip(element);
        if (toolTip == null) {
            toolTip = this.getText(element);
        }
        if (toolTip != null) {
            node.setTooltip((IFigure)new org.eclipse.draw2d.Label(toolTip));
        }
    }

    public String getToolTip(Object element) {
        if (element instanceof LabeledTimePoint) {
            LabeledTimePoint node = (LabeledTimePoint)element;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(node.toString());
            stringBuilder.append("\n(");
            stringBuilder.append(node.getLabel());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        if (element instanceof LabeledEdge) {
            LabeledEdge edge = (LabeledEdge)element;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(edge.getSourceNode());
            stringBuilder.append(" -> ");
            stringBuilder.append(edge.getTargetNode());
            stringBuilder.append("\nValues:");
            for (LabeledValue value : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                stringBuilder.append("\n");
                stringBuilder.append(value);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof LabeledTimePoint) {
            LabeledTimePoint node = (LabeledTimePoint)element;
            return node.toString();
        }
        if (element instanceof LabeledEdge) {
            LabeledEdge edge = (LabeledEdge)element;
            StringBuilder builder = new StringBuilder();
            String sep = "";
            Collection labeledValues = ((LabeledValueSet)edge.getValue()).getLabeledValues();
            for (LabeledValue b : labeledValues) {
                builder.append(sep);
                switch (this.labelType) {
                    case MORRIS: {
                        this.appendMorris(builder, b);
                        break;
                    }
                    default: {
                        this.appendDefault(builder, b);
                    }
                }
                sep = SEP;
            }
            return builder.toString();
        }
        return super.getText(element);
    }

    protected void appendDefault(StringBuilder builder, LabeledValue b) {
        if (b instanceof ContingentLabeledValue) {
            ContingentLabeledValue c = (ContingentLabeledValue)b;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder caseLabel = ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)c.getCase()) ? stringBuilder.append("\\").append(c.getTrigger().toString().toLowerCase()).append("/") : stringBuilder.append("/").append(c.getTrigger().toString().toUpperCase()).append("\\");
            builder.append('<').append(c.getLabel().toString()).append(", ").append(this.getValueString(c.getSTNValue())).append(", ").append((CharSequence)caseLabel).append(", ").append(this.getValueString(c.getContingentValue())).append('>');
        } else {
            builder.append('<').append(b.getLabel().toString()).append(", ").append(this.getValueString(b.getValue())).append('>');
        }
    }

    protected void appendMorris(StringBuilder builder, LabeledValue b) {
        if (b instanceof ContingentLabeledValue) {
            ContingentLabeledValue c = (ContingentLabeledValue)b;
            String caseLabel = this.getCaseLabel(c.getCase(), c.getTrigger());
            builder.append('<').append(this.getObservationBinding(c.getLabel())).append(", ").append("\u25c7").append(", ").append(this.getValueString(c.getSTNValue())).append('>').append(SEP).append('<').append(this.getObservationBinding(c.getLabel())).append(", ").append(caseLabel).append(", ").append(this.getValueString(c.getContingentValue())).append('>');
        } else {
            builder.append('<').append(b.getLabel().toString()).append(", ").append(this.getValueString(b.getValue())).append('>');
        }
    }

    public String getValueString(TimeDistance value) {
        if (value.isInfinity()) {
            return String.valueOf(value.sign() > 0 ? "" : "-") + '\u221e';
        }
        switch (this.valueRepresentation) {
            case TIMESTAMP: {
                return value.toString();
            }
            case SECONDS: {
                return "" + value.toSeconds();
            }
        }
        return value.toString();
    }

    protected String getCaseLabel(ContingentLabeledValue.ConstraintCase constraintCase, LabeledTimePoint trigger) {
        StringBuilder stringBuilder = new StringBuilder();
        if (ContingentLabeledValue.ConstraintCase.LOWERCASE.equals((Object)constraintCase)) {
            stringBuilder.append("\\").append(trigger.toString().toLowerCase()).append("/");
        } else {
            stringBuilder.append("/").append(trigger.toString().toUpperCase()).append("\\");
        }
        return stringBuilder.toString();
    }

    protected String getObservationBinding(Label label) {
        return label.toString();
    }

    protected void createTargetDecoration(GraphConnection connection, boolean contingent) {
        Connection connectionFigure = connection.getConnectionFigure();
        PolylineConnection con = (PolylineConnection)connectionFigure;
        con.setTargetDecoration(this.createDecoration(connection, contingent));
    }

    protected void createSourceDecoration(GraphConnection connection, boolean contingent) {
        Connection connectionFigure = connection.getConnectionFigure();
        PolylineConnection con = (PolylineConnection)connectionFigure;
        con.setSourceDecoration(this.createDecoration(connection, contingent));
    }

    protected RotatableDecoration createDecoration(GraphConnection connection, boolean contingent) {
        PolylineDecoration decoration;
        int lineWidth = connection.getLineWidth();
        if (!contingent) {
            PolylineDecoration polyLine = new PolylineDecoration();
            if (lineWidth < 3) {
                polyLine.setScale(14.0, 6.0);
            } else {
                double logLineWith = (double)lineWidth / 2.0;
                polyLine.setScale(7.0 * logLineWith, 3.0 * logLineWith);
            }
            polyLine.setFill(contingent);
            polyLine.setLineWidth(lineWidth);
            decoration = polyLine;
        } else {
            PolygonDecoration polyGone = new PolygonDecoration();
            if (lineWidth < 3) {
                polyGone.setScale(14.0, 6.0);
            } else {
                double logLineWith = (double)lineWidth / 2.0;
                polyGone.setScale(7.0 * logLineWith, 3.0 * logLineWith);
            }
            polyGone.setFill(contingent);
            polyGone.setLineWidth(lineWidth);
            decoration = polyGone;
        }
        return decoration;
    }

    protected final class ExtendedMidpointLocator
    extends MidpointLocator {
        private final org.eclipse.draw2d.Label lbl;

        public ExtendedMidpointLocator(Connection c, int i, org.eclipse.draw2d.Label lbl) {
            super(c, i);
            this.lbl = lbl;
        }

        protected Point getReferencePoint() {
            Point p2;
            Point p1;
            int index;
            Connection conn = this.getConnection();
            List children = conn.getChildren();
            if (children.size() > 2) {
                for (Object x : children) {
                    if (!(x instanceof org.eclipse.draw2d.Label) || x == this.lbl) continue;
                    conn.remove((IFigure)x);
                    break;
                }
            }
            Point p = Point.SINGLETON;
            PointList points = conn.getPoints();
            if (points.size() % 2 == 0) {
                index = Math.max(points.size() / 2 - 1, 0);
                p1 = points.getPoint(index);
                p2 = points.getPoint(index + 1);
            } else {
                index = Math.max(points.size() / 2, 0);
                p1 = points.getPoint(index - 1);
                p2 = points.getPoint(index + 1);
            }
            Vector v = new Vector(new PrecisionPoint(p1), new PrecisionPoint(p2));
            Vector shiftVector = v.getDivided(v.getLength() == 0.0 ? 1.0 : v.getLength());
            shiftVector = shiftVector.getOrthogonalComplement();
            shiftVector = points.size() > 2 ? shiftVector.getMultiplied(10.0) : shiftVector.getMultiplied(20.0);
            PrecisionPoint shift = shiftVector.toPoint();
            p1 = p1.getTranslated((Point)shift);
            p2 = p2.getTranslated((Point)shift);
            p.x = (p2.x - p1.x) / 2 + p1.x;
            p.y = (p2.y - p1.y) / 2 + p1.y;
            conn.translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

