/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.zest.core.widgets.GraphConnection;

public class ContingentLabelProvider
extends SingleArrowCSTNULabelProvider {
    public ContingentLabelProvider(CSTNUEditorPreferences editorPreferences) {
        super(editorPreferences);
    }

    @Override
    public void selfStyleConnection(Object element, GraphConnection connection) {
        this.setUpConnection(element, connection);
        if (element instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
            SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)element;
            if (element instanceof ContingentContentProvider.RequirmentLink) {
                connection.setLineColor(this.edgeColor);
                connection.setLineWidth(1);
                this.createTargetDecoration(connection, false);
            } else if (element instanceof ContingentContentProvider.ContingentLink) {
                connection.setLineColor(this.contingentEdgeColor);
                connection.setLineWidth(2);
                this.createSourceDecoration(connection, true);
            } else if (element instanceof ContingentContentProvider.WaitLink) {
                connection.setLineColor(this.contingentEdgeColor);
                connection.setLineWidth(1);
                this.createSourceDecoration(connection, false);
            }
            if (pair.isImplicit()) {
                connection.setLineStyle(2);
                connection.setLineColor(this.implicitEdgeColor);
            }
        }
    }

    @Override
    protected void setUpConnection(Object element, GraphConnection connection) {
        connection.setLineColor(this.edgeColor);
        Connection connectionFigure = connection.getConnectionFigure();
        for (Object x : connectionFigure.getChildren()) {
            if (!(x instanceof org.eclipse.draw2d.Label)) continue;
            org.eclipse.draw2d.Label lbl = (org.eclipse.draw2d.Label)x;
            CSTNULabelProvider.ExtendedMidpointLocator locator = new CSTNULabelProvider.ExtendedMidpointLocator(connectionFigure, 0, lbl);
            connectionFigure.setConstraint((IFigure)lbl, (Object)locator);
        }
        connection.setTooltip((IFigure)new org.eclipse.draw2d.Label(this.getToolTip(element)));
    }

    @Override
    public String getText(Object element) {
        if (element instanceof ContingentContentProvider.RequirmentLink) {
            ContingentContentProvider.RequirmentLink pair = (ContingentContentProvider.RequirmentLink)element;
            return this.getText(pair);
        }
        if (element instanceof ContingentContentProvider.ContingentLink) {
            ContingentContentProvider.ContingentLink pair = (ContingentContentProvider.ContingentLink)element;
            return this.getText(pair);
        }
        if (element instanceof ContingentContentProvider.WaitLink) {
            ContingentContentProvider.WaitLink pair = (ContingentContentProvider.WaitLink)element;
            return this.getText(pair);
        }
        return super.getText(element);
    }

    protected String getText(ContingentContentProvider.RequirmentLink pair) {
        HashSet<Label> labels = new HashSet<Label>();
        if (pair.getForward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getForward().getValue()).getLabels()));
        }
        if (pair.getBackward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getBackward().getValue()).getLabels()));
        }
        StringBuilder s = new StringBuilder(120);
        for (Label label : labels) {
            this.appendRequirementLink(pair, s, label);
        }
        return s.toString();
    }

    private void appendRequirementLink(ContingentContentProvider.RequirmentLink pair, StringBuilder s, Label label) {
        LabeledValue value;
        TimeDistance flexMaxValue;
        LabeledValue value2;
        TimeDistance flexMinValue;
        String flexMinStr = pair.getBackward() != null ? ((flexMinValue = (value2 = this.scenarioProjection(label, (LabeledValueSet)pair.getBackward().getValue(), false)).getValue().neg()).isInfinity() ? "-\u221e" : this.getValueString(flexMinValue)) : "-\u221e";
        String flexMaxStr = pair.getForward() != null ? ((flexMaxValue = (value = this.scenarioProjection(label, (LabeledValueSet)pair.getForward().getValue(), false)).getValue()).isInfinity() ? "\u221e" : this.getValueString(flexMaxValue)) : "\u221e";
        s.append(this.getObservationBinding(label)).append(": ").append('[').append(flexMinStr).append(',').append(' ').append(flexMaxStr).append(']');
    }

    protected String getText(ContingentContentProvider.ContingentLink pair) {
        HashSet<Label> labels = new HashSet<Label>();
        if (pair.getForward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getForward().getValue()).getLabels()));
        }
        if (pair.getBackward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getBackward().getValue()).getLabels()));
        }
        StringBuilder s = new StringBuilder(120);
        for (Label label : labels) {
            this.appendContingentLink(pair, s, label);
        }
        return s.toString();
    }

    protected void appendContingentLink(ContingentContentProvider.ContingentLink pair, StringBuilder s, Label label) {
        String contMaxStr;
        String contMinStr;
        if (pair.getForward() != null && pair.getForward().isContingent()) {
            LabeledValue value = this.scenarioProjection(label, (LabeledValueSet)pair.getForward().getValue(), true);
            if (value instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)value;
                TimeDistance contMinValue = contingentLabeledValue.getContingentValue();
                contMinStr = this.getValueString(contMinValue);
            } else {
                contMinStr = "";
            }
        } else {
            contMinStr = "";
        }
        if (pair.getBackward() != null && pair.getBackward().isContingent()) {
            LabeledValue value = this.scenarioProjection(label, (LabeledValueSet)pair.getBackward().getValue(), true);
            if (value instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)value;
                TimeDistance contMaxValue = contingentLabeledValue.getContingentValue().neg();
                contMaxStr = this.getValueString(contMaxValue);
            } else {
                contMaxStr = "";
            }
        } else {
            contMaxStr = "";
        }
        s.append(this.getObservationBinding(label)).append(": ").append('[').append(contMinStr).append(',').append(' ').append(contMaxStr).append(']');
    }

    protected String getText(ContingentContentProvider.WaitLink pair) {
        HashSet<Label> labels = new HashSet<Label>();
        if (pair.getForward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getForward().getValue()).getLabels()));
        }
        if (pair.getBackward() != null) {
            labels.addAll(Arrays.asList(((LabeledValueSet)pair.getBackward().getValue()).getLabels()));
        }
        StringBuilder s = new StringBuilder(120);
        for (Label label : labels) {
            this.appendWaitlink(pair, s, label);
        }
        return s.toString();
    }

    protected void appendWaitlink(ContingentContentProvider.WaitLink pair, StringBuilder s, Label label) {
        String contMaxStr;
        String contMinStr;
        if (pair.getForward() != null && pair.getForward().isContingent()) {
            LabeledValue value = this.scenarioProjection(label, (LabeledValueSet)pair.getForward().getValue(), true);
            if (value instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)value;
                String caseLabel = this.getCaseLabel(contingentLabeledValue.getCase(), contingentLabeledValue.getTrigger());
                TimeDistance contMinValue = contingentLabeledValue.getContingentValue();
                contMinStr = String.valueOf(caseLabel) + ", " + this.getValueString(contMinValue);
            } else {
                contMinStr = "";
            }
        } else {
            contMinStr = "";
        }
        if (pair.getBackward() != null && pair.getBackward().isContingent()) {
            LabeledValue value = this.scenarioProjection(label, (LabeledValueSet)pair.getBackward().getValue(), true);
            if (value instanceof ContingentLabeledValue) {
                ContingentLabeledValue contingentLabeledValue = (ContingentLabeledValue)value;
                String caseLabel = this.getCaseLabel(contingentLabeledValue.getCase(), contingentLabeledValue.getTrigger());
                TimeDistance contMaxValue = contingentLabeledValue.getContingentValue().neg();
                contMaxStr = String.valueOf(caseLabel) + ", " + this.getValueString(contMaxValue);
            } else {
                contMaxStr = "";
            }
        } else {
            contMaxStr = "";
        }
        s.append(this.getObservationBinding(label)).append(':').append(' ').append('<').append(contMinStr).append(contMaxStr).append('>');
    }
}

