/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.RTEDExecutionStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ExecutionSelectionDialog
extends TitleAreaDialog {
    private Label executionTimeFrame;
    private Spinner spinner;
    private Combo combo;
    private TCN<LabeledTimePoint, LabeledEdge> tcn;
    private List<LabeledTimePoint> activatedContingents;
    private RTEDExecutionStrategy.ExecutionDecision executionDecision;

    public ExecutionSelectionDialog(Shell shell, TCN<LabeledTimePoint, LabeledEdge> tcn, Collection<LabeledTimePoint> activatedContingents) {
        super(shell);
        this.tcn = tcn;
        this.activatedContingents = new ArrayList<LabeledTimePoint>(activatedContingents);
    }

    public void create() {
        super.create();
        String[] items = new String[this.activatedContingents.size()];
        int i = 0;
        while (i < this.activatedContingents.size()) {
            items[i] = this.activatedContingents.get(i).toString();
            ++i;
        }
        this.combo.setItems(items);
        this.combo.select(0);
        this.selectTimePoint(this.activatedContingents.get(0));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Execution Decision");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblTimePoint = new Label(composite, 0);
        lblTimePoint.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTimePoint.setText("Time Point:");
        this.combo = new Combo(composite, 8);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionSelectionDialog.this.selectTimePoint((LabeledTimePoint)ExecutionSelectionDialog.this.activatedContingents.get(ExecutionSelectionDialog.this.combo.getSelectionIndex()));
            }
        });
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblExecutionTime = new Label(composite, 0);
        lblExecutionTime.setText("Execution Time:");
        this.spinner = new Spinner(composite, 2048);
        this.spinner.setMaximum(10000);
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblExecutionTimeFrame = new Label(composite, 0);
        lblExecutionTimeFrame.setText("Execution Time Frame");
        this.executionTimeFrame = new Label(composite, 0);
        this.executionTimeFrame.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.executionTimeFrame.setText("[, ]");
        return dialogArea;
    }

    protected void selectTimePoint(LabeledTimePoint tp) {
        LabeledEdge maxEdge = (LabeledEdge)this.tcn.getEdge((TCNTimePoint)((LabeledTimePoint)this.tcn.getTimeBaseEvent()), (TCNTimePoint)tp);
        LabeledEdge minEdge = (LabeledEdge)this.tcn.getEdge((TCNTimePoint)tp, (TCNTimePoint)((LabeledTimePoint)this.tcn.getTimeBaseEvent()));
        TimeDistance min = this.getValue(minEdge).neg();
        TimeDistance max = this.getValue(maxEdge);
        this.executionTimeFrame.setText("[" + min.toSeconds() + ", " + max.toSeconds() + "]");
        this.spinner.setSelection((int)min.toSeconds());
        this.spinner.setMinimum((int)min.toSeconds());
        this.spinner.setMaximum((int)max.toSeconds());
    }

    private TimeDistance getValue(LabeledEdge minEdge) {
        return this.getConstraintValue(minEdge).getValue();
    }

    private LabeledValue getConstraintValue(LabeledEdge minEdge) {
        return (LabeledValue)((LabeledValueSet)minEdge.getValue()).getLabeledValues().iterator().next();
    }

    protected void okPressed() {
        DefaultTimeDistance goTime = new DefaultTimeDistance((long)this.spinner.getSelection(), 0L, 0L, 0L, 0L);
        LabeledTimePoint timePoint = this.activatedContingents.get(this.combo.getSelectionIndex());
        this.executionDecision = new RTEDExecutionStrategy.ExecutionDecision((TimeDistance)goTime, Arrays.asList(timePoint));
        super.okPressed();
    }

    public RTEDExecutionStrategy.ExecutionDecision getExecutionDecision() {
        return this.executionDecision;
    }
}

