/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

final class HighlightManager
extends SelectionAdapter {
    private List<GraphConnection> highlightedConnections = new ArrayList<GraphConnection>();

    HighlightManager() {
    }

    public void widgetSelected(SelectionEvent e) {
        List selection = ((Graph)e.widget).getSelection();
        if (selection.size() == 1) {
            Object obj = selection.get(0);
            if (obj instanceof GraphNode) {
                GraphNode node = (GraphNode)obj;
                this.unhighlight();
                this.highlightedConnections.addAll(node.getSourceConnections());
                this.highlightedConnections.addAll(node.getTargetConnections());
                for (GraphConnection conn : this.highlightedConnections) {
                    if (conn.isDisposed() || conn.isHighlighted()) continue;
                    conn.highlight();
                    this.bringToFront(conn);
                }
            } else {
                this.highlightedConnections.remove(obj);
                this.unhighlight();
            }
        } else if (selection.size() > 1) {
            HashSet toHighlight = new HashSet();
            for (Object obj1 : selection) {
                for (Object obj2 : selection) {
                    if (obj1 == obj2) continue;
                    if (obj1 instanceof GraphNode && obj2 instanceof GraphNode) {
                        GraphNode node1 = (GraphNode)obj1;
                        GraphNode node2 = (GraphNode)obj2;
                        ArrayList l1 = new ArrayList();
                        l1.addAll(node1.getSourceConnections());
                        l1.addAll(node1.getTargetConnections());
                        ArrayList l2 = new ArrayList();
                        l2.addAll(node2.getSourceConnections());
                        l2.addAll(node2.getTargetConnections());
                        l1.retainAll(l2);
                        toHighlight.addAll(l1);
                        continue;
                    }
                    this.highlightedConnections.removeAll(selection);
                    this.unhighlight();
                    return;
                }
            }
            this.unhighlight();
            this.highlightedConnections.addAll(toHighlight);
            for (GraphConnection conn : this.highlightedConnections) {
                if (conn.isDisposed() || conn.isHighlighted()) continue;
                conn.highlight();
                this.bringToFront(conn);
            }
        } else {
            this.highlightedConnections.removeAll(selection);
            this.unhighlight();
        }
    }

    private void bringToFront(GraphConnection conn) {
        Connection child = conn.getConnectionFigure();
        IFigure parent = child.getParent();
        List children = parent.getChildren();
        children.remove(child);
        children.add(child);
        child.repaint();
    }

    private void unhighlight() {
        for (GraphConnection conn : this.highlightedConnections) {
            if (conn.isDisposed() || !conn.isHighlighted()) continue;
            conn.unhighlight();
        }
        this.highlightedConnections.clear();
    }
}

