/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUContentProvider;

public class SingleArrowCSTNUContentProvider
extends CSTNUContentProvider {
    protected TimeDistance minValue(LabeledValueSet values) {
        TimeDistance min = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        for (LabeledValue value : values.getLabeledValues()) {
            if (value.getValue().compareTo(min) >= 0) continue;
            min = value.getValue();
        }
        return min;
    }

    @Override
    public Object getSource(Object rel) {
        if (rel instanceof ConstraintPair) {
            ConstraintPair pair = (ConstraintPair)rel;
            if (pair.getForward() != null) {
                return pair.getForward().getSourceNode();
            }
            return pair.getBackward().getTargetNode();
        }
        return super.getSource(rel);
    }

    @Override
    public Object[] getRelationships(Object source, Object dest) {
        if (source instanceof LabeledTimePoint && dest instanceof LabeledTimePoint) {
            LabeledTimePoint from = (LabeledTimePoint)source;
            LabeledTimePoint to = (LabeledTimePoint)dest;
            LabeledEdge edge1 = (LabeledEdge)this.cstnu.getEdge((TCNTimePoint)from, (TCNTimePoint)to);
            LabeledEdge edge2 = (LabeledEdge)this.cstnu.getEdge((TCNTimePoint)to, (TCNTimePoint)from);
            if (edge1 != null || edge2 != null) {
                TimeDistance value2;
                TimeDistance value1;
                if (edge1 != null) {
                    if (TCNEdge.FlowDirection.FORWARD.equals((Object)edge1.getFlowDirection())) {
                        return this.createForwardRelationships(edge1, edge2);
                    }
                    if (TCNEdge.FlowDirection.BACKWARD.equals((Object)edge1.getFlowDirection())) {
                        return this.createBackwardRelationships(edge1, edge2);
                    }
                    value1 = this.minValue((LabeledValueSet)edge1.getValue());
                } else {
                    value1 = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
                }
                if (edge2 != null) {
                    if (TCNEdge.FlowDirection.FORWARD.equals((Object)edge2.getFlowDirection())) {
                        return this.createBackwardRelationships(edge1, edge2);
                    }
                    if (TCNEdge.FlowDirection.BACKWARD.equals((Object)edge2.getFlowDirection())) {
                        return this.createForwardRelationships(edge1, edge2);
                    }
                    value2 = this.minValue((LabeledValueSet)edge2.getValue());
                    value2 = value2.neg();
                } else {
                    value2 = DefaultTimeDistance.NEGATIVE_INFINITE_TIME_DISTANCE;
                }
                int compare = value1.compareTo(value2.neg());
                if (compare > 0) {
                    return this.createForwardRelationships(edge1, edge2);
                }
                if (compare == 0) {
                    if (from.hashCode() > to.hashCode()) {
                        return this.createForwardRelationships(edge1, edge2);
                    }
                    return this.createBackwardRelationships(edge1, edge2);
                }
                return this.createBackwardRelationships(edge1, edge2);
            }
        }
        return null;
    }

    protected Object[] createBackwardRelationships(LabeledEdge edge1, LabeledEdge edge2) {
        return new Object[0];
    }

    protected Object[] createForwardRelationships(LabeledEdge edge1, LabeledEdge edge2) {
        return new Object[]{new ConstraintPair(edge1, edge2)};
    }

    @Override
    public Object getDestination(Object rel) {
        if (rel instanceof ConstraintPair) {
            ConstraintPair pair = (ConstraintPair)rel;
            if (pair.getForward() != null) {
                return pair.getForward().getTargetNode();
            }
            return pair.getBackward().getSourceNode();
        }
        return super.getDestination(rel);
    }

    public static class ConstraintPair {
        private LabeledEdge forward;
        private LabeledEdge backward;
        private final LabeledTimePoint source;
        private final LabeledTimePoint target;

        public ConstraintPair(LabeledEdge edge1, LabeledEdge edge2) {
            this.setForward(edge1);
            this.setBackward(edge2);
            if (this.getForward() != null) {
                this.source = (LabeledTimePoint)this.getForward().getSourceNode();
                this.target = (LabeledTimePoint)this.getForward().getTargetNode();
            } else {
                this.source = (LabeledTimePoint)this.getBackward().getTargetNode();
                this.target = (LabeledTimePoint)this.getBackward().getSourceNode();
            }
        }

        public ConstraintPair(LabeledTimePoint source, LabeledTimePoint target) {
            this.source = source;
            this.target = target;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.getForward());
            s.append('\n');
            s.append(this.getBackward());
            return s.toString();
        }

        public boolean isImplicit() {
            if (this.getForward() != null && !this.getForward().isImplicit()) {
                return false;
            }
            return this.getBackward() == null || this.getBackward().isImplicit();
        }

        public boolean isContingent() {
            if (this.getForward() != null && this.getForward().isContingent()) {
                return true;
            }
            return this.getBackward() != null && this.getBackward().isContingent();
        }

        public boolean isControlEdge() {
            if (this.getForward() != null && this.getForward().isControlEdge()) {
                return true;
            }
            return this.getBackward() != null && this.getBackward().isControlEdge();
        }

        public LabeledTimePoint getSourceNode() {
            return this.source;
        }

        public LabeledTimePoint getTargetNode() {
            return this.target;
        }

        public LabeledEdge getForward() {
            return this.forward;
        }

        public LabeledEdge getBackward() {
            return this.backward;
        }

        public boolean isContingentDuration() {
            return this.getForward() != null ? this.getForward().isContingentDuration() : this.getBackward().isContingentDuration();
        }

        public void setForward(LabeledEdge forward) {
            this.forward = forward;
        }

        public void setBackward(LabeledEdge backward) {
            this.backward = backward;
        }
    }
}

