/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValueWithContingency;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.zest.core.widgets.GraphConnection;

public class SingleArrowCSTNULabelProvider
extends CSTNULabelProvider {
    private CSTNUEditorPreferences.SingleArrowType labelType;

    public SingleArrowCSTNULabelProvider(CSTNUEditorPreferences editorPreferences) {
        super(editorPreferences);
        this.labelType = editorPreferences.getSingleArrowType();
    }

    @Override
    public void selfStyleConnection(Object element, GraphConnection connection) {
        super.selfStyleConnection(element, connection);
        if (element instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
            SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)element;
            if (pair.isControlEdge()) {
                connection.setLineColor(this.controlEdgeColor);
                connection.setLineWidth(2);
            }
            if (pair.isContingent()) {
                connection.setLineColor(this.contingentEdgeColor);
            }
            if (pair.isImplicit()) {
                connection.setLineStyle(2);
                connection.setLineColor(this.implicitEdgeColor);
            }
            if (pair.isContingentDuration()) {
                this.createTargetDecoration(connection, true);
            } else {
                this.createTargetDecoration(connection, false);
            }
        }
    }

    @Override
    public String getToolTip(Object element) {
        if (element instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
            SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)element;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(pair.getSourceNode());
            stringBuilder.append(" -> ");
            stringBuilder.append(pair.getTargetNode());
            stringBuilder.append("\nValues:");
            stringBuilder.append("\n   -->");
            if (pair.getForward() != null) {
                for (LabeledValue value : ((LabeledValueSet)pair.getForward().getValue()).getLabeledValues()) {
                    stringBuilder.append("\t");
                    stringBuilder.append(value);
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("\n   <--");
            if (pair.getBackward() != null) {
                for (LabeledValue value : ((LabeledValueSet)pair.getBackward().getValue()).getLabeledValues()) {
                    stringBuilder.append("\t");
                    stringBuilder.append(value);
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("\nScenario Projections:\n");
            stringBuilder.append(this.getText(element));
            return stringBuilder.toString();
        }
        return super.getToolTip(element);
    }

    @Override
    public String getText(Object element) {
        if (element instanceof SingleArrowCSTNUContentProvider.ConstraintPair) {
            SingleArrowCSTNUContentProvider.ConstraintPair pair = (SingleArrowCSTNUContentProvider.ConstraintPair)element;
            HashSet<Label> labels = new HashSet<Label>();
            if (pair.getForward() != null) {
                labels.addAll(Arrays.asList(((LabeledValueSet)pair.getForward().getValue()).getLabels()));
            }
            if (pair.getBackward() != null) {
                labels.addAll(Arrays.asList(((LabeledValueSet)pair.getBackward().getValue()).getLabels()));
            }
            StringBuilder s = new StringBuilder(120);
            for (Label label : labels) {
                this.appendValuesForLabel(pair, s, label);
                s.append('\n');
            }
            return s.toString();
        }
        return super.getText(element);
    }

    private void appendGuardedValues(StringBuilder s, Label label, String flexMinStr, String flexMaxStr, String contMinPref, String contMinStr, String contMaxPref, String contMaxStr, String contingencyValue) {
        s.append(this.getObservationBinding(label)).append(": ").append('[');
        if (!contMinStr.isEmpty() && !contMaxStr.isEmpty()) {
            s.append('[').append(flexMinStr).append(", ").append(contMinStr).append(']');
            s.append(", ");
            s.append('[').append(contMaxStr).append(", ").append(flexMaxStr).append(']');
            s.append(']');
            if (!contingencyValue.isEmpty()) {
                s.append("\u2195");
                s.append(contingencyValue);
            }
        } else {
            s.append(flexMinStr).append(", ").append(flexMaxStr).append(']');
            if (!contMinStr.isEmpty()) {
                s.append(" ").append(contMinPref).append(contMinStr);
            }
            if (!contMaxStr.isEmpty()) {
                s.append(" ").append(contMaxPref).append(contMaxStr);
            }
        }
    }

    private void appendValues(StringBuilder s, Label label, String flexMinStr, String flexMaxStr, String contMinStr, String contMaxStr, String contingencyValue) {
        s.append(this.getObservationBinding(label)).append(": ").append('[').append(flexMinStr);
        if (contMinStr != "" || contMaxStr != "") {
            s.append(' ').append('[').append(contMinStr);
        }
        s.append(',').append(' ');
        if (contMinStr != "" || contMaxStr != "") {
            s.append(contMaxStr).append(']').append(' ');
        }
        s.append(flexMaxStr).append(']');
        if (!contingencyValue.isEmpty()) {
            s.append("\u2195");
            s.append(contingencyValue);
        }
    }

    private void appendValuesForLabel(SingleArrowCSTNUContentProvider.ConstraintPair pair, StringBuilder s, Label label) {
        String flexMaxStr;
        ContingentLabeledValueWithContingency valueWithContingency;
        ContingentLabeledValue contingentLabeledValue;
        String flexMinStr;
        LabeledValue value;
        String contMinStr = "";
        String contMinPref = "";
        String contMaxStr = "";
        String contMaxPref = "";
        String guardContValue = "";
        if (pair.getBackward() != null) {
            value = this.scenarioProjection(label, (LabeledValueSet)pair.getBackward().getValue(), false);
            TimeDistance flexMinValue = value.getValue().neg();
            String string = flexMinStr = flexMinValue.isInfinity() ? "-\u221e" : this.getValueString(flexMinValue);
            if (pair.getBackward().isContingent() && (value = this.scenarioProjection(label, (LabeledValueSet)pair.getBackward().getValue(), true)) instanceof ContingentLabeledValue) {
                contingentLabeledValue = (ContingentLabeledValue)value;
                TimeDistance contMaxValue = contingentLabeledValue.getContingentValue().neg();
                contMaxStr = this.getValueString(contMaxValue);
                contMaxPref = String.valueOf(this.getCaseLabel(contingentLabeledValue.getCase(), contingentLabeledValue.getTrigger())) + ":";
                if (value instanceof ContingentLabeledValueWithContingency) {
                    valueWithContingency = (ContingentLabeledValueWithContingency)value;
                    guardContValue = this.getValueString(valueWithContingency.getContingency());
                }
            }
        } else {
            flexMinStr = "-\u221e";
        }
        if (pair.getForward() != null) {
            value = this.scenarioProjection(label, (LabeledValueSet)pair.getForward().getValue(), false);
            TimeDistance flexMaxValue = value.getValue();
            String string = flexMaxStr = flexMaxValue.isInfinity() ? "\u221e" : this.getValueString(flexMaxValue);
            if (pair.getForward().isContingent() && (value = this.scenarioProjection(label, (LabeledValueSet)pair.getForward().getValue(), true)) instanceof ContingentLabeledValue) {
                contingentLabeledValue = (ContingentLabeledValue)value;
                TimeDistance contMinValue = contingentLabeledValue.getContingentValue();
                contMinStr = this.getValueString(contMinValue);
                contMinPref = String.valueOf(this.getCaseLabel(contingentLabeledValue.getCase(), contingentLabeledValue.getTrigger())) + ":";
                if (value instanceof ContingentLabeledValueWithContingency) {
                    valueWithContingency = (ContingentLabeledValueWithContingency)value;
                    guardContValue = this.getValueString(valueWithContingency.getContingency());
                }
            }
        } else {
            flexMaxStr = "\u221e";
        }
        switch (this.labelType) {
            case GUARDED: {
                this.appendGuardedValues(s, label, flexMinStr, flexMaxStr, contMinPref, contMinStr, contMaxPref, contMaxStr, guardContValue);
                break;
            }
            default: {
                this.appendValues(s, label, flexMinStr, flexMaxStr, String.valueOf(contMinPref) + contMinStr, String.valueOf(contMaxPref) + contMaxStr, guardContValue);
            }
        }
    }

    protected LabeledValue scenarioProjection(Label scenario, LabeledValueSet values, boolean contingent) {
        DefaultLabeledValue minValue = new DefaultLabeledValue(scenario, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE);
        TimeDistance min = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        for (LabeledValue value : values.getLabeledValues()) {
            if (!scenario.subsumes(value.getLabel())) continue;
            if (!contingent) {
                if (value.getValue().compareTo(min) >= 0) continue;
                min = value.getValue();
                minValue = value;
                continue;
            }
            if (!(value instanceof ContingentLabeledValue) || ((ContingentLabeledValue)value).getContingentValue().compareTo(min) > 0) continue;
            min = ((ContingentLabeledValue)value).getContingentValue();
            minValue = value;
        }
        return minValue;
    }
}

