/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.layouts;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.DAGLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.apache.commons.collections15.Transformer;
import org.eclipse.zest.layouts.algorithms.ContinuousLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class JungZestLayoutWrapper
extends ContinuousLayoutAlgorithm {
    public static final int CircleLayout = 0;
    public static final int FRLayout = 1;
    public static final int FRLayout2 = 2;
    public static final int ISOMLayout = 3;
    public static final int KKLayout = 4;
    public static final int SpringLayout = 5;
    public static final int DAGLayout = 6;
    public static final int SpringLayout2 = 7;
    public static final int StaticLayout = 8;
    Layout<InternalNode, InternalRelationship> baseLayout;
    private final int layout;

    public JungZestLayoutWrapper(int styles, int layout) {
        super(styles);
        this.layout = layout;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        Dimension dimension = new Dimension((int)width, (int)height);
        Graph<InternalNode, InternalRelationship> graphWrapper = this.initGraph(entitiesToLayout, relationshipsToConsider);
        this.baseLayout = this.getLayout(graphWrapper, dimension);
        this.baseLayout.initialize();
        this.baseLayout.setSize(dimension);
        this.baseLayout.setInitializer((Transformer)new Transformer<InternalNode, Point2D>(){

            public Point2D transform(InternalNode arg0) {
                return new Point2D.Double(arg0.getCurrentX(), arg0.getCurrentY());
            }
        });
    }

    protected boolean performAnotherNonContinuousIteration() {
        if (this.baseLayout instanceof IterativeContext) {
            IterativeContext process = (IterativeContext)this.baseLayout;
            return !process.done();
        }
        return false;
    }

    protected void computeOneIteration(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
        if (this.baseLayout instanceof IterativeContext) {
            IterativeContext process = (IterativeContext)this.baseLayout;
            process.step();
            this.applyLocations(this.baseLayout, entitiesToLayout);
        } else {
            this.applyLocations(this.baseLayout, entitiesToLayout);
        }
    }

    private Layout<InternalNode, InternalRelationship> getLayout(Graph<InternalNode, InternalRelationship> graphWrapper, Dimension dimension) {
        CircleLayout lay;
        switch (this.layout) {
            case 0: {
                lay = new CircleLayout(graphWrapper);
                break;
            }
            case 1: {
                lay = new FRLayout(graphWrapper);
                break;
            }
            case 2: {
                lay = new FRLayout2(graphWrapper);
                break;
            }
            case 3: {
                lay = new ISOMLayout(graphWrapper);
                break;
            }
            case 4: {
                lay = new KKLayout(graphWrapper);
                break;
            }
            case 5: {
                lay = new SpringLayout(graphWrapper);
                break;
            }
            case 6: {
                lay = new DAGLayout(graphWrapper);
                ((DAGLayout)lay).setRoot(graphWrapper);
                break;
            }
            case 7: {
                lay = new SpringLayout2(graphWrapper);
                break;
            }
            default: {
                return new StaticLayout(graphWrapper);
            }
        }
        return lay;
    }

    private void applyLocations(Layout<InternalNode, InternalRelationship> baseLayout, InternalNode[] entitiesToLayout) {
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode node = internalNodeArray[n2];
            Point2D point = (Point2D)baseLayout.transform((Object)node);
            node.setInternalLocation(point.getX(), point.getY());
            ++n2;
        }
    }

    private Graph<InternalNode, InternalRelationship> initGraph(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
        DirectedSparseGraph graph = new DirectedSparseGraph();
        InternalNode[] internalNodeArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            InternalNode node = internalNodeArray[n2];
            graph.addVertex((Object)node);
            ++n2;
        }
        internalNodeArray = relationshipsToConsider;
        n = relationshipsToConsider.length;
        n2 = 0;
        while (n2 < n) {
            InternalNode edge = internalNodeArray[n2];
            graph.addEdge((Object)edge, (Object)edge.getSource(), (Object)edge.getDestination());
            ++n2;
        }
        return graph;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    public String toString() {
        switch (this.layout) {
            case 0: {
                return "CircleLayout";
            }
            case 1: {
                return "FRLayout";
            }
            case 2: {
                return "FRLayout2";
            }
            case 3: {
                return "ISOMLayout";
            }
            case 4: {
                return "KKLayout";
            }
            case 5: {
                return "SpringLayout (very slow!)";
            }
            case 6: {
                return "DAGLayout";
            }
            case 7: {
                return "SpringLayout2 (slow)";
            }
            case 8: {
                return "StaticLayout";
            }
        }
        return "Error";
    }
}

