/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CSTNUEditorPreferences
implements IPropertyChangeListener {
    private static final String CONF_PREFIX = "CSTNUEditorPreferences.";
    public static final String CONF_MULTI_ARROW_LABEL = "CSTNUEditorPreferences.MultiArrowLabel";
    public static final String CONF_MULTI_ARROW_LABEL_DEFAULT = MultiArrowLabel.DEFAULT.toString();
    public static final String CONF_MULTI_ARROW_LABEL_MORRIS = MultiArrowLabel.MORRIS.toString();
    public static final String CONF_SINGLE_ARROW_TYPE = "CSTNUEditorPreferences.SingleArrowType";
    public static final String CONF_SINGLE_ARROW_TYPE_MIXED = SingleArrowType.MIXED.toString();
    public static final String CONF_SINGLE_ARROW_TYPE_SEPERATE_CONTINGENT = SingleArrowType.SEPERATE_CONTINGENT.toString();
    public static final String CONF_SINGLE_ARROW_TYPE_SEPERATE_GUARDED = SingleArrowType.GUARDED.toString();
    public static final String CONF_VALUE_REPRESENTATION = "CSTNUEditorPreferences.";
    public static final String CONF_VALUE_REPRESENTATION_TIMESTAMP = ValueRepresentation.TIMESTAMP.toString();
    public static final String CONF_VALUE_REPRESENTATION_SECONDS = ValueRepresentation.SECONDS.toString();
    private IPreferenceStore store;

    public CSTNUEditorPreferences(IPreferenceStore store) {
        this.store = store;
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public MultiArrowLabel getMultiArrowLabel() {
        String value = this.store.getString(CONF_MULTI_ARROW_LABEL);
        try {
            MultiArrowLabel arrowLabel = MultiArrowLabel.valueOf(value);
            return arrowLabel != null ? arrowLabel : MultiArrowLabel.DEFAULT;
        }
        catch (Exception exception) {
            return MultiArrowLabel.DEFAULT;
        }
    }

    public SingleArrowType getSingleArrowType() {
        String value = this.store.getString(CONF_SINGLE_ARROW_TYPE);
        try {
            SingleArrowType arrowType = SingleArrowType.valueOf(value);
            return arrowType != null ? arrowType : SingleArrowType.MIXED;
        }
        catch (Exception exception) {
            return SingleArrowType.MIXED;
        }
    }

    public ValueRepresentation getValueRepresentation() {
        String value = this.store.getString("CSTNUEditorPreferences.");
        try {
            ValueRepresentation valueRepresentation = ValueRepresentation.valueOf(value);
            return valueRepresentation != null ? valueRepresentation : ValueRepresentation.TIMESTAMP;
        }
        catch (Exception exception) {
            return ValueRepresentation.TIMESTAMP;
        }
    }

    public static enum MultiArrowLabel {
        DEFAULT,
        MORRIS;

    }

    public static enum SingleArrowType {
        MIXED,
        SEPERATE_CONTINGENT,
        GUARDED;

    }

    public static enum ValueRepresentation {
        TIMESTAMP,
        SECONDS;

    }
}

