/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.propertysections;

import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.CSTNUEditorActivator;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.dialogs.LabeledValuesControl;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.ContingentLabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNUContentProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.SingleArrowCSTNULabelProvider;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.preferences.CSTNUEditorPreferences;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConstraintPairPropertySection
extends AbstractPropertySection {
    private SingleArrowCSTNUContentProvider.ConstraintPair value;
    private LabeledValuesControl forwardValueControl;
    private Label label;
    private LabeledValuesControl backwardValueControl;
    private CSTNUEditorPreferences editorPreferences = new CSTNUEditorPreferences(CSTNUEditorActivator.getDefault().getPreferenceStore());
    private Text overallLabel;

    public LabelProvider getLabelProvider() {
        switch (this.editorPreferences.getSingleArrowType()) {
            case SEPERATE_CONTINGENT: {
                return new ContingentLabelProvider(this.editorPreferences);
            }
        }
        return new SingleArrowCSTNULabelProvider(this.editorPreferences);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        Label lbl = this.getWidgetFactory().createLabel(composite, "Edge:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 4);
        lbl.setLayoutData((Object)data);
        this.label = this.getWidgetFactory().createLabel(composite, "");
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment(0, 4);
        this.label.setLayoutData((Object)data);
        Label forwardLabel = this.getWidgetFactory().createLabel(composite, "Forward");
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 42);
        data.top = new FormAttachment((Control)this.label, 4);
        forwardLabel.setLayoutData((Object)data);
        this.forwardValueControl = new LabeledValuesControl(composite, 8);
        this.getWidgetFactory().adapt((Composite)this.forwardValueControl);
        data = new FormData(-1, 100);
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(50, 42);
        data.top = new FormAttachment((Control)forwardLabel, 0);
        data.bottom = new FormAttachment(100, -4);
        this.forwardValueControl.setLayoutData(data);
        Label backwardLabel = this.getWidgetFactory().createLabel(composite, "Backward");
        data = new FormData();
        data.left = new FormAttachment((Control)this.forwardValueControl, 6);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this.label, 4);
        backwardLabel.setLayoutData((Object)data);
        this.backwardValueControl = new LabeledValuesControl(composite, 8);
        this.getWidgetFactory().adapt((Composite)this.backwardValueControl);
        data = new FormData(-1, 100);
        data.left = new FormAttachment((Control)this.forwardValueControl, 6);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)backwardLabel, 0);
        data.bottom = new FormAttachment(100, -4);
        this.backwardValueControl.setLayoutData(data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof SingleArrowCSTNUContentProvider.ConstraintPair));
        this.value = (SingleArrowCSTNUContentProvider.ConstraintPair)input;
    }

    public void refresh() {
        if (this.value.getForward() != null) {
            LabeledEdge forward = this.value.getForward();
            this.forwardValueControl.init(null, (LabeledTimePoint)forward.getSourceNode(), (LabeledTimePoint)forward.getTargetNode(), ((LabeledValueSet)forward.getValue()).getLabeledValues());
        } else {
            this.forwardValueControl.init(null, this.value.getSourceNode(), this.value.getTargetNode(), new ArrayList<LabeledValue>());
        }
        if (this.value.getBackward() != null) {
            LabeledEdge backward = this.value.getBackward();
            this.backwardValueControl.init(null, (LabeledTimePoint)backward.getSourceNode(), (LabeledTimePoint)backward.getTargetNode(), ((LabeledValueSet)backward.getValue()).getLabeledValues());
        } else {
            this.backwardValueControl.init(null, this.value.getTargetNode(), this.value.getSourceNode(), new ArrayList<LabeledValue>());
        }
        this.label.setText(this.value.getSourceNode() + " -> " + this.value.getTargetNode());
    }
}

