/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards;

import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTNTimeModelFactory;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTimeModelFactory;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.EclipseTools;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editorinputs.TemplateTimeModelEditorInput;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.editors.CSTNUEditor;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards.AdvancedTransformationAdvancedWizardPage;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards.AdvancedTransformationWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AdvancedTransformationWizard
extends Wizard {
    private AdvancedTransformationWizardPage basePage;
    private Template template;
    private AdvancedTransformationAdvancedWizardPage advancedPage;

    public AdvancedTransformationWizard(Template template) {
        this.template = template;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.basePage = new AdvancedTransformationWizardPage();
        this.addPage(this.basePage);
        this.advancedPage = new AdvancedTransformationAdvancedWizardPage();
        this.addPage(this.advancedPage);
    }

    public boolean performFinish() {
        BaseConfiguration configuration = new BaseConfiguration();
        final TimeModelPreferences.TimeModelType type = this.basePage.getTimeModelType();
        this.basePage.getConfiguration((Configuration)configuration);
        this.advancedPage.getConfiguration((Configuration)configuration);
        IRunnableWithProgress op = new IRunnableWithProgress((Configuration)configuration){
            private final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    TemplateTimeModel templateTimeModel = AdvancedTransformationWizard.this.createTimeModelForTemplate(type, this.val$configuration, AdvancedTransformationWizard.this.template);
                    final TemplateTimeModelEditorInput editorInput = new TemplateTimeModelEditorInput(AdvancedTransformationWizard.this.template.getName(), templateTimeModel);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            EclipseTools.openEditor(CSTNUEditor.ID, editorInput);
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private TemplateTimeModel createTimeModelForTemplate(TimeModelPreferences.TimeModelType timeModelType, Configuration configuration, Template template) {
        TimeModelFactory timeModelFactory = this.createTimeModelFactory(timeModelType, configuration);
        TemporalTemplate temporalTemplate = timeModelFactory.createTemporalTemplate(template);
        TemplateTimeModel timeModel = timeModelFactory.createTimeModelForTemplate(temporalTemplate);
        return timeModel;
    }

    public TimeModelFactory createTimeModelFactory(TimeModelPreferences.TimeModelType type, Configuration configuration) {
        CSTNTimeModelFactory timeModelFactory = null;
        switch (type) {
            case CSTN: {
                timeModelFactory = new CSTNTimeModelFactory(configuration);
                break;
            }
            case CSTNU: {
                configuration.setProperty("TCNTransformation.AdvancedActivityTransformation", (Object)0);
                timeModelFactory = new CSTNUTimeModelFactory(configuration);
                break;
            }
            default: {
                configuration.setProperty("TCNTransformation.AdvancedActivityTransformation", (Object)1);
                timeModelFactory = new CSTNUTimeModelFactory(configuration);
            }
        }
        return timeModelFactory;
    }

    public boolean canFinish() {
        return super.canFinish();
    }
}

