/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards;

import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards.ITimeModelTransformationWizardPage;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards.TimeDistanceControl;
import java.util.Arrays;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AdvancedTransformationWizardPage
extends WizardPage
implements ITimeModelTransformationWizardPage {
    private Combo combo;
    private TimeDistanceControl controlMinTimeLag;
    private TimeDistanceControl controlMaxTimeLag;
    private TimeDistanceControl structureMinTimeLag;
    private TimeDistanceControl structureMaxTimeLag;
    private TimeDistanceControl structureMinDuration;
    private TimeDistanceControl structureMaxDuration;
    private TimeDistanceControl structureXORMaxDuration;

    protected AdvancedTransformationWizardPage() {
        super("Advanced Transformation");
        this.setTitle("Time Model");
        this.setMessage("Select the Time Model");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTimeModel = new Label(container, 0);
        lblTimeModel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTimeModel.setText("Time Model");
        this.combo = new Combo(container, 8);
        String[] timeModels = new String[TimeModelPreferences.TimeModelType.values().length];
        int i = 0;
        TimeModelPreferences.TimeModelType[] timeModelTypeArray = TimeModelPreferences.TimeModelType.values();
        int n = timeModelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeModelPreferences.TimeModelType type = timeModelTypeArray[n2];
            timeModels[i++] = type.toString();
            ++n2;
        }
        this.combo.setItems(timeModels);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTransformationWizardPage.this.setPageComplete(AdvancedTransformationWizardPage.this.combo.getSelectionIndex() != 0);
            }
        });
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        new Label(container, 0);
        final Button btnUseDefault = new Button(container, 32);
        btnUseDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedTransformationWizardPage.this.setUseDefault(btnUseDefault.getSelection());
            }
        });
        btnUseDefault.setSelection(true);
        btnUseDefault.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        btnUseDefault.setText("Use Default");
        Group grpControlFlow = new Group(container, 0);
        grpControlFlow.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpControlFlow.setText("Control Flow");
        grpControlFlow.setLayout((Layout)new GridLayout(2, false));
        Label lblMinTimeLag = new Label((Composite)grpControlFlow, 0);
        GridData gd_lblMinTimeLag = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMinTimeLag.widthHint = 120;
        lblMinTimeLag.setLayoutData((Object)gd_lblMinTimeLag);
        lblMinTimeLag.setText("Min time lag:");
        this.controlMinTimeLag = new TimeDistanceControl((Composite)grpControlFlow, 0);
        Label lblMaxTimeLag = new Label((Composite)grpControlFlow, 0);
        GridData gd_lblMaxTimeLag = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMaxTimeLag.widthHint = 120;
        lblMaxTimeLag.setLayoutData((Object)gd_lblMaxTimeLag);
        lblMaxTimeLag.setText("Max time Lag");
        this.controlMaxTimeLag = new TimeDistanceControl((Composite)grpControlFlow, 0);
        Group grpStructureNodes = new Group(container, 0);
        grpStructureNodes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpStructureNodes.setText("Structure Nodes");
        grpStructureNodes.setLayout((Layout)new GridLayout(2, false));
        Label lblMinTimeLag_1 = new Label((Composite)grpStructureNodes, 0);
        GridData gd_lblMinTimeLag_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMinTimeLag_1.widthHint = 120;
        lblMinTimeLag_1.setLayoutData((Object)gd_lblMinTimeLag_1);
        lblMinTimeLag_1.setText("Min time lag:");
        this.structureMinTimeLag = new TimeDistanceControl((Composite)grpStructureNodes, 0);
        Label lblMaxTimeLag_1 = new Label((Composite)grpStructureNodes, 0);
        GridData gd_lblMaxTimeLag_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMaxTimeLag_1.widthHint = 120;
        lblMaxTimeLag_1.setLayoutData((Object)gd_lblMaxTimeLag_1);
        lblMaxTimeLag_1.setText("Max time lag:");
        this.structureMaxTimeLag = new TimeDistanceControl((Composite)grpStructureNodes, 0);
        Label lblMinDuration = new Label((Composite)grpStructureNodes, 0);
        GridData gd_lblMinDuration = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMinDuration.widthHint = 120;
        lblMinDuration.setLayoutData((Object)gd_lblMinDuration);
        lblMinDuration.setText("Min duration:");
        this.structureMinDuration = new TimeDistanceControl((Composite)grpStructureNodes, 0);
        Label lblMaxDuration = new Label((Composite)grpStructureNodes, 0);
        GridData gd_lblMaxDuration = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMaxDuration.widthHint = 120;
        lblMaxDuration.setLayoutData((Object)gd_lblMaxDuration);
        lblMaxDuration.setText("Max duration:");
        this.structureMaxDuration = new TimeDistanceControl((Composite)grpStructureNodes, 0);
        Label lblXorMaxDuration = new Label((Composite)grpStructureNodes, 0);
        GridData gd_lblXorMaxDuration = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblXorMaxDuration.widthHint = 120;
        lblXorMaxDuration.setLayoutData((Object)gd_lblXorMaxDuration);
        lblXorMaxDuration.setText("XOR max duration:");
        this.structureXORMaxDuration = new TimeDistanceControl((Composite)grpStructureNodes, 0);
        this.initDefault();
    }

    protected void setUseDefault(boolean useDefault) {
        this.controlMinTimeLag.setEnabled(!useDefault);
        this.controlMaxTimeLag.setEnabled(!useDefault);
        this.structureMinTimeLag.setEnabled(!useDefault);
        this.structureMaxTimeLag.setEnabled(!useDefault);
        this.structureMinDuration.setEnabled(!useDefault);
        this.structureMaxDuration.setEnabled(!useDefault);
        this.structureXORMaxDuration.setEnabled(!useDefault);
    }

    private void initDefault() {
        TimeModelPreferences preferences = TimeModelPreferences.getInstance();
        TimeModelPreferences.TimeModelType timeModelType = preferences.getTimeModelType();
        int index = Arrays.asList(this.combo.getItems()).indexOf(timeModelType.toString());
        this.combo.select(index);
        this.controlMinTimeLag.setTimeDistance(preferences.getControlFlowMinTimeLag());
        this.controlMaxTimeLag.setTimeDistance(preferences.getControlFlowMaxTimeLag());
        this.structureMinTimeLag.setTimeDistance(preferences.getStructureNodeMinTimeLag());
        this.structureMaxTimeLag.setTimeDistance(preferences.getStructureNodeMaxTimeLag());
        this.structureMinDuration.setTimeDistance(preferences.getStructureNodeMinDuration());
        this.structureMaxDuration.setTimeDistance(preferences.getStructureNodeMaxDuration());
        this.structureXORMaxDuration.setTimeDistance(preferences.getXORSplitMaxDuration());
        this.setUseDefault(true);
    }

    public TimeModelPreferences.TimeModelType getTimeModelType() {
        return TimeModelPreferences.TimeModelType.valueOf((String)this.combo.getItem(this.combo.getSelectionIndex()));
    }

    @Override
    public void getConfiguration(Configuration configuration) {
        configuration.setProperty("TCNTransformation.ControlFlowMinTimeLag", (Object)this.controlMinTimeLag.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.ControlFlowMaxTimeLag", (Object)this.controlMaxTimeLag.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.StructureNodeMinTimeLag", (Object)this.structureMinTimeLag.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.StructureNodeMaxTimeLag", (Object)this.structureMaxTimeLag.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.StructureNodeMinDuration", (Object)this.structureMinDuration.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.StructureNodeMaxDuration", (Object)this.structureMaxDuration.getTimeDistance().toMilliseconds());
        configuration.setProperty("TCNTransformation.XORSplitMaxDuration", (Object)this.structureXORMaxDuration.getTimeDistance().toMilliseconds());
    }
}

