/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards;

import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.DefaultCSTN;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.DefaultCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.xml.TCNXMLExport;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards.NewCSTNUWizardPage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewCSTNUWizard
extends Wizard
implements INewWizard {
    private NewCSTNUWizardPage page;
    private ISelection selection;

    public NewCSTNUWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewCSTNUWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final String type = this.page.getType();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewCSTNUWizard.this.doFinish(containerName, fileName, type, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, String type, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(type);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(String type) throws CoreException {
        DefaultCSTNU cstnu;
        ArrayList nodes = new ArrayList();
        ArrayList edges = new ArrayList();
        ArrayList labels = new ArrayList();
        if ("CSTNU".equals(type)) {
            cstnu = new DefaultCSTNU(nodes, edges, labels);
        } else if ("CSTN".equals(type)) {
            cstnu = new DefaultCSTN(nodes, edges, labels);
        } else {
            throw new CoreException((IStatus)new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", "Unknown selection for type!"));
        }
        TCNXMLExport export = new TCNXMLExport();
        InputStream inputStream = null;
        try {
            inputStream = export.getInputStreamForTCN((TCN)cstnu);
        }
        catch (XMLFormatException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"An error occurred", (String)e.getMessage());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"An error occurred", (String)e.getMessage());
        }
        return inputStream;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "de.uniulm.dbis.aristaflow.time.ui.cstnueditor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

