/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.aristaflow.time.ui.cstnueditor.wizards;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class TimeDistanceControl
extends Composite {
    private Spinner sp_min;
    private Spinner sp_sec;
    private Spinner sp_milis;
    private Button btnInfinity;
    private Label lblMs;
    private Label lblM;
    private Label lblS;

    public TimeDistanceControl(Composite parent, int style) {
        super(parent, style);
        this.createContent(this);
    }

    private void createContent(TimeDistanceControl composite) {
        composite.setLayoutData(new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(9, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label labelControl = new Label((Composite)composite, 0);
        labelControl.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        this.sp_min = new Spinner((Composite)composite, 2048);
        this.lblM = new Label((Composite)composite, 0);
        GridData gd_lblM = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblM.minimumWidth = 10;
        this.lblM.setLayoutData((Object)gd_lblM);
        this.lblM.setText("m");
        this.sp_sec = new Spinner((Composite)composite, 2048);
        this.lblS = new Label((Composite)composite, 0);
        GridData gd_lblS = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblS.minimumWidth = 10;
        this.lblS.setLayoutData((Object)gd_lblS);
        this.lblS.setText("s");
        this.sp_milis = new Spinner((Composite)composite, 2048);
        this.lblMs = new Label((Composite)composite, 0);
        GridData gd_lblMs = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMs.minimumWidth = 10;
        this.lblMs.setLayoutData((Object)gd_lblMs);
        this.lblMs.setText("ms");
        Label sep = new Label((Composite)composite, 0);
        GridData gd_sep = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sep.widthHint = 25;
        sep.setLayoutData((Object)gd_sep);
        this.btnInfinity = new Button((Composite)composite, 32);
        this.btnInfinity.setText("Infinity");
        this.btnInfinity.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimeDistanceControl.this.setInfinity(TimeDistanceControl.this.btnInfinity.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setInfinity(boolean infinity) {
        this.sp_milis.setEnabled(!infinity);
        this.sp_min.setEnabled(!infinity);
        this.sp_sec.setEnabled(!infinity);
    }

    public void setTimeDistance(TimeDistance td) {
        this.sp_milis.setSelection((int)td.getMilliseconds());
        this.sp_sec.setSelection((int)td.getSeconds());
        this.sp_min.setSelection((int)td.getMinutes());
        if (td.isInfinity()) {
            this.btnInfinity.setSelection(true);
            this.setInfinity(true);
        }
    }

    public TimeDistance getTimeDistance() {
        TimeDistance td;
        if (this.btnInfinity.getSelection()) {
            td = DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE;
        } else {
            int milis = this.sp_milis.getSelection();
            int sec = this.sp_sec.getSelection();
            int min = this.sp_min.getSelection();
            td = new DefaultTimeDistance((long)milis, (long)sec, (long)min, 0L, 0L, 0L);
        }
        return td;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.sp_milis.setEnabled(enabled);
        this.sp_min.setEnabled(enabled);
        this.sp_sec.setEnabled(enabled);
        this.lblM.setEnabled(enabled);
        this.lblMs.setEnabled(enabled);
        this.lblS.setEnabled(enabled);
        this.btnInfinity.setEnabled(enabled);
        if (enabled) {
            this.setInfinity(this.btnInfinity.getSelection());
        }
    }
}

