/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.htmltemplates.ui;

import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.extensions.htmltemplates.HTMLTemplateTools;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ActivityConfigurationPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.util.Base64;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HTMLTemplateEnvironmentPageSet
extends ExecutableComponentWizard {
    boolean pagesAdded = false;

    public void init(ActivityPnPWizardData data) {
        super.init(data);
        this.addPage((IWizardPage)new HTMLTemplateEnvironmentPage());
        this.addPage((IWizardPage)new ActivityConfigurationPage(data, null));
    }

    public class HTMLTemplateEnvironmentPage
    extends WizardPage {
        protected HTMLTemplateEnvironmentPage() {
            super("HTMLTemplateEnvironmentPage");
            this.setTitle("HTML Template");
            this.setDescription("Set the HTML form template.");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            ActivityPnPWizardData data = HTMLTemplateEnvironmentPageSet.this.getData();
            Button btnSetTemplate = new Button(composite, 8);
            btnSetTemplate.setText("Choose HTML file ...");
            btnSetTemplate.addSelectionListener((SelectionListener)new SelectHTMLListener(btnSetTemplate, data));
            this.setControl((Control)composite);
        }

        private final class SelectHTMLListener
        extends SelectionAdapter {
            private final Button btnSetTemplate;
            private final ActivityPnPWizardData data;

            private SelectHTMLListener(Button btnSetTemplate, ActivityPnPWizardData data) {
                this.btnSetTemplate = btnSetTemplate;
                this.data = data;
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(this.btnSetTemplate.getShell(), 4096);
                String fileName = fileDialog.open();
                if (fileName != null) {
                    boolean storeInTemplate = MessageDialog.openQuestion((Shell)this.btnSetTemplate.getShell(), (String)"Store in activity?", (String)"Store the form within the activity? If not, the HTML file is expected to be in the data directory of the HTML template environment");
                    this.data.getConfiguration().setString("FormFile", new File(fileName).getName());
                    String formBase64 = Base64.encodeFromFile((String)fileName);
                    if (storeInTemplate) {
                        this.data.getConfiguration().setString("Form", formBase64);
                    } else {
                        this.data.getConfiguration().remove("Form");
                    }
                    String form = new String(Base64.decode((String)formBase64));
                    Map outParams = HTMLTemplateTools.parseOutputParameters((String)form);
                    Map inParams = HTMLTemplateTools.parseInputParameters((String)form);
                    for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : outParams.entrySet()) {
                        this.fixParameterInData(this.data, entry, ActivityConstants.AccessType.WRITE);
                    }
                    for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : inParams.entrySet()) {
                        this.fixParameterInData(this.data, entry, ActivityConstants.AccessType.READ);
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    for (ProcessModelParameter p : this.data.getParameters(ActivityConstants.AccessType.READ)) {
                        if (inParams.containsKey(p.getName())) continue;
                        hashSet.add(p.getName());
                    }
                    for (String name : hashSet) {
                        this.data.removeParameter(name, ActivityConstants.AccessType.READ);
                    }
                    hashSet.clear();
                    for (ProcessModelParameter p : this.data.getParameters(ActivityConstants.AccessType.WRITE)) {
                        if (outParams.containsKey(p.getName())) continue;
                        hashSet.add(p.getName());
                    }
                    for (String name : hashSet) {
                        this.data.removeParameter(name, ActivityConstants.AccessType.WRITE);
                    }
                }
            }

            private void fixParameterInData(ActivityPnPWizardData data, Map.Entry<String, ProcessConstants.AdeptDataType> entry, ActivityConstants.AccessType accesType) {
                ProcessModelParameter parameter = data.getParameter(entry.getKey(), accesType);
                if (parameter != null && parameter.getDataType() != entry.getValue()) {
                    data.removeParameter(entry.getKey(), accesType);
                }
                if (parameter == null || parameter.getDataType() != entry.getValue()) {
                    ProcessModelFactory pmf;
                    try {
                        pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory("FIXME");
                    }
                    catch (ServiceNotKnownException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    UUID identifierID = parameter != null ? parameter.getIdentifierID() : ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
                    boolean optional = parameter != null ? parameter.isOptional() : false;
                    String pDescription = parameter != null ? parameter.getDescription() : "";
                    ActivityConfiguration pconf = parameter == null ? null : parameter.getConfiguration();
                    ProcessModelParameter p = pmf.createProcessModelParameter(entry.getKey(), pDescription, entry.getValue(), null, identifierID, optional, false, false, null, pconf, null, null);
                    data.addParameter(p, accesType);
                }
            }
        }
    }
}

