/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.bshsupport.ui;

import bsh.ParseException;
import bsh.Parser;
import bsh.TokenMgrError;
import de.aristaflow.adept2.extensions.bshsupport.ui.Activator;
import de.aristaflow.adept2.extensions.bshsupport.ui.SimpleShellWidget;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.util.StringTools;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BSHWizardPageSet
extends ExecutableComponentWizard {
    public void init(ActivityPnPWizardData data) {
        super.init(data);
        this.addPage((IWizardPage)new BSHWizardPage());
    }

    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
        block10: {
            if (type != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED && type != PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED && type != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_ADDED && type != PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_CHANGED) break block10;
            final ProcessModelParameter param = type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED || type == PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_ADDED ? (ProcessModelParameter)affectedObject : ((ProcessModelParameter[])affectedObject)[1];
            final ActivityConstants.AccessType accessType = type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED || type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED ? ActivityConstants.AccessType.READ : ActivityConstants.AccessType.WRITE;
            String fixedParamName = null;
            String paramName = param.getName();
            StringBuilder newParamNameBuilder = new StringBuilder();
            int index = 0;
            int c = paramName.charAt(index);
            if (!Character.isJavaIdentifierStart((char)c)) {
                if (Character.isJavaIdentifierPart((char)c)) {
                    newParamNameBuilder.append('_');
                    c = Character.toUpperCase((char)c);
                } else {
                    c = 95;
                }
            } else {
                c = Character.toLowerCase((char)c);
            }
            newParamNameBuilder.append((char)c);
            ++index;
            boolean camelCase = false;
            while (index < paramName.length()) {
                block13: {
                    block14: {
                        block11: {
                            block12: {
                                c = paramName.charAt(index);
                                if (Character.isJavaIdentifierPart((char)c)) break block11;
                                if (!Character.isWhitespace((char)c) && c != 45) break block12;
                                camelCase = true;
                                break block13;
                            }
                            camelCase = false;
                            c = 95;
                            break block14;
                        }
                        if (camelCase) {
                            c = Character.toUpperCase((char)c);
                            camelCase = false;
                        }
                    }
                    newParamNameBuilder.append((char)c);
                }
                ++index;
            }
            if (!paramName.contentEquals(newParamNameBuilder)) {
                fixedParamName = newParamNameBuilder.toString();
            }
            if (fixedParamName != null) {
                String testName;
                int i = 1;
                while (true) {
                    testName = i == 1 ? fixedParamName : String.valueOf(fixedParamName) + i;
                    boolean inUse = false;
                    for (ProcessModelParameter testParam : this.getData().getParameters(accessType)) {
                        if (!testParam.getName().equals(testName)) continue;
                        inUse = true;
                        break;
                    }
                    if (!inUse) break;
                    ++i;
                }
                fixedParamName = testName;
                final ProcessModelParameter newParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(fixedParamName, param.getDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BSHWizardPageSet.this.getData().changeParameter(param, newParam, accessType);
                        String msg = "BSH requires parameter names that are legal Java identifiers. The parameter name '%s' contained illegal characters and was therefore changed to '%s' instead.";
                        msg = String.format(msg, param.getName(), newParam.getName());
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Illegal Characters in Parameter Name", (String)msg);
                    }
                });
                return;
            }
        }
    }

    protected class BSHWizardPage
    extends WizardPage {
        SimpleShellWidget txtScript;

        protected BSHWizardPage() {
            super("BSHWizardPage");
            this.setTitle("BeanShell Script");
            this.setDescription("Enter or change the script");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label lblHead = new Label(container, 0);
            lblHead.setText("Enter the Script:");
            this.txtScript = new SimpleShellWidget(container, 0);
            String script = BSHWizardPageSet.this.getData().getConfiguration().getString("Script");
            if (script == null) {
                script = "";
            }
            this.txtScript.setScript(script);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 250;
            this.txtScript.setLayoutData(gridData);
            final Color highlightColor = new Color((Device)container.getShell().getDisplay(), 255, 50, 50);
            this.txtScript.addModifyListener(new ModifyListener(){

                /*
                 * Unable to fully structure code
                 */
                public void modifyText(ModifyEvent e) {
                    block7: {
                        script = BSHWizardPage.this.txtScript.getScript();
                        BSHWizardPage.access$0(BSHWizardPage.this).getData().getConfiguration().setString("Script", script);
                        BSHWizardPage.this.txtScript.setTextColor(null);
                        BSHWizardPage.this.setErrorMessage(null);
                        parser = new Parser((Reader)new StringReader(script));
                        try {
                            while (!parser.Line()) {
                                parser.popNode();
                            }
                            break block7;
                        }
                        catch (ParseException ex) {
                            range = new StyleRange();
                            range.background = highlightColor;
                            lastToken = parser.token;
                            ** while (lastToken.next != null)
                        }
lbl-1000:
                        // 1 sources

                        {
                            lastToken = lastToken.next;
                            continue;
                        }
lbl19:
                        // 1 sources

                        lineStart = BSHWizardPage.this.indexOfLine(script, lastToken.beginLine - 1);
                        endLineStart = BSHWizardPage.this.indexOfLine(script, lastToken.endLine - 1);
                        range.start = lineStart + lastToken.beginColumn;
                        range.length = endLineStart + lastToken.endColumn - range.start + 1;
                        if (range.start + range.length > script.length()) {
                            --range.start;
                        }
                        if (range.length > 0 && range.start + range.length <= script.length()) {
                            BSHWizardPage.this.txtScript.setTextColor(range);
                        }
                        BSHWizardPage.this.setErrorMessage(ex.getMessage());
                        break block7;
                        catch (TokenMgrError v0) {}
                    }
                }
            });
            Label lblHelp = new Label(container, 64);
            lblHelp.setText("The script has to have valid BeanShell syntax, i.e. a relaxed Java syntax. All input parameters can be used as variables. For all (non-optional) output parameters, a variable with the name of the parameter must be set after the execution of the script.");
            gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 200;
            lblHelp.setLayoutData((Object)gridData);
            lblHelp.setBackground(container.getBackground());
            Label lblAuxJars = new Label(container, 64);
            gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 300;
            lblAuxJars.setLayoutData((Object)gridData);
            lblAuxJars.setText("Specify additional class paths (directories and/or jar files as file URIs, may use ${arflow:arflow.libdir}) separated by a semicolon (;)");
            final Text txtAuxJars = new Text(container, 2052);
            String classPath = StringTools.join((String)"; ", (List)BSHWizardPageSet.this.getData().getClassPath());
            txtAuxJars.setText(classPath);
            gridData = new GridData(4, 4, true, false);
            txtAuxJars.setLayoutData((Object)gridData);
            txtAuxJars.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (txtAuxJars.getText().equals("")) {
                        BSHWizardPageSet.this.getData().setClassPath(new ArrayList());
                    } else {
                        BSHWizardPageSet.this.getData().setClassPath(Arrays.asList(txtAuxJars.getText().split("\\s*;\\s")));
                    }
                }
            });
            this.setControl((Control)container);
        }

        public int indexOfLine(String s, int line) {
            if (line < 1) {
                return 0;
            }
            if (line == 1) {
                return s.indexOf("\n");
            }
            return s.indexOf("\n", this.indexOfLine(s, line - 1) + 1);
        }

        public boolean canFlipToNextPage() {
            this.txtScript.setFocus();
            return super.canFlipToNextPage();
        }
    }
}

