/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.sardialogue;

import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.ui.sardialogue.EntityQuickSearchFilterProvider;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.widgets.Composite;

public class EntityListUIComponent
extends FilteredListUIComponent {
    public static final String COL_ENTITY = "entity";

    public EntityListUIComponent(Composite parent, FilterFactory filterFactory) {
        super(parent, 67586, (QuickSearchFilterProvider)new EntityQuickSearchFilterProvider(filterFactory));
    }

    protected void registerColumns() {
        super.registerColumns();
        this.registerColumn(COL_ENTITY, "Entity", 16384, new ColumnData(1.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Entity entity = (Entity)element;
                String attribute = entity.containsAttribute("username") ? "username" : "name";
                String name = entity.getString(attribute);
                String id = entity.get("id").toString();
                if (entity.getInteger("id") == Long.MIN_VALUE) {
                    id = "<unknown>";
                }
                return String.valueOf(name) + " (#" + id + ")";
            }
        }, null);
        String sortColumn = COL_ENTITY;
        boolean sortAscending = true;
        if (this.isColumnShown(sortColumn)) {
            this.setSortColumn(sortColumn, sortAscending);
        }
    }
}

