/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.sardialogue;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import java.io.Serializable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EntityQuickSearchFilterProvider
implements QuickSearchFilterProvider {
    final FilterFactory filterFac;
    final Attribute idAttribute;
    final Attribute nameAttribute;
    final Attribute usernameAttribute;

    public EntityQuickSearchFilterProvider(FilterFactory filterFactory) {
        this.filterFac = filterFactory;
        AttributeFactory afTempl = filterFactory.createAttributeFactory(Entity.class);
        this.idAttribute = afTempl.selectAttribute("getInteger", new Serializable[]{"id"});
        this.usernameAttribute = afTempl.selectAttribute("getString", new Serializable[]{"username"});
        this.nameAttribute = afTempl.selectAttribute("getString", new Serializable[]{"name"});
    }

    public ViewerFilter getQuickSearchFilter(final String filterString) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Entity) {
                    StringBuilder filter = new StringBuilder("*");
                    filter.append(filterString);
                    filter.append("*");
                    ComparisonFilter idFilter = EntityQuickSearchFilterProvider.this.filterFac.createComparisonFilter(EntityQuickSearchFilterProvider.this.idAttribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
                    Attribute attribute = ((Entity)element).containsAttribute("username") ? EntityQuickSearchFilterProvider.this.usernameAttribute : EntityQuickSearchFilterProvider.this.nameAttribute;
                    ComparisonFilter nameFilter = EntityQuickSearchFilterProvider.this.filterFac.createComparisonFilter(attribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
                    MultipleFilterFilter searchFilter = EntityQuickSearchFilterProvider.this.filterFac.createOrFilter(new Filter[]{idFilter, nameFilter});
                    return searchFilter.matches(element);
                }
                Entity[] entityArray = (Entity[])element;
                int i = 0;
                while (i < entityArray.length) {
                    if (this.select(viewer, parentElement, entityArray[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
    }
}

