/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.sardialogue;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.ComplexEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.DynamicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.OrgPolicyParser;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.OrgModelConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.ui.sardialogue.Activator;
import de.aristaflow.adept2.ui.sardialogue.DefaultEntityLabelProvider;
import de.aristaflow.adept2.ui.sardialogue.EntityListUIComponent;
import de.aristaflow.adept2.ui.sardialogue.OrgUnitEntityLabelProvider;
import de.aristaflow.adept2.ui.sardialogue.ProblemsContentProvider;
import de.aristaflow.adept2.ui.sardialogue.ProblemsTableLabelProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.statushandling.WhiteErrorDialogue;
import de.aristaflow.adept2.ui.systemdata.ParameterBindingsUIComponent;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SimpleStaffAssignmentRuleDialogue
implements StaffAssignmentRuleDialogue {
    protected static final String UNKNOWN_ID_DUMMY = "<unknown>";
    protected static final long UNKNOWN_ID_VALUE = Long.MIN_VALUE;
    protected static final String UNKNOWN_NAME_DUMMY = "<not in the org model>";
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private Shell parentShell;
    private OldStaffAssignmentRuleDialog dialogue;
    private boolean wasConfirmed;
    private OrgModelManager omm;
    protected DependencyProvider dependencyProvider;

    SimpleStaffAssignmentRuleDialogue(Shell parentShell, OrgModelManager omm) {
        this.parentShell = parentShell;
        this.omm = omm;
    }

    public boolean open(String originalSAR) {
        this.dialogue = new OldStaffAssignmentRuleDialog(this.parentShell, originalSAR, this.omm);
        int returnCode = this.dialogue.open();
        this.wasConfirmed = returnCode == 0;
        return this.dialogue.wasPolicyChanged();
    }

    public boolean open(String originalSAR, DependencyProvider dependencyProvider) {
        ArgChecks.checkForNull((Object)dependencyProvider, (String)"dependencyProvider");
        this.dependencyProvider = dependencyProvider;
        this.dialogue = new OldStaffAssignmentRuleDialog(this.parentShell, originalSAR, this.omm);
        int returnCode = this.dialogue.open();
        this.wasConfirmed = returnCode == 0;
        return this.dialogue.wasPolicyChanged();
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    public boolean wasStaffAssignmentRuleChanged() {
        return this.dialogue.wasPolicyChanged();
    }

    public String getStaffAssignmentRule() {
        return this.dialogue.getPolicy();
    }

    public Map<String, Dependency> getParameterBindings() {
        return this.dialogue.getParameterBindings();
    }

    private static enum ConditionTarget {
        AGENT("Agent", ProcessConstants.AdeptDataType.INTEGER, EntityType.AGENT.identifierID()),
        ORG_POSITION("Org. Position", ProcessConstants.AdeptDataType.INTEGER, EntityType.ORG_POSITION.identifierID()),
        AGENT_SUPERIOR("Agent's Superior(s)", ProcessConstants.AdeptDataType.INTEGER, EntityType.ORG_POSITION.identifierID()),
        DYNAMIC_ENTITY_EXPRESSION("Dynamic Entity Expression", ProcessConstants.AdeptDataType.STRING, OrgModelConstants.IDENTIFIER_ID_ENTITY_EXPRESSION);

        final String displayName;
        private final ProcessConstants.AdeptDataType dataType;
        private final UUID identifierID;

        private ConditionTarget(String displayName, ProcessConstants.AdeptDataType dataType, UUID identifierID) {
            this.displayName = displayName;
            this.dataType = dataType;
            this.identifierID = identifierID;
        }

        public String displayName() {
            return this.displayName;
        }

        public ProcessConstants.AdeptDataType dataType() {
            return this.dataType;
        }

        public UUID identifierID() {
            return this.identifierID;
        }
    }

    private static class DependantCondition {
        final ConditionTarget target;
        final Dependency dependency;

        public DependantCondition(ConditionTarget target, Dependency dependency) {
            ArgChecks.checkForNull((Object)((Object)target), (String)"target");
            ArgChecks.checkForNull((Object)dependency, (String)"dependency");
            this.target = target;
            this.dependency = dependency;
        }

        public ConditionTarget getTarget() {
            return this.target;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            DependantCondition depCond = (DependantCondition)obj;
            if (!depCond.getTarget().equals((Object)this.getTarget())) {
                return false;
            }
            return depCond.getDependency().equals((Object)this.getDependency());
        }

        public int hashCode() {
            return this.target.hashCode() ^ this.dependency.hashCode();
        }
    }

    private class OldStaffAssignmentRuleDialog
    extends Dialog {
        private static final int SELECTION_LIST_WIDTH = 200;
        private static final int SELECTION_LIST_HEIGHT = 150;
        Color color_underlineFailure;
        Color color_underlineWarning;
        Color color_underlineNeutral;
        Color color_highlightAffectedRange;
        CTabFolder tabFolder_editModes;
        Button button_identifierMode;
        private StructuredViewer listViewer_availableAgents;
        private StructuredViewer listViewer_selectedAgents;
        private StructuredViewer listViewer_availableOrgPositions;
        private StructuredViewer listViewer_selectedOrgPositions;
        private StructuredViewer listViewer_availableOrgUnits;
        private StructuredViewer listViewer_selectedOrgUnits;
        private Combo combo_roleForOrgUnit;
        private ComboViewer comboViewer_roleForOrgUnit;
        private Button button_OrgUnitRoleConnection;
        private StructuredViewer listViewer_availableRoles;
        private StructuredViewer listViewer_selectedRoles;
        private org.eclipse.swt.widgets.List list_assignmentPreview;
        private Button button_assignmentPreviewRefresh;
        private Button checkbox_assignmentPreviewAutoRefresh;
        private Text text_assistedEditPolicyPreview;
        StyledText text_manualEditPolicy;
        TableViewer tableViewer_problems;
        TableColumn column_problems;
        private Label labelAgentOrgUnitInfo;
        private Label labelOrgPositionOrgUnitInfo;
        OrgPolicyReport currentProblems;
        ParameterRef[] currentReferencedParameters;
        OrgModelManager omm;
        private Map<Long, Entity> availableAgents;
        private List<Entity> availableUnknownAgents;
        private Map<Long, Entity> selectedAgents;
        private List<Entity> selectedUnknownAgents;
        private Map<Long, Entity> availableOrgPositions;
        private List<Entity> availableUnknownOrgPositions;
        private Map<Long, Entity> selectedOrgPositions;
        private List<Entity> selectedUnknownOrgPositions;
        private Map<Long, Entity> availableOrgUnits;
        private List<Entity> availableUnknownOrgUnits;
        private Map<Long, Object> selectedOrgUnits;
        private List<Object> selectedUnknownOrgUnits;
        private Map<Long, Entity> availableRoles;
        private List<Entity> availableUnknownRoles;
        private Map<Long, Entity> selectedRoles;
        private List<Entity> selectedUnknownRoles;
        private List<DependantCondition> selectedDependantConditions;
        private String assistedEditPolicy;
        private String originalPolicy;
        private String newPolicy;
        Map<String, Dependency> parameterBindings;
        ComboViewer dependenciesArea_comboViewerTarget;
        ComboViewer dependenciesArea_comboViewerDep;
        ComboViewer dependenciesArea_comboViewerDepArg;
        private ListViewer dependenciesArea_listViewerDependantConditions;
        private ParameterBindingsUIComponent bindingsUI;

        public OldStaffAssignmentRuleDialog(Shell parentShell, String originalPolicy, OrgModelManager omm) {
            super(parentShell);
            this.availableAgents = new HashMap<Long, Entity>();
            this.availableUnknownAgents = new ArrayList<Entity>();
            this.selectedAgents = new HashMap<Long, Entity>();
            this.selectedUnknownAgents = new ArrayList<Entity>();
            this.availableOrgPositions = new HashMap<Long, Entity>();
            this.availableUnknownOrgPositions = new ArrayList<Entity>();
            this.selectedOrgPositions = new HashMap<Long, Entity>();
            this.selectedUnknownOrgPositions = new ArrayList<Entity>();
            this.availableOrgUnits = new HashMap<Long, Entity>();
            this.availableUnknownOrgUnits = new ArrayList<Entity>();
            this.selectedOrgUnits = new HashMap<Long, Object>();
            this.selectedUnknownOrgUnits = new ArrayList<Object>();
            this.availableRoles = new HashMap<Long, Entity>();
            this.availableUnknownRoles = new ArrayList<Entity>();
            this.selectedRoles = new HashMap<Long, Entity>();
            this.selectedUnknownRoles = new ArrayList<Entity>();
            this.selectedDependantConditions = new ArrayList<DependantCondition>();
            this.parameterBindings = new HashMap<String, Dependency>();
            this.originalPolicy = originalPolicy == null ? "" : originalPolicy;
            this.omm = omm;
            this.color_underlineFailure = new Color((Device)this.getParentShell().getDisplay(), 255, 0, 0);
            this.color_underlineWarning = new Color((Device)this.getParentShell().getDisplay(), 244, 200, 45);
            this.color_underlineNeutral = new Color((Device)this.getParentShell().getDisplay(), 220, 220, 220);
            this.color_highlightAffectedRange = new Color((Device)this.getParentShell().getDisplay(), 255, 210, 210);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        public boolean wasPolicyChanged() {
            return !this.originalPolicy.equals(this.getPolicy());
        }

        public String getPolicy() {
            if (this.newPolicy != null) {
                return this.newPolicy;
            }
            return this.originalPolicy;
        }

        public Map<String, Dependency> getParameterBindings() {
            return new HashMap<String, Dependency>(this.parameterBindings);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Staff Assignment Rule Dialogue");
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            GridLayout dialogAreaLayout = (GridLayout)dialogArea.getLayout();
            dialogAreaLayout.numColumns = 2;
            this.tabFolder_editModes = new CTabFolder(dialogArea, 2176);
            GridData gridData = new GridData(4, 4, true, true);
            this.tabFolder_editModes.setLayoutData((Object)gridData);
            this.tabFolder_editModes.setTabHeight(this.tabFolder_editModes.getTabHeight() + 10);
            this.tabFolder_editModes.setSimple(false);
            this.tabFolder_editModes.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.editModeTabSelected();
                }
            });
            Composite assistedPolicyEditing = this.createAssistedEditArea((Composite)this.tabFolder_editModes);
            CTabItem item = new CTabItem(this.tabFolder_editModes, 0);
            item.setText(" Assisted Policy Editing ");
            item.setControl((Control)assistedPolicyEditing);
            Composite manualPolicyEditing = this.createManualEditArea((Composite)this.tabFolder_editModes);
            item = new CTabItem(this.tabFolder_editModes, 0);
            item.setText(" Manual Policy Editing ");
            item.setControl((Control)manualPolicyEditing);
            Composite compositeAssignmentPreview = new Composite(dialogArea, 0);
            gridData = new GridData(4, 4, false, true);
            compositeAssignmentPreview.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            compositeAssignmentPreview.setLayout((Layout)gridLayout);
            Label labelAssignmentPreview = new Label(compositeAssignmentPreview, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            labelAssignmentPreview.setLayoutData((Object)gridData);
            labelAssignmentPreview.setText("Results Preview:");
            this.list_assignmentPreview = new org.eclipse.swt.widgets.List(compositeAssignmentPreview, 2816);
            gridData = new GridData(1040);
            gridData.horizontalSpan = 2;
            gridData.widthHint = 200;
            this.list_assignmentPreview.setLayoutData((Object)gridData);
            this.checkbox_assignmentPreviewAutoRefresh = new Button(compositeAssignmentPreview, 32);
            gridData = new GridData(768);
            this.checkbox_assignmentPreviewAutoRefresh.setLayoutData((Object)gridData);
            this.checkbox_assignmentPreviewAutoRefresh.setText("Auto Refresh");
            this.checkbox_assignmentPreviewAutoRefresh.setSelection(true);
            this.checkbox_assignmentPreviewAutoRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.policyPreviewAutoRefreshToggled();
                }
            });
            this.button_assignmentPreviewRefresh = new Button(compositeAssignmentPreview, 8);
            gridData = new GridData(128);
            this.button_assignmentPreviewRefresh.setLayoutData((Object)gridData);
            this.button_assignmentPreviewRefresh.setText("Refresh");
            this.button_assignmentPreviewRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OldStaffAssignmentRuleDialog.this.isInAssistedEditMode()) {
                        OldStaffAssignmentRuleDialog.this.updateAssistedEditPolicy(true);
                    } else {
                        OldStaffAssignmentRuleDialog.this.updateManualEditPolicy(true);
                    }
                }
            });
            this.policyPreviewAutoRefreshToggled();
            this.initialiseSelectionLists();
            this.text_manualEditPolicy.setText(this.originalPolicy);
            boolean canBeAssisted = this.initialiseAssistedEditingFromPolicy(this.originalPolicy);
            if (canBeAssisted) {
                this.tabFolder_editModes.setSelection(0);
                this.updateAssistedEditPolicy(false);
            } else {
                this.tabFolder_editModes.setSelection(1);
                this.updateManualEditPolicy(false);
            }
            return dialogArea;
        }

        private Composite createAssistedEditArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            TabFolder tabsEntityTypes = new TabFolder(composite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            tabsEntityTypes.setLayoutData((Object)gridData);
            Composite compositeOrgUnits = this.createOrgUnitSelectionArea((Composite)tabsEntityTypes);
            TabItem item = new TabItem(tabsEntityTypes, 0);
            item.setText("Org. Units and Roles");
            item.setControl((Control)compositeOrgUnits);
            if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider != null) {
                Composite areaDependencies = this.createDependenciesArea((Composite)tabsEntityTypes);
                item = new TabItem(tabsEntityTypes, 0);
                item.setText("Dependant Conditions");
                item.setControl((Control)areaDependencies);
            }
            Composite compositeAgents = this.createAgentSelectionArea((Composite)tabsEntityTypes);
            item = new TabItem(tabsEntityTypes, 0);
            item.setText("Agents");
            item.setControl((Control)compositeAgents);
            Composite compositeOrgPositions = this.createOrgPositionSelectionArea((Composite)tabsEntityTypes);
            item = new TabItem(tabsEntityTypes, 0);
            item.setText("Org. Positions");
            item.setControl((Control)compositeOrgPositions);
            Composite compositeRoles = this.createRoleSelectionArea((Composite)tabsEntityTypes);
            item = new TabItem(tabsEntityTypes, 0);
            item.setText("Roles");
            item.setControl((Control)compositeRoles);
            Composite compositePolicyPreview = new Composite(composite, 0);
            gridData = new GridData(4, 4, true, false);
            compositePolicyPreview.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            compositePolicyPreview.setLayout((Layout)gridLayout);
            Label labelPolicyPreview = new Label(compositePolicyPreview, 0);
            gridData = new GridData(768);
            labelPolicyPreview.setLayoutData((Object)gridData);
            labelPolicyPreview.setText("Policy Preview:");
            this.text_assistedEditPolicyPreview = new Text(compositePolicyPreview, 2626);
            gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 50;
            gridData.widthHint = 300;
            this.text_assistedEditPolicyPreview.setLayoutData((Object)gridData);
            this.text_assistedEditPolicyPreview.setEditable(false);
            this.button_identifierMode = new Button(composite, 32);
            this.button_identifierMode.setText("Identify by name");
            gridData = new GridData(4, 4, false, false);
            this.button_identifierMode.setLayoutData((Object)gridData);
            this.button_identifierMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean confirmed = false;
                    confirmed = OldStaffAssignmentRuleDialog.this.button_identifierMode.getSelection() ? MessageDialog.openConfirm((Shell)OldStaffAssignmentRuleDialog.this.getShell(), (String)"Confirm", (String)"The staff assignment rule will be switched to use names for identification of the entities. If you continue, you have a possible loss of precision since entity names may not be unique.") : MessageDialog.openConfirm((Shell)OldStaffAssignmentRuleDialog.this.getShell(), (String)"Confirm", (String)"The staff assignment rule will be switched to use ids for identification of the entities. If you continue, you might have problems to roll out the template on different org models.");
                    if (!confirmed) {
                        OldStaffAssignmentRuleDialog.this.button_identifierMode.setSelection(!OldStaffAssignmentRuleDialog.this.button_identifierMode.getSelection());
                    } else {
                        OldStaffAssignmentRuleDialog.this.updateAssistedEditPolicy(false);
                    }
                }
            });
            return composite;
        }

        private Composite createAgentSelectionArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.createLabels(composite, "Available Agents:", "Selected Agents:");
            EntityListUIComponent availableAgentsUiComponent = this.createFilteredListComponent(composite);
            availableAgentsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.selectAgents();
                }
            });
            Composite compositeButtons = new Composite(composite, 0);
            GridData gridData = new GridData(68);
            compositeButtons.setLayoutData((Object)gridData);
            compositeButtons.setLayout((Layout)new FillLayout(512));
            Button arrowRightButton = new Button(compositeButtons, 0x1000008);
            arrowRightButton.setText(">");
            arrowRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.selectAgents();
                }
            });
            Button arrowLeftButton = new Button(compositeButtons, 0x1000008);
            arrowLeftButton.setText("<");
            arrowLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.deselectAgents();
                }
            });
            EntityListUIComponent selectedAgentsUiComponent = this.createFilteredListComponent(composite);
            selectedAgentsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.deselectAgents();
                }
            });
            this.listViewer_availableAgents = this.initViewer(availableAgentsUiComponent);
            this.listViewer_selectedAgents = this.initViewer(selectedAgentsUiComponent);
            this.listViewer_selectedAgents.setInput(this.selectedAgents.values());
            this.labelAgentOrgUnitInfo = new Label(composite, 0);
            gridData = new GridData(4, 4, true, false);
            gridData.horizontalSpan = 3;
            this.labelAgentOrgUnitInfo.setLayoutData((Object)gridData);
            this.listViewer_availableAgents.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OldStaffAssignmentRuleDialog.this.agentSelected(event);
                }
            });
            this.listViewer_selectedAgents.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OldStaffAssignmentRuleDialog.this.agentSelected(event);
                }
            });
            return composite;
        }

        void agentSelected(SelectionChangedEvent event) {
            block9: {
                SessionToken session = Activator.getService().getSessionToken();
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof Entity) {
                        Entity agent = (Entity)selection.getFirstElement();
                        try {
                            List orgPositions = this.omm.getModelExplorer().getRelatedEntities(session, EntityType.AGENT, agent.getInteger("id"), RelationType.ORG_POSITION_OCCUPATION, false, new String[0]);
                            if (orgPositions.size() > 0) {
                                Entity orgPos = (Entity)orgPositions.get(0);
                                List orgUnits = this.omm.getModelExplorer().getRelatedEntities(session, EntityType.ORG_POSITION, orgPos.getInteger("id"), RelationType.ORG_POSITION_AFFILIATION, false, new String[0]);
                                if (orgUnits.size() > 0) {
                                    Entity orgUnit = (Entity)orgUnits.get(0);
                                    String msg = "The agent '%s' is a member of the org. unit '%s'.";
                                    msg = String.format(msg, agent.getString("userName"), orgUnit.getString("name"));
                                    this.labelAgentOrgUnitInfo.setText(msg);
                                } else {
                                    String msg = "The agent's org. position '%s' is not part of any org. unit.";
                                    msg = String.format(msg, orgPos.getString("name"));
                                    this.labelAgentOrgUnitInfo.setText(msg);
                                }
                                break block9;
                            }
                            String msg = "The agent '%s' does not occupy any org. position.";
                            msg = String.format(msg, agent.getString("userName"));
                            this.labelAgentOrgUnitInfo.setText(msg);
                        }
                        catch (OrgModelException orgModelException) {
                            String msg = "Could not fetch the agent's org. position.";
                            this.labelAgentOrgUnitInfo.setText(msg);
                        }
                        catch (Exception ex) {
                            String msg = "Could not fetch the agent's org. position.";
                            this.labelAgentOrgUnitInfo.setText(msg);
                            SimpleStaffAssignmentRuleDialogue.this.logger.log(Level.SEVERE, msg, ex);
                        }
                    } else {
                        this.labelAgentOrgUnitInfo.setText("");
                    }
                }
            }
        }

        private Composite createOrgPositionSelectionArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.createLabels(composite, "Available Org. Positions:", "Selected Org. Positions:");
            EntityListUIComponent availableOrgPositionsUiComponent = this.createFilteredListComponent(composite);
            availableOrgPositionsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.selectOrgPositions();
                }
            });
            Composite compositeButtons = new Composite(composite, 0);
            GridData gridData = new GridData(68);
            compositeButtons.setLayoutData((Object)gridData);
            compositeButtons.setLayout((Layout)new FillLayout(512));
            Button arrowRightButton = new Button(compositeButtons, 0x1000008);
            arrowRightButton.setText(">");
            arrowRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.selectOrgPositions();
                }
            });
            Button arrowLeftButton = new Button(compositeButtons, 0x1000008);
            arrowLeftButton.setText("<");
            arrowLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.deselectOrgPositions();
                }
            });
            EntityListUIComponent selectedOrgPositionsUiComponent = this.createFilteredListComponent(composite);
            selectedOrgPositionsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.deselectOrgPositions();
                }
            });
            this.listViewer_availableOrgPositions = this.initViewer(availableOrgPositionsUiComponent);
            this.listViewer_selectedOrgPositions = this.initViewer(selectedOrgPositionsUiComponent);
            this.listViewer_selectedOrgPositions.setInput(this.selectedOrgPositions.values());
            this.labelOrgPositionOrgUnitInfo = new Label(composite, 0);
            gridData = new GridData(4, 4, false, false);
            gridData.horizontalSpan = 3;
            this.labelOrgPositionOrgUnitInfo.setLayoutData((Object)gridData);
            this.listViewer_availableOrgPositions.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OldStaffAssignmentRuleDialog.this.orgPositionSelected(event);
                }
            });
            this.listViewer_selectedOrgPositions.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OldStaffAssignmentRuleDialog.this.orgPositionSelected(event);
                }
            });
            return composite;
        }

        void orgPositionSelected(SelectionChangedEvent event) {
            block7: {
                SessionToken session = Activator.getService().getSessionToken();
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    if (selection.getFirstElement() instanceof Entity) {
                        Entity orgPos = (Entity)selection.getFirstElement();
                        try {
                            List orgUnits = this.omm.getModelExplorer().getRelatedEntities(session, EntityType.ORG_POSITION, orgPos.getInteger("id"), RelationType.ORG_POSITION_AFFILIATION, false, new String[0]);
                            if (orgUnits.size() > 0) {
                                Entity orgUnit = (Entity)orgUnits.get(0);
                                String msg = "The org. position '%s' is part of the org. unit '%s'.";
                                msg = String.format(msg, orgPos.getString("name"), orgUnit.getString("name"));
                                this.labelOrgPositionOrgUnitInfo.setText(msg);
                                break block7;
                            }
                            String msg = "The org. position '%s' is not part of any org. unit.";
                            msg = String.format(msg, orgPos.getString("name"));
                            this.labelOrgPositionOrgUnitInfo.setText(msg);
                        }
                        catch (OrgModelException orgModelException) {
                            String msg = "Could not fetch the org. position's org. unit.";
                            this.labelOrgPositionOrgUnitInfo.setText(msg);
                        }
                        catch (Exception ex) {
                            String msg = "Could not fetch the org. position's org. unit.";
                            this.labelOrgPositionOrgUnitInfo.setText(msg);
                            SimpleStaffAssignmentRuleDialogue.this.logger.log(Level.SEVERE, msg, ex);
                        }
                    } else {
                        this.labelOrgPositionOrgUnitInfo.setText("");
                    }
                }
            }
        }

        private Composite createOrgUnitSelectionArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.createLabels(composite, "Available Org. Units:", "Selected Org. Units:");
            Composite orgUnitRoleComposite = new Composite(composite, 0);
            GridData gridData = new GridData(4, 4, true, true);
            orgUnitRoleComposite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            orgUnitRoleComposite.setLayout((Layout)layout);
            EntityListUIComponent availableOrgUnitsUiComponent = this.createFilteredListComponent(orgUnitRoleComposite);
            availableOrgUnitsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.selectOrgUnits();
                }
            });
            this.button_OrgUnitRoleConnection = new Button(orgUnitRoleComposite, 32);
            this.button_OrgUnitRoleConnection.setText("Connect a Role with the selected OrgUnit(s)");
            gridData = new GridData(0, 0, false, false);
            this.button_OrgUnitRoleConnection.setLayoutData((Object)gridData);
            final Combo combo_roleForOrgUnit = new Combo(orgUnitRoleComposite, 12);
            combo_roleForOrgUnit.setEnabled(false);
            gridData = new GridData(4, 0, true, false);
            combo_roleForOrgUnit.setLayoutData((Object)gridData);
            this.comboViewer_roleForOrgUnit = new ComboViewer(combo_roleForOrgUnit);
            this.comboViewer_roleForOrgUnit.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboViewer_roleForOrgUnit.setLabelProvider((IBaseLabelProvider)new DefaultEntityLabelProvider());
            this.button_OrgUnitRoleConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OldStaffAssignmentRuleDialog.this.button_OrgUnitRoleConnection.getSelection()) {
                        combo_roleForOrgUnit.setEnabled(true);
                    } else {
                        combo_roleForOrgUnit.setEnabled(false);
                    }
                }
            });
            Composite compositeButtons = new Composite(composite, 0);
            gridData = new GridData(68);
            compositeButtons.setLayoutData((Object)gridData);
            compositeButtons.setLayout((Layout)new FillLayout(512));
            Button arrowRightButton = new Button(compositeButtons, 0x1000008);
            arrowRightButton.setText(">");
            arrowRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.selectOrgUnits();
                }
            });
            Button arrowLeftButton = new Button(compositeButtons, 0x1000008);
            arrowLeftButton.setText("<");
            arrowLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.deselectOrgUnits();
                }
            });
            EntityListUIComponent selectedOrgUnitsUiComponent = this.createFilteredListComponent(composite);
            selectedOrgUnitsUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.deselectOrgUnits();
                }
            });
            this.listViewer_availableOrgUnits = this.initViewer(availableOrgUnitsUiComponent);
            OrgUnitEntityLabelProvider labelProvider = new OrgUnitEntityLabelProvider();
            this.listViewer_selectedOrgUnits = selectedOrgUnitsUiComponent.getColumnViewer();
            this.listViewer_selectedOrgUnits.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.listViewer_selectedOrgUnits.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.listViewer_selectedOrgUnits.setComparator(new ViewerComparator());
            this.listViewer_selectedOrgUnits.setInput(this.selectedOrgUnits.values());
            return composite;
        }

        private Composite createRoleSelectionArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.createLabels(composite, "Available Roles:", "Selected Roles:");
            EntityListUIComponent availableRolesUiComponent = this.createFilteredListComponent(composite);
            availableRolesUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.selectRoles();
                }
            });
            Composite compositeButtons = new Composite(composite, 0);
            GridData gridData = new GridData(68);
            compositeButtons.setLayoutData((Object)gridData);
            compositeButtons.setLayout((Layout)new FillLayout(512));
            Button arrowRightButton = new Button(compositeButtons, 0x1000008);
            arrowRightButton.setText(">");
            arrowRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.selectRoles();
                }
            });
            Button arrowLeftButton = new Button(compositeButtons, 0x1000008);
            arrowLeftButton.setText("<");
            arrowLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.deselectRoles();
                }
            });
            EntityListUIComponent selectedRolesUiComponent = this.createFilteredListComponent(composite);
            selectedRolesUiComponent.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    OldStaffAssignmentRuleDialog.this.deselectRoles();
                }
            });
            this.listViewer_availableRoles = this.initViewer(availableRolesUiComponent);
            this.listViewer_selectedRoles = this.initViewer(selectedRolesUiComponent);
            this.listViewer_selectedRoles.setInput(this.selectedRoles.values());
            return composite;
        }

        private Composite createDependenciesArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setLayout((Layout)new GridLayout(3, false));
            this.createLabels(area, "Available Dependant Conditions:", "Selected Dependant Conditions:");
            Group availableDependantConditions = new Group(area, 0);
            GridData gridData = new GridData(4, 4, true, true);
            availableDependantConditions.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(1, false);
            availableDependantConditions.setLayout((Layout)layout);
            Combo comboTarget = new Combo((Composite)availableDependantConditions, 12);
            gridData = new GridData(4, 0, true, false);
            comboTarget.setLayoutData((Object)gridData);
            final Label label = new Label((Composite)availableDependantConditions, 0);
            gridData = new GridData(4, 0, false, false);
            label.setLayoutData((Object)gridData);
            label.setText("Take ID from:");
            Combo comboDep = new Combo((Composite)availableDependantConditions, 12);
            gridData = new GridData(4, 0, false, false);
            comboDep.setLayoutData((Object)gridData);
            Combo comboDepArg = new Combo((Composite)availableDependantConditions, 12);
            gridData = new GridData(4, 0, false, false);
            comboDepArg.setLayoutData((Object)gridData);
            this.dependenciesArea_comboViewerDepArg = new ComboViewer(comboDepArg);
            this.dependenciesArea_comboViewerDepArg.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dependenciesArea_comboViewerDepArg.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Map.Entry entry = (Map.Entry)element;
                    return (String)entry.getValue();
                }
            });
            this.dependenciesArea_comboViewerDep = new ComboViewer(comboDep);
            this.dependenciesArea_comboViewerDep.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dependenciesArea_comboViewerDep.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Map.Entry entry = (Map.Entry)element;
                    return (String)entry.getValue();
                }
            });
            this.dependenciesArea_comboViewerDep.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ProcessConstants.AdeptDataType dataType = OldStaffAssignmentRuleDialog.this.dependenciesArea_getSelectedConditionTarget().dataType();
                    Object dependencyType = OldStaffAssignmentRuleDialog.this.dependenciesArea_getSelectedDependencyType();
                    Map arguments = ((OldStaffAssignmentRuleDialog)OldStaffAssignmentRuleDialog.this).SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyTypeArguments(dependencyType, dataType, OldStaffAssignmentRuleDialog.this.dependenciesArea_getSelectedConditionTarget().identifierID());
                    if (arguments.size() == 0) {
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.setInput(null);
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setEnabled(false);
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().add("<none available>");
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().select(0);
                    } else if (Arrays.asList(SystemDataProducer.startNodeProduced()).contains(dependencyType)) {
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setVisibleItemCount(arguments.size());
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.setInput(arguments.entrySet());
                        if (!arguments.isEmpty()) {
                            OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.setSelection((ISelection)new StructuredSelection(OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getElementAt(0)));
                        }
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setEnabled(false);
                    } else {
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setVisibleItemCount(arguments.size());
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.setInput(arguments.entrySet());
                        if (!arguments.isEmpty()) {
                            OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.setSelection((ISelection)new StructuredSelection(OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getElementAt(0)));
                        }
                        OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setEnabled(true);
                    }
                }
            });
            this.dependenciesArea_comboViewerTarget = new ComboViewer(comboTarget);
            this.dependenciesArea_comboViewerTarget.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ProcessConstants.AdeptDataType dataType = OldStaffAssignmentRuleDialog.this.dependenciesArea_getSelectedConditionTarget().dataType();
                    switch (OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerTarget.getCombo().getSelectionIndex()) {
                        case 0: {
                            label.setText("Take agent ID from:");
                            break;
                        }
                        case 1: {
                            label.setText("Take org. position ID from:");
                            break;
                        }
                        case 2: {
                            label.setText("Take org. position ID from:");
                            break;
                        }
                        case 3: {
                            label.setText("Take entity expression from:");
                            break;
                        }
                        default: {
                            label.setText("Take ID from:");
                        }
                    }
                    Map depTypes = ((OldStaffAssignmentRuleDialog)OldStaffAssignmentRuleDialog.this).SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyTypes(dataType, OldStaffAssignmentRuleDialog.this.dependenciesArea_getSelectedConditionTarget().identifierID());
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDep.getCombo().setVisibleItemCount(depTypes.size());
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDep.setInput(depTypes.entrySet());
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().deselectAll();
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_comboViewerDepArg.getCombo().setEnabled(false);
                }
            });
            this.dependenciesArea_comboViewerTarget.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dependenciesArea_comboViewerTarget.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    ConditionTarget target = (ConditionTarget)((Object)element);
                    return target.displayName();
                }
            });
            this.dependenciesArea_comboViewerTarget.setInput((Object)ConditionTarget.values());
            this.dependenciesArea_comboViewerTarget.setSelection((ISelection)new StructuredSelection(this.dependenciesArea_comboViewerTarget.getElementAt(0)));
            Label spacer = new Label(area, 0);
            gridData = new GridData(0, 0, false, false);
            gridData.widthHint = 10;
            gridData.verticalSpan = 2;
            spacer.setLayoutData((Object)gridData);
            org.eclipse.swt.widgets.List listDependantConditions = new org.eclipse.swt.widgets.List(area, 2818);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 200;
            gridData.heightHint = 150;
            listDependantConditions.setLayoutData((Object)gridData);
            this.dependenciesArea_listViewerDependantConditions = new ListViewer(listDependantConditions);
            this.dependenciesArea_listViewerDependantConditions.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dependenciesArea_listViewerDependantConditions.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    DependantCondition depCond = (DependantCondition)element;
                    return String.valueOf(depCond.target.displayName) + " (" + ((OldStaffAssignmentRuleDialog)OldStaffAssignmentRuleDialog.this).SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(depCond.dependency) + ")";
                }
            });
            this.dependenciesArea_listViewerDependantConditions.setInput(this.selectedDependantConditions);
            Button buttonAddDependency = new Button(area, 0);
            gridData = new GridData(4, 0, false, false);
            buttonAddDependency.setLayoutData((Object)gridData);
            buttonAddDependency.setText("Add dependency");
            buttonAddDependency.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_addDependency();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button buttonRemoveDependency = new Button(area, 0);
            gridData = new GridData(4, 0, false, false);
            buttonRemoveDependency.setLayoutData((Object)gridData);
            buttonRemoveDependency.setText("Remove dependency");
            buttonRemoveDependency.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    OldStaffAssignmentRuleDialog.this.dependenciesArea_removeDependency();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return area;
        }

        ConditionTarget dependenciesArea_getSelectedConditionTarget() {
            StructuredSelection selection = (StructuredSelection)this.dependenciesArea_comboViewerTarget.getSelection();
            return (ConditionTarget)((Object)selection.getFirstElement());
        }

        Object dependenciesArea_getSelectedDependencyType() {
            StructuredSelection selection = (StructuredSelection)this.dependenciesArea_comboViewerDep.getSelection();
            Map.Entry entry = (Map.Entry)selection.getFirstElement();
            return entry == null ? null : entry.getKey();
        }

        private Object dependenciesArea_getSelectedDependencyTypeArgument() {
            StructuredSelection selection = (StructuredSelection)this.dependenciesArea_comboViewerDepArg.getSelection();
            Map.Entry entry = (Map.Entry)selection.getFirstElement();
            if (entry == null) {
                return null;
            }
            return entry.getKey();
        }

        void dependenciesArea_addDependency() {
            Object depType = this.dependenciesArea_getSelectedDependencyType();
            if (depType == null) {
                String msg = "Please select a dependency type first.";
                WhiteErrorDialogue.openError((Shell)this.getShell(), (String)"Dependant Condition cannot be added", (String)msg, null);
                return;
            }
            if (this.dependenciesArea_comboViewerDepArg.getInput() == null) {
                String msg = "This dependant condition cannot be added because there are no valid arguments available for the dependency type '%s'.";
                msg = String.format(msg, SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForType(depType));
                WhiteErrorDialogue.openError((Shell)this.getShell(), (String)"Dependant Condition cannot be added", (String)msg, null);
                return;
            }
            Dependency dep = new Dependency(this.dependenciesArea_getSelectedDependencyType(), this.dependenciesArea_getSelectedDependencyTypeArgument());
            DependantCondition depCond = new DependantCondition(this.dependenciesArea_getSelectedConditionTarget(), dep);
            if (this.selectedDependantConditions.contains(depCond)) {
                String msg = "This dependant condition is already in the list of selected conditions.";
                msg = String.format(msg, new Object[0]);
                WhiteErrorDialogue.openError((Shell)this.getShell(), (String)"Dependant Condition cannot be added", (String)msg, null);
                return;
            }
            this.selectedDependantConditions.add(depCond);
            this.dependenciesArea_listViewerDependantConditions.refresh();
            this.updateAssistedEditPolicy(false);
        }

        void dependenciesArea_removeDependency() {
            StructuredSelection selection = (StructuredSelection)this.dependenciesArea_listViewerDependantConditions.getSelection();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.selectedDependantConditions.remove(it.next());
            }
            this.dependenciesArea_listViewerDependantConditions.refresh();
            this.updateAssistedEditPolicy(false);
        }

        private Composite createManualEditArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            this.text_manualEditPolicy = new StyledText(composite, 2626);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 200;
            gridData.widthHint = 400;
            this.text_manualEditPolicy.setLayoutData((Object)gridData);
            this.text_manualEditPolicy.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OldStaffAssignmentRuleDialog.this.isInManualEditMode()) {
                        OldStaffAssignmentRuleDialog.this.updateManualEditPolicy(false);
                        OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.redraw();
                    }
                }
            });
            this.text_manualEditPolicy.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    OrgPolicyReport.Entry[] entryArray = OldStaffAssignmentRuleDialog.this.currentProblems.getEntries();
                    int n = entryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OrgPolicyReport.Entry problem = entryArray[n2];
                        switch (problem.getResultType()) {
                            case ERROR: {
                                e.gc.setForeground(OldStaffAssignmentRuleDialog.this.color_underlineFailure);
                                break;
                            }
                            case WARNING: {
                                e.gc.setForeground(OldStaffAssignmentRuleDialog.this.color_underlineWarning);
                                break;
                            }
                            default: {
                                e.gc.setForeground(OldStaffAssignmentRuleDialog.this.color_underlineNeutral);
                            }
                        }
                        OrgPolicyReport.Range[] rangeArray = problem.getRanges();
                        int n3 = rangeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            OrgPolicyReport.Range affectedRange = rangeArray[n4];
                            String policy = OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.getText();
                            int beginColumn = affectedRange.getBeginColumn();
                            int endColumn = affectedRange.getEndColumn();
                            String substring = policy.substring(beginColumn, endColumn);
                            int stringWidth = e.gc.stringExtent((String)substring).x;
                            int baseLine = OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.getBaseline();
                            Point topLeft = OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.getLocationAtOffset(beginColumn);
                            int x1 = topLeft.x;
                            int x2 = x1 + stringWidth + 1;
                            int y = topLeft.y + baseLine + 1;
                            e.gc.setClipping(x1, y, stringWidth, 3);
                            e.gc.setLineDash(new int[]{1, 3});
                            e.gc.drawLine(x1, y, x2, y);
                            e.gc.setLineDash(new int[]{1, 1});
                            e.gc.drawLine(++x1, ++y, x2, y);
                            e.gc.setLineDash(new int[]{1, 3});
                            e.gc.drawLine(++x1, ++y, x2, y);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider != null) {
                this.bindingsUI = new ParameterBindingsUIComponent(composite, SimpleStaffAssignmentRuleDialogue.this.dependencyProvider);
                gridData = new GridData(4, 4, true, true);
                gridData.horizontalSpan = 2;
                this.bindingsUI.getControl().setLayoutData((Object)gridData);
            }
            Label labelProblems = new Label(composite, 0);
            gridData = new GridData(768);
            gridData.verticalIndent = 10;
            gridData.horizontalIndent = 5;
            labelProblems.setLayoutData((Object)gridData);
            labelProblems.setText("Problems:");
            Table tableProblems = new Table(composite, 68100);
            gridData = new GridData(4, 4, true, false);
            gridData.heightHint = 100;
            tableProblems.setLayoutData((Object)gridData);
            tableProblems.setLinesVisible(true);
            tableProblems.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent arg0) {
                    Rectangle clientArea = OldStaffAssignmentRuleDialog.this.tableViewer_problems.getTable().getClientArea();
                    OldStaffAssignmentRuleDialog.this.column_problems.setWidth(clientArea.width);
                }
            });
            tableProblems.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = OldStaffAssignmentRuleDialog.this.tableViewer_problems.getTable().getSelectionIndex();
                    OrgPolicyReport.Entry selectedProblem = OldStaffAssignmentRuleDialog.this.currentProblems.getEntryAt(index);
                    OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.setStyleRange(null);
                    OrgPolicyReport.Range[] rangeArray = selectedProblem.getRanges();
                    int n = rangeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OrgPolicyReport.Range range = rangeArray[n2];
                        int beginColumn = range.getBeginColumn();
                        int endColumn = range.getEndColumn();
                        StyleRange style = new StyleRange();
                        style.start = beginColumn;
                        style.length = endColumn - beginColumn;
                        style.background = OldStaffAssignmentRuleDialog.this.color_highlightAffectedRange;
                        OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.setStyleRange(style);
                        ++n2;
                    }
                }
            });
            tableProblems.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    OldStaffAssignmentRuleDialog.this.text_manualEditPolicy.setStyleRange(null);
                }
            });
            this.column_problems = new TableColumn(tableProblems, 16384);
            this.column_problems.setWidth(380);
            this.tableViewer_problems = new TableViewer(tableProblems);
            this.tableViewer_problems.setLabelProvider((IBaseLabelProvider)new ProblemsTableLabelProvider());
            this.tableViewer_problems.setContentProvider((IContentProvider)new ProblemsContentProvider());
            return composite;
        }

        private EntityListUIComponent createFilteredListComponent(Composite parent) {
            FilterFactory filterFactory = Activator.getService().getFilterFactory();
            EntityListUIComponent uiComponent = new EntityListUIComponent(parent, filterFactory);
            Composite searchComposite = uiComponent.getSearchComposite();
            searchComposite.setBackground(parent.getBackground());
            int i = 0;
            while (i < searchComposite.getChildren().length) {
                if (!(searchComposite.getChildren()[i] instanceof Text)) {
                    searchComposite.getChildren()[i].setBackground(parent.getBackground());
                }
                ++i;
            }
            GridData data = (GridData)searchComposite.getChildren()[0].getLayoutData();
            searchComposite.getChildren()[0].setVisible(false);
            data.exclude = true;
            GridLayout layout = (GridLayout)searchComposite.getLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            Table columnControl = (Table)uiComponent.getColumnControl();
            columnControl.setLinesVisible(false);
            columnControl.setHeaderVisible(false);
            GridData gridData = new GridData(1808);
            gridData.grabExcessVerticalSpace = true;
            gridData.widthHint = 200;
            gridData.heightHint = 150;
            uiComponent.getControl().setLayoutData((Object)gridData);
            return uiComponent;
        }

        private void createLabels(Composite parent, String availableEntityText, String selectedEntityText) {
            Label labelAvailableAgents = new Label(parent, 16384);
            labelAvailableAgents.setText(availableEntityText);
            GridData gridData = new GridData(768);
            labelAvailableAgents.setLayoutData((Object)gridData);
            Label dummyLabel = new Label(parent, 0x1000000);
            dummyLabel.setText("");
            Label labelSelectedAgents = new Label(parent, 16384);
            labelSelectedAgents.setText(selectedEntityText);
            gridData = new GridData(768);
            labelSelectedAgents.setLayoutData((Object)gridData);
        }

        private StructuredViewer initViewer(EntityListUIComponent availableAgentsUiComponent) {
            DefaultEntityLabelProvider labelProvider = new DefaultEntityLabelProvider();
            ArrayContentProvider contentProvider = new ArrayContentProvider();
            ViewerComparator comparator = new ViewerComparator();
            ColumnViewer viewer = availableAgentsUiComponent.getColumnViewer();
            viewer.setContentProvider((IContentProvider)contentProvider);
            viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            viewer.setComparator(comparator);
            return viewer;
        }

        private void initialiseSelectionLists() {
            SessionToken session = Activator.getService().getSessionToken();
            try {
                ModelExplorer ommExplorer = this.omm.getModelExplorer();
                for (Entity entity : ommExplorer.getEntities(session, EntityType.AGENT, new String[]{"id", "username"})) {
                    this.availableAgents.put((Long)entity.get("id"), entity);
                }
                this.selectedAgents.clear();
                this.selectedUnknownAgents.clear();
                this.listViewer_availableAgents.setInput(this.availableAgents.values());
                this.listViewer_availableAgents.refresh();
                this.listViewer_selectedAgents.refresh();
                for (Entity entity : ommExplorer.getEntities(session, EntityType.ORG_POSITION, new String[]{"id", "name"})) {
                    this.availableOrgPositions.put((Long)entity.get("id"), entity);
                }
                this.selectedOrgPositions.clear();
                this.selectedUnknownOrgPositions.clear();
                this.listViewer_availableOrgPositions.setInput(this.availableOrgPositions.values());
                this.listViewer_availableOrgPositions.refresh();
                this.listViewer_selectedOrgPositions.refresh();
                for (Entity entity : ommExplorer.getEntities(session, EntityType.ORG_UNIT, new String[]{"id", "name"})) {
                    this.availableOrgUnits.put((Long)entity.get("id"), entity);
                }
                this.selectedOrgUnits.clear();
                this.selectedOrgUnits.clear();
                this.listViewer_availableOrgUnits.setInput(this.availableOrgUnits.values());
                this.listViewer_availableOrgUnits.refresh();
                this.listViewer_selectedOrgUnits.refresh();
                for (Entity entity : ommExplorer.getEntities(session, EntityType.ROLE, new String[]{"id", "name"})) {
                    this.availableRoles.put((Long)entity.get("id"), entity);
                }
                this.selectedRoles.clear();
                this.selectedUnknownRoles.clear();
                this.listViewer_availableRoles.setInput(this.availableRoles.values());
                this.listViewer_availableRoles.refresh();
                this.listViewer_selectedRoles.refresh();
                this.comboViewer_roleForOrgUnit.setInput(this.availableRoles.values());
                if (this.availableRoles.size() != 0) {
                    this.comboViewer_roleForOrgUnit.setSelection((ISelection)new StructuredSelection(this.availableRoles.values().toArray()[0]));
                }
                this.comboViewer_roleForOrgUnit.refresh();
            }
            catch (DataSourceException ex) {
                String msg = "An error occurred while fetching data from the OrgModel! An error dialogue will be displayed.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
            }
        }

        boolean initialiseAssistedEditingFromPolicy(String policy) {
            boolean canBeAssisted = false;
            ArrayList<Entity> tempSelectedAgents = new ArrayList<Entity>();
            ArrayList<Entity> tempSelectedOrgPositions = new ArrayList<Entity>();
            ArrayList<Entity> tempSelectedOrgUnits = new ArrayList<Entity>();
            ArrayList<Entity[]> tempSelectedOrgUnitRoleCombinations = new ArrayList<Entity[]>();
            ArrayList<Entity> tempSelectedRoles = new ArrayList<Entity>();
            ArrayList<DependantCondition> tempSelectedDependantConditions = new ArrayList<DependantCondition>();
            if (policy.trim().equals("")) {
                this.updateAssistedEditPolicy(false);
                canBeAssisted = true;
            } else {
                OrgPolicyReport report = new OrgPolicyReport();
                boolean rejectParameters = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider == null;
                EntityExpression parsedPolicy = OrgPolicyParser.getInstance().parse(policy, report, false, true, rejectParameters, null);
                if (parsedPolicy instanceof AtomicEntityExpression) {
                    boolean successful;
                    AtomicEntityExpression atomicExp = (AtomicEntityExpression)parsedPolicy;
                    if ((atomicExp.getEntityTypeAt(0) == EntityType.AGENT || atomicExp.getEntityTypeAt(0) == EntityType.ORG_POSITION || atomicExp.getEntityTypeAt(0) == EntityType.ORG_UNIT || atomicExp.getEntityTypeAt(0) == EntityType.ROLE) && atomicExp.getSelectionAt(0) instanceof AtomicSelection && (successful = this.parseAtomicEntityExpression(atomicExp, tempSelectedAgents, tempSelectedOrgPositions, tempSelectedOrgUnits, tempSelectedRoles, tempSelectedDependantConditions))) {
                        canBeAssisted = true;
                    }
                } else if (parsedPolicy instanceof DynamicEntityExpression) {
                    DynamicEntityExpression dynExp = (DynamicEntityExpression)parsedPolicy;
                    Dependency dep = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyOf(dynExp.getParameterRef().getName());
                    if (dep != null) {
                        tempSelectedDependantConditions.add(new DependantCondition(ConditionTarget.DYNAMIC_ENTITY_EXPRESSION, dep));
                        canBeAssisted = true;
                    }
                } else if (parsedPolicy instanceof ComplexEntityExpression) {
                    ComplexEntityExpression complexExp = (ComplexEntityExpression)parsedPolicy;
                    if (complexExp.getType() == ComplexEntityExpression.Type.UNION) {
                        int i = 0;
                        int count = complexExp.getSubExpressionCount();
                        while (i < count) {
                            if (complexExp.getSubExpressionAt(i) instanceof AtomicEntityExpression) {
                                AtomicEntityExpression atomicExp = (AtomicEntityExpression)complexExp.getSubExpressionAt(i);
                                boolean successful = this.parseAtomicEntityExpression(atomicExp, tempSelectedAgents, tempSelectedOrgPositions, tempSelectedOrgUnits, tempSelectedRoles, tempSelectedDependantConditions);
                                if (!successful) break;
                                if (i == count - 1) {
                                    canBeAssisted = true;
                                }
                            } else if (complexExp.getSubExpressionAt(i) instanceof DynamicEntityExpression) {
                                DynamicEntityExpression dynExp = (DynamicEntityExpression)complexExp.getSubExpressionAt(i);
                                Dependency dep = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyOf(dynExp.getParameterRef().getName());
                                if (dep == null) break;
                                tempSelectedDependantConditions.add(new DependantCondition(ConditionTarget.DYNAMIC_ENTITY_EXPRESSION, dep));
                                canBeAssisted = true;
                            } else {
                                if (!(complexExp.getSubExpressionAt(i) instanceof ComplexEntityExpression)) break;
                                boolean found = false;
                                if (this.parseOrgUnitRoleComplexEntityExpression((ComplexEntityExpression)complexExp.getSubExpressionAt(i), tempSelectedOrgUnitRoleCombinations)) {
                                    found = true;
                                }
                                if (!found) break;
                                if (i == count - 1) {
                                    canBeAssisted = true;
                                }
                            }
                            ++i;
                        }
                    } else if (complexExp.getType() == ComplexEntityExpression.Type.INTERSECTION) {
                        boolean found = false;
                        if (this.parseOrgUnitRoleComplexEntityExpression(complexExp, tempSelectedOrgUnitRoleCombinations)) {
                            found = true;
                        }
                        if (found) {
                            canBeAssisted = true;
                        }
                    }
                }
                if (canBeAssisted) {
                    this.clearSelections();
                    this.prepareEntityListsForEntity(tempSelectedAgents, this.availableAgents, this.selectedAgents, this.selectedUnknownAgents);
                    this.refreshEntityTablesForEntity(this.availableAgents.values(), this.availableUnknownAgents, this.listViewer_availableAgents, this.selectedAgents.values(), this.selectedUnknownAgents, this.listViewer_selectedAgents);
                    this.prepareEntityListsForEntity(tempSelectedOrgPositions, this.availableOrgPositions, this.selectedOrgPositions, this.selectedUnknownOrgPositions);
                    this.refreshEntityTablesForEntity(this.availableOrgPositions.values(), this.availableUnknownOrgPositions, this.listViewer_availableOrgPositions, this.selectedOrgPositions.values(), this.selectedUnknownOrgPositions, this.listViewer_selectedOrgPositions);
                    for (Entity entity : tempSelectedOrgUnits) {
                        if (entity.getInteger("id") != Long.MIN_VALUE) {
                            if (this.availableOrgUnits.containsKey(entity.get("id"))) {
                                this.availableOrgUnits.remove(entity.get("id"));
                            }
                            this.selectedOrgUnits.put((Long)entity.get("id"), entity);
                            continue;
                        }
                        this.selectedUnknownOrgUnits.add(entity);
                    }
                    for (Entity[] entityArray : tempSelectedOrgUnitRoleCombinations) {
                        if (entityArray[0].getInteger("id") == Long.MIN_VALUE) {
                            this.selectedUnknownOrgUnits.add(entityArray);
                            continue;
                        }
                        this.selectedOrgUnits.put(entityArray[0].getInteger("id"), entityArray);
                    }
                    ArrayList<Entity> availableOrgUnits = new ArrayList<Entity>(this.availableOrgUnits.values());
                    availableOrgUnits.addAll(this.availableUnknownOrgUnits);
                    this.listViewer_availableOrgUnits.setInput(availableOrgUnits);
                    this.listViewer_availableOrgUnits.refresh();
                    ArrayList<Object> selectedOrgUnits = new ArrayList<Object>(this.selectedOrgUnits.values());
                    selectedOrgUnits.addAll(this.selectedUnknownOrgUnits);
                    this.listViewer_selectedOrgUnits.setInput(selectedOrgUnits);
                    this.listViewer_selectedOrgUnits.refresh();
                    this.prepareEntityListsForEntity(tempSelectedRoles, this.availableRoles, this.selectedRoles, this.selectedUnknownRoles);
                    this.refreshEntityTablesForEntity(this.availableRoles.values(), this.availableUnknownRoles, this.listViewer_availableRoles, this.selectedRoles.values(), this.selectedUnknownRoles, this.listViewer_selectedRoles);
                    for (DependantCondition depCond : tempSelectedDependantConditions) {
                        this.selectedDependantConditions.add(depCond);
                    }
                    if (this.dependenciesArea_listViewerDependantConditions != null) {
                        this.dependenciesArea_listViewerDependantConditions.refresh();
                    }
                }
            }
            return canBeAssisted;
        }

        private void prepareEntityListsForEntity(List<Entity> tempSelectedEntities, Map<Long, Entity> availableEntities, Map<Long, Entity> selectedEntities, List<Entity> selectedUnknownEntities) {
            for (Entity entity : tempSelectedEntities) {
                if (entity.getInteger("id") != Long.MIN_VALUE) {
                    if (availableEntities.containsKey(entity.getInteger("id"))) {
                        availableEntities.remove(entity.getInteger("id"));
                    }
                    selectedEntities.put(entity.getInteger("id"), entity);
                    continue;
                }
                selectedUnknownEntities.add(entity);
            }
        }

        private void refreshEntityTablesForEntity(Collection<Entity> availableEntities, List<Entity> availableUnknownEntities, StructuredViewer availableEntitiesViewer, Collection<Entity> selectedEntities, List<Entity> selectedUnknownEntities, StructuredViewer selectedEntitiesViewer) {
            ArrayList<Entity> tempAvailableEntities = new ArrayList<Entity>(availableEntities);
            tempAvailableEntities.addAll(availableUnknownEntities);
            availableEntitiesViewer.setInput(tempAvailableEntities);
            availableEntitiesViewer.refresh();
            ArrayList<Entity> tempSelectedEntities = new ArrayList<Entity>(selectedEntities);
            tempSelectedEntities.addAll(selectedUnknownEntities);
            selectedEntitiesViewer.setInput(tempSelectedEntities);
            selectedEntitiesViewer.refresh();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean parseAtomicEntityExpression(AtomicEntityExpression atomicExp, List<Entity> selectedAgents, List<Entity> selectedOrgPositions, List<Entity> selectedOrgUnits, List<Entity> selectedRoles, List<DependantCondition> selectedDependantConditions) {
            boolean successful = false;
            if (atomicExp.getEntityTypeAt(0) != EntityType.AGENT && atomicExp.getEntityTypeAt(0) != EntityType.ORG_POSITION && atomicExp.getEntityTypeAt(0) != EntityType.ORG_UNIT) {
                if (atomicExp.getEntityTypeAt(0) != EntityType.ROLE) return successful;
            }
            if (!(atomicExp.getSelectionAt(0) instanceof AtomicSelection)) return successful;
            AtomicSelection atomicSel = (AtomicSelection)atomicExp.getSelectionAt(0);
            if (atomicSel.getValue() instanceof ParameterRef) {
                if (!atomicSel.getAttriubteName().equalsIgnoreCase("id")) {
                    return false;
                }
                ConditionTarget target = null;
                if (atomicExp.getFunctionCount() == 0) {
                    if (atomicExp.getEntityTypeAt(0) == EntityType.AGENT) {
                        target = ConditionTarget.AGENT;
                    } else {
                        if (atomicExp.getEntityTypeAt(0) != EntityType.ORG_POSITION) return false;
                        target = ConditionTarget.ORG_POSITION;
                    }
                } else if (atomicExp.getEntityTypeAt(0) == EntityType.ORG_POSITION && atomicExp.getFunctionCount() == 2 && atomicExp.getFunctionAt(0).getFunction().equals(NavFunction.getFunction((EntityType)EntityType.ORG_POSITION, (String)"getOrgUnit")) && atomicExp.getFunctionAt(1).getFunction().equals(NavFunction.getFunction((EntityType)EntityType.ORG_UNIT, (String)"getManagerPosition"))) {
                    target = ConditionTarget.AGENT_SUPERIOR;
                }
                if (target == null) return true;
                successful = true;
                ParameterRef paramRef = (ParameterRef)atomicSel.getValue();
                Dependency dep = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyOf(paramRef.getName());
                if (dep == null && this.parameterBindings.containsKey(paramRef.getName())) {
                    dep = this.parameterBindings.get(paramRef.getName());
                }
                if (dep == null) return true;
                selectedDependantConditions.add(new DependantCondition(target, dep));
                return true;
            }
            if (atomicSel.getEntityType() == null && atomicSel.getAttriubteName().equalsIgnoreCase("id") && atomicSel.getCmpOperator() == CmpOperator.EQUAL && DataType.getDataTypeForObject((Object)atomicSel.getValue()) == DataType.INTEGER) {
                try {
                    SessionToken session = Activator.getService().getSessionToken();
                    ModelExplorer modelExplorer = this.omm.getModelExplorer();
                    Long id = (Long)atomicSel.getValue();
                    if (atomicExp.getEntityTypeAt(0) == EntityType.AGENT) {
                        List selectedAgent = modelExplorer.getEntities(session, EntityType.AGENT, "id", CmpOperator.EQUAL, (Serializable)id, new String[]{"id", "username"});
                        if (!selectedAgent.isEmpty()) {
                            selectedAgents.add((Entity)selectedAgent.get(0));
                            return true;
                        } else {
                            Entity dummyEntity = new Entity(EntityType.AGENT, ((Long)atomicSel.getValue()).longValue());
                            dummyEntity.set("username", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                            selectedAgents.add(dummyEntity);
                        }
                        return true;
                    }
                    if (atomicExp.getEntityTypeAt(0) == EntityType.ORG_POSITION) {
                        List selectedOrgPosition = modelExplorer.getEntities(session, EntityType.ORG_POSITION, "id", CmpOperator.EQUAL, (Serializable)id, new String[]{"id", "name"});
                        if (!selectedOrgPosition.isEmpty()) {
                            selectedOrgPositions.add((Entity)selectedOrgPosition.get(0));
                            return true;
                        } else {
                            Entity dummyEntity = new Entity(EntityType.ORG_POSITION, ((Long)atomicSel.getValue()).longValue());
                            dummyEntity.set("name", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                            selectedOrgPositions.add(dummyEntity);
                        }
                        return true;
                    }
                    if (atomicExp.getEntityTypeAt(0) == EntityType.ORG_UNIT) {
                        List selectedOrgUnit = modelExplorer.getEntities(session, EntityType.ORG_UNIT, "id", CmpOperator.EQUAL, (Serializable)id, new String[]{"id", "name"});
                        if (!selectedOrgUnit.isEmpty()) {
                            selectedOrgUnits.add((Entity)selectedOrgUnit.get(0));
                            return true;
                        } else {
                            Entity dummyEntity = new Entity(EntityType.ORG_UNIT, ((Long)atomicSel.getValue()).longValue());
                            dummyEntity.set("name", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                            selectedOrgUnits.add(dummyEntity);
                        }
                        return true;
                    }
                    List selectedRole = modelExplorer.getEntities(session, EntityType.ROLE, "id", CmpOperator.EQUAL, (Serializable)id, new String[]{"id", "name"});
                    if (!selectedRole.isEmpty()) {
                        selectedRoles.add((Entity)selectedRole.get(0));
                        return true;
                    }
                    Entity dummyEntity = new Entity(EntityType.ROLE, ((Long)atomicSel.getValue()).longValue());
                    dummyEntity.set("name", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                    selectedRoles.add(dummyEntity);
                    return true;
                }
                catch (DataSourceException e) {
                    String msg = "An error occurred while fetching data from the OrgModel! An error dialogue will be displayed.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)e);
                }
                return true;
            }
            if (atomicSel.getEntityType() != null) return false;
            if (!atomicSel.getAttriubteName().equalsIgnoreCase("username")) {
                if (!atomicSel.getAttriubteName().equalsIgnoreCase("name")) return false;
            }
            if (atomicSel.getCmpOperator() != CmpOperator.EQUAL) return false;
            if (DataType.getDataTypeForObject((Object)atomicSel.getValue()) != DataType.STRING) return false;
            SessionToken session = Activator.getService().getSessionToken();
            try {
                String name = (String)atomicSel.getValue();
                ModelExplorer modelExplorer = this.omm.getModelExplorer();
                if (atomicExp.getEntityTypeAt(0) == EntityType.AGENT) {
                    List selectedAgent = modelExplorer.getEntities(session, EntityType.AGENT, "username", CmpOperator.EQUAL, (Serializable)((Object)name), new String[]{"id", "username"});
                    assert (selectedAgent.size() <= 1);
                    if (selectedAgent.size() == 0) {
                        Entity dummyEntity = new Entity(EntityType.AGENT);
                        dummyEntity.set("id", (Object)Long.MIN_VALUE);
                        dummyEntity.set("username", (Object)name);
                        selectedAgent.add(dummyEntity);
                    }
                    selectedAgents.add((Entity)selectedAgent.get(0));
                } else if (atomicExp.getEntityTypeAt(0) == EntityType.ORG_POSITION) {
                    List selectedOrgPosition = modelExplorer.getEntities(session, EntityType.ORG_POSITION, "name", CmpOperator.EQUAL, (Serializable)((Object)name), new String[]{"id", "name"});
                    assert (selectedOrgPosition.size() <= 1);
                    if (selectedOrgPosition.size() == 0) {
                        Entity dummyEntity = new Entity(EntityType.ORG_POSITION);
                        dummyEntity.set("id", (Object)Long.MIN_VALUE);
                        dummyEntity.set("name", (Object)name);
                        selectedOrgPosition.add(dummyEntity);
                    }
                    selectedOrgPositions.add((Entity)selectedOrgPosition.get(0));
                } else if (atomicExp.getEntityTypeAt(0) == EntityType.ORG_UNIT) {
                    List selectedOrgUnit = modelExplorer.getEntities(session, EntityType.ORG_UNIT, "name", CmpOperator.EQUAL, (Serializable)((Object)name), new String[]{"id", "name"});
                    assert (selectedOrgUnit.size() <= 1);
                    if (selectedOrgUnit.size() == 0) {
                        Entity dummyEntity = new Entity(EntityType.ORG_UNIT);
                        dummyEntity.set("id", (Object)Long.MIN_VALUE);
                        dummyEntity.set("name", (Object)name);
                        selectedOrgUnit.add(dummyEntity);
                    }
                    selectedOrgUnits.add((Entity)selectedOrgUnit.get(0));
                } else {
                    List selectedRole = modelExplorer.getEntities(session, EntityType.ROLE, "name", CmpOperator.EQUAL, (Serializable)((Object)name), new String[]{"id", "name"});
                    assert (selectedRole.size() <= 1);
                    if (selectedRole.size() == 0) {
                        Entity dummyEntity = new Entity(EntityType.ROLE);
                        dummyEntity.set("id", (Object)Long.MIN_VALUE);
                        dummyEntity.set("name", (Object)name);
                        selectedRole.add(dummyEntity);
                    }
                    selectedRoles.add((Entity)selectedRole.get(0));
                }
            }
            catch (DataSourceException e) {
                String msg = "An error occurred while fetching data from the OrgModel! An error dialogue will be displayed.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)e);
            }
            this.button_identifierMode.setSelection(true);
            return true;
        }

        private boolean parseOrgUnitRoleComplexEntityExpression(ComplexEntityExpression complexOrgUnitRoleExp, List<Entity[]> selectedOrgUnitRoleCombinations) {
            boolean successful = false;
            if (complexOrgUnitRoleExp.getType() == ComplexEntityExpression.Type.INTERSECTION && complexOrgUnitRoleExp.getSubExpressionCount() == 2 && complexOrgUnitRoleExp.getSubExpressionAt(0) instanceof AtomicEntityExpression && complexOrgUnitRoleExp.getSubExpressionAt(1) instanceof AtomicEntityExpression) {
                AtomicEntityExpression orgUnitExp = (AtomicEntityExpression)complexOrgUnitRoleExp.getSubExpressionAt(0);
                AtomicEntityExpression roleExp = (AtomicEntityExpression)complexOrgUnitRoleExp.getSubExpressionAt(1);
                if (orgUnitExp.getEntityTypeAt(0) == EntityType.ORG_UNIT && roleExp.getEntityTypeAt(0) == EntityType.ROLE) {
                    AtomicSelection atomicOrgUnitSel = (AtomicSelection)orgUnitExp.getSelectionAt(0);
                    AtomicSelection atomicRoleSel = (AtomicSelection)roleExp.getSelectionAt(0);
                    if (atomicOrgUnitSel.getEntityType() == null && atomicOrgUnitSel.getAttriubteName().equalsIgnoreCase("id") && atomicOrgUnitSel.getCmpOperator() == CmpOperator.EQUAL && DataType.getDataTypeForObject((Object)atomicOrgUnitSel.getValue()) == DataType.INTEGER && atomicRoleSel.getEntityType() == null && atomicRoleSel.getAttriubteName().equalsIgnoreCase("id") && atomicRoleSel.getCmpOperator() == CmpOperator.EQUAL && DataType.getDataTypeForObject((Object)atomicRoleSel.getValue()) == DataType.INTEGER) {
                        Entity orgUnitEntity = null;
                        Entity roleEntity = null;
                        if (this.availableOrgUnits.containsKey((Long)atomicOrgUnitSel.getValue())) {
                            orgUnitEntity = this.availableOrgUnits.get((Long)atomicOrgUnitSel.getValue());
                        } else {
                            orgUnitEntity = new Entity(EntityType.ORG_UNIT, ((Long)atomicOrgUnitSel.getValue()).longValue());
                            orgUnitEntity.set("name", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                        }
                        if (this.availableRoles.containsKey((Long)atomicRoleSel.getValue())) {
                            roleEntity = this.availableRoles.get((Long)atomicRoleSel.getValue());
                        } else {
                            roleEntity = new Entity(EntityType.ROLE, ((Long)atomicRoleSel.getValue()).longValue());
                            roleEntity.set("name", (Object)SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY);
                        }
                        selectedOrgUnitRoleCombinations.add(new Entity[]{orgUnitEntity, roleEntity});
                    } else if (atomicOrgUnitSel.getEntityType() == null && atomicOrgUnitSel.getAttriubteName().equalsIgnoreCase("name") && atomicOrgUnitSel.getCmpOperator() == CmpOperator.EQUAL && DataType.getDataTypeForObject((Object)atomicOrgUnitSel.getValue()) == DataType.STRING && atomicRoleSel.getEntityType() == null && atomicRoleSel.getAttriubteName().equalsIgnoreCase("name") && atomicRoleSel.getCmpOperator() == CmpOperator.EQUAL && DataType.getDataTypeForObject((Object)atomicRoleSel.getValue()) == DataType.STRING) {
                        SessionToken session = Activator.getService().getSessionToken();
                        try {
                            String name = (String)atomicOrgUnitSel.getValue();
                            ModelExplorer modelExplorer = this.omm.getModelExplorer();
                            List selectedOrgUnit = modelExplorer.getEntities(session, EntityType.ORG_UNIT, "name", CmpOperator.EQUAL, (Serializable)((Object)name), new String[]{"id", "name"});
                            assert (selectedOrgUnit.size() <= 1);
                            if (selectedOrgUnit.size() == 0) {
                                Entity dummyEntity = new Entity(EntityType.ORG_UNIT);
                                dummyEntity.set("id", (Object)Long.MIN_VALUE);
                                dummyEntity.set("name", (Object)name);
                                selectedOrgUnit.add(dummyEntity);
                            }
                            String roleName = (String)atomicRoleSel.getValue();
                            List selectedRole = modelExplorer.getEntities(session, EntityType.ROLE, "name", CmpOperator.EQUAL, (Serializable)((Object)roleName), new String[]{"id", "name"});
                            assert (selectedRole.size() == 1);
                            if (selectedRole.size() == 0) {
                                Entity dummyEntity = new Entity(EntityType.ROLE);
                                dummyEntity.set("id", (Object)Long.MIN_VALUE);
                                dummyEntity.set("name", (Object)roleName);
                                selectedRole.add(dummyEntity);
                            }
                            selectedOrgUnitRoleCombinations.add(new Entity[]{(Entity)selectedOrgUnit.get(0), (Entity)selectedRole.get(0)});
                        }
                        catch (DataSourceException e) {
                            String msg = "An error occurred while fetching data from the OrgModel! An error dialogue will be displayed.";
                            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)e);
                        }
                        this.button_identifierMode.setSelection(true);
                    } else {
                        return false;
                    }
                    successful = true;
                }
            }
            return successful;
        }

        void editModeTabSelected() {
            switch (this.tabFolder_editModes.getSelectionIndex()) {
                case 0: {
                    String manualPolicy = this.text_manualEditPolicy.getText();
                    boolean canBeAssisted = this.initialiseAssistedEditingFromPolicy(manualPolicy);
                    if (!canBeAssisted) {
                        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm", (String)"The manually entered policy is currently not supported in Assisted Edit Mode. If you continue, the policy will be lost.");
                        if (!confirmed) {
                            this.tabFolder_editModes.setSelection(1);
                            return;
                        }
                        this.clearSelections();
                    } else if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider != null) {
                        this.parameterBindings.clear();
                        this.parameterBindings = this.bindingsUI.getParameterBindings();
                    }
                    this.updateAssistedEditPolicy(true);
                    break;
                }
                case 1: {
                    this.updateManualEditPolicy(false);
                    if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider == null) break;
                    this.bindingsUI.setParameterBindings(this.parameterBindings);
                }
            }
        }

        boolean isInAssistedEditMode() {
            return this.tabFolder_editModes.getSelectionIndex() == 0;
        }

        boolean isInManualEditMode() {
            return this.tabFolder_editModes.getSelectionIndex() == 1;
        }

        void updateAssistedEditPolicy(boolean forceAssignmentPreviewUpdate) {
            boolean bl;
            Entity roleEntity;
            Entity orgUnitEntity;
            String id;
            StringBuilder policyPreview = new StringBuilder();
            StringBuilder policyReal = new StringBuilder();
            boolean empty = true;
            for (Entity entity : this.selectedAgents.values()) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("Agent(username='").append(entity.getString("username")).append("')");
                    policyReal.append("Agent(username='").append(entity.getString("username")).append("')");
                    continue;
                }
                policyPreview.append("Agent(id=").append(entity.getInteger("id")).append(")");
                policyReal.append("Agent(id=").append(entity.getInteger("id")).append(")");
            }
            for (Entity entity : this.selectedUnknownAgents) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("Agent(username='").append(entity.getString("username")).append("')");
                    policyReal.append("Agent(username='").append(entity.getString("username")).append("')");
                    continue;
                }
                id = entity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(entity.getInteger("id")).toString();
                policyPreview.append("Agent(id=").append(id).append(")");
                policyReal.append("Agent(id=").append(id).append(")");
            }
            for (Entity entity : this.selectedOrgPositions.values()) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("OrgPosition(name='").append(entity.getString("name")).append("')");
                    policyReal.append("OrgPosition(name='").append(entity.getString("name")).append("')");
                    continue;
                }
                policyPreview.append("OrgPosition(id=").append(entity.getInteger("id")).append(")");
                policyReal.append("OrgPosition(id=").append(entity.getInteger("id")).append(")");
            }
            for (Entity entity : this.selectedUnknownOrgPositions) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("OrgPosition(name='").append(entity.getString("name")).append("')");
                    policyReal.append("OrgPosition(name='").append(entity.getString("name")).append("')");
                    continue;
                }
                id = entity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(entity.getInteger("id")).toString();
                policyPreview.append("OrgPosition(id=").append(id).append(")");
                policyReal.append("OrgPosition(id=").append(id).append(")");
            }
            for (Object object : this.selectedOrgUnits.values()) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                orgUnitEntity = null;
                roleEntity = null;
                if (object instanceof Entity) {
                    orgUnitEntity = (Entity)object;
                } else {
                    orgUnitEntity = ((Entity[])object)[0];
                    roleEntity = ((Entity[])object)[1];
                    policyPreview.append("(");
                    policyReal.append("(");
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("OrgUnit(name='").append(orgUnitEntity.getString("name")).append("')");
                    policyReal.append("OrgUnit(name='").append(orgUnitEntity.getString("name")).append("')");
                    if (roleEntity == null) continue;
                    policyPreview.append(" AND Role(name='").append(roleEntity.getString("name")).append("'))");
                    policyReal.append(" AND Role(name='").append(roleEntity.getString("name")).append("'))");
                    continue;
                }
                policyPreview.append("OrgUnit(id=").append(orgUnitEntity.getInteger("id")).append(")");
                policyReal.append("OrgUnit(id=").append(orgUnitEntity.getInteger("id")).append(")");
                if (roleEntity == null) continue;
                String roleId = roleEntity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(roleEntity.getInteger("id")).toString();
                policyPreview.append(" AND Role(id=").append(roleId).append("))");
                policyReal.append(" AND Role(id=").append(roleId).append("))");
            }
            for (Object object : this.selectedUnknownOrgUnits) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                orgUnitEntity = null;
                roleEntity = null;
                if (object instanceof Entity) {
                    orgUnitEntity = (Entity)object;
                } else {
                    orgUnitEntity = ((Entity[])object)[0];
                    roleEntity = ((Entity[])object)[1];
                    policyPreview.append("(");
                    policyReal.append("(");
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("OrgUnit(name='").append(orgUnitEntity.getString("name")).append("')");
                    policyReal.append("OrgUnit(name='").append(orgUnitEntity.getString("name")).append("')");
                    if (roleEntity == null) continue;
                    policyPreview.append(" AND Role(name='").append(roleEntity.getString("name")).append("'))");
                    policyReal.append(" AND Role(name='").append(roleEntity.getString("name")).append("'))");
                    continue;
                }
                String orgUnitId = orgUnitEntity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(orgUnitEntity.getInteger("id")).toString();
                policyPreview.append("OrgUnit(id=").append(orgUnitId).append(")");
                policyReal.append("OrgUnit(id=").append(orgUnitId).append(")");
                if (roleEntity == null) continue;
                String roleId = roleEntity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(roleEntity.getInteger("id")).toString();
                policyPreview.append(" AND Role(id=").append(roleId).append("))");
                policyReal.append(" AND Role(id=").append(roleId).append("))");
            }
            for (Entity entity : this.selectedRoles.values()) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("Role(name='").append(entity.getString("name")).append("')");
                    policyReal.append("Role(name='").append(entity.getString("name")).append("')");
                    continue;
                }
                policyPreview.append("Role(id=").append(entity.getInteger("id")).append(")");
                policyReal.append("Role(id=").append(entity.getInteger("id")).append(")");
            }
            for (Entity entity : this.selectedUnknownRoles) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                if (this.button_identifierMode.getSelection()) {
                    policyPreview.append("Role(name='").append(entity.getString("name")).append("')");
                    policyReal.append("Role(name='").append(entity.getString("name")).append("')");
                    continue;
                }
                id = entity.getInteger("id") == Long.MIN_VALUE ? SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY : new Long(entity.getInteger("id")).toString();
                policyPreview.append("Role(id=").append(id).append(")");
                policyReal.append("Role(id=").append(id).append(")");
            }
            String policyWithoutDependentConditions = policyReal.toString();
            for (DependantCondition dependantCondition : this.selectedDependantConditions) {
                if (!empty) {
                    policyPreview.append(" OR ");
                    policyReal.append(" OR ");
                } else {
                    empty = false;
                }
                switch (dependantCondition.target) {
                    case AGENT: {
                        policyPreview.append("Agent(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(dependantCondition.dependency)).append(")");
                        policyReal.append("Agent(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getPreferredParameter(dependantCondition.dependency)).append(")");
                        break;
                    }
                    case ORG_POSITION: {
                        policyPreview.append("OrgPosition(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(dependantCondition.dependency)).append(")");
                        policyReal.append("OrgPosition(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getPreferredParameter(dependantCondition.dependency)).append(")");
                        break;
                    }
                    case AGENT_SUPERIOR: {
                        policyPreview.append("OrgPosition(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(dependantCondition.dependency)).append(").getOrgUnit().getManagerPosition()");
                        policyReal.append("OrgPosition(id=").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getPreferredParameter(dependantCondition.dependency)).append(").getOrgUnit().getManagerPosition()");
                        break;
                    }
                    case DYNAMIC_ENTITY_EXPRESSION: {
                        policyPreview.append("(Entity Expression from ").append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(dependantCondition.dependency)).append(")");
                        policyReal.append(SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getPreferredParameter(dependantCondition.dependency));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unhandled ConditionTarget: " + (Object)((Object)dependantCondition.target)));
                    }
                }
            }
            boolean bl2 = bl = this.selectedDependantConditions.size() > 0;
            if (empty) {
                this.assistedEditPolicy = "";
                this.text_assistedEditPolicyPreview.setText("<empty>");
                this.text_manualEditPolicy.setText("");
                this.parameterBindings.clear();
                this.updateAssignmentPreview("", forceAssignmentPreviewUpdate);
            } else {
                String policyRealString;
                String policyPreviewString = policyPreview.toString();
                this.assistedEditPolicy = policyRealString = policyReal.toString();
                this.text_assistedEditPolicyPreview.setText(policyPreviewString);
                String replacedPolicy = policyRealString.replaceAll(SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY, new Long(Long.MIN_VALUE).toString());
                this.text_manualEditPolicy.setText(replacedPolicy);
                this.parameterBindings.clear();
                for (DependantCondition depCond : this.selectedDependantConditions) {
                    ParameterRef parameter = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getPreferredParameter(depCond.getDependency());
                    this.parameterBindings.put(parameter.getName(), depCond.getDependency());
                }
                this.updateAssignmentPreview(policyWithoutDependentConditions, forceAssignmentPreviewUpdate);
                if (bl) {
                    for (DependantCondition depCond : this.selectedDependantConditions) {
                        String fakeEntry = String.valueOf(depCond.target.displayName) + " (" + SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(depCond.dependency) + ")";
                        this.list_assignmentPreview.add(fakeEntry);
                    }
                }
            }
        }

        void updateManualEditPolicy(boolean forceAssignmentPreviewUpdate) {
            SessionToken session = Activator.getService().getSessionToken();
            String manualEditPolicy = this.text_manualEditPolicy.getText();
            try {
                if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider != null) {
                    this.currentReferencedParameters = SystemDataTools.findParameterReferences((String)manualEditPolicy);
                    this.bindingsUI.setParameterReferences(this.currentReferencedParameters);
                }
                boolean rejectParameters = SimpleStaffAssignmentRuleDialogue.this.dependencyProvider == null;
                this.currentProblems = this.omm.getPolicyResolution().checkResolvability(session, manualEditPolicy, true, rejectParameters);
                if (this.currentProblems.getOverallResult() != OrgPolicyReport.ResultType.ERROR && (this.currentReferencedParameters == null || this.currentReferencedParameters.length == 0)) {
                    this.updateAssignmentPreview(manualEditPolicy, forceAssignmentPreviewUpdate);
                } else {
                    this.updateAssignmentPreview(null, forceAssignmentPreviewUpdate);
                }
                this.tableViewer_problems.setInput((Object)this.currentProblems);
                this.tableViewer_problems.refresh();
            }
            catch (DataSourceException ex) {
                SimpleStaffAssignmentRuleDialogue.this.logger.log(Level.SEVERE, "An error occurred while trying to test the policy for resolvability! An error dialogue will be displayed.", ex);
                Status status = new Status(4, "MY_INSTANCE_NAME", 0, "An error occurred while accessing the data source!", (Throwable)ex);
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error while fetching data!", (String)"An error occurred while trying to test the policy for resolvability!", (IStatus)status);
            }
        }

        void updateAssignmentPreview(String policy, boolean forceUpdate) {
            SessionToken session = Activator.getService().getSessionToken();
            if ("".equals(policy)) {
                this.list_assignmentPreview.removeAll();
                this.list_assignmentPreview.setEnabled(true);
            } else if (policy != null && (forceUpdate || this.checkbox_assignmentPreviewAutoRefresh.getSelection())) {
                try {
                    String replacedPolicy = policy.replaceAll(SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY, new Long(Long.MIN_VALUE).toString());
                    Set results = this.omm.getPolicyResolution().resolvePolicy(session, replacedPolicy);
                    this.list_assignmentPreview.removeAll();
                    for (QualifiedAgent result : results) {
                        String string = String.valueOf(result.getAgentUserName()) + "(id=" + result.getAgentID() + ")";
                        string = String.valueOf(string) + " as " + result.getOrgPositionName();
                        this.list_assignmentPreview.add(string);
                    }
                    this.list_assignmentPreview.setEnabled(true);
                }
                catch (PolicyResolutionException ex) {
                    String msg = "The given policy could not be resolved!";
                    StatusTools.handleErrorStatus((String)"SimpleStaffAssignmentRuleDialogue", (String)msg, (Throwable)ex);
                }
                catch (DataSourceException ex) {
                    String msg = "An error occurred while trying to resolve the policy!";
                    StatusTools.handleErrorStatus((String)"SimpleStaffAssignmentRuleDialogue", (String)msg, (Throwable)ex);
                }
            } else {
                this.list_assignmentPreview.setEnabled(false);
                if (this.list_assignmentPreview.getItemCount() == 0) {
                    this.list_assignmentPreview.add("<policy cannot be resolved>");
                }
            }
        }

        void clearSelections() {
            this.availableAgents.putAll(this.selectedAgents);
            this.selectedAgents.clear();
            this.selectedUnknownAgents.clear();
            this.listViewer_availableAgents.refresh();
            this.listViewer_selectedAgents.refresh();
            this.availableOrgPositions.putAll(this.selectedOrgPositions);
            this.selectedOrgPositions.clear();
            this.selectedUnknownOrgPositions.clear();
            this.listViewer_availableOrgPositions.refresh();
            this.listViewer_selectedOrgPositions.refresh();
            HashMap<Long, Entity> tempSelectedOrgUnits = new HashMap<Long, Entity>();
            for (Object selectedOrgUnit : this.selectedOrgUnits.values()) {
                if (!(selectedOrgUnit instanceof Entity)) continue;
                tempSelectedOrgUnits.put(((Entity)selectedOrgUnit).getInteger("id"), (Entity)selectedOrgUnit);
            }
            this.availableOrgUnits.putAll(tempSelectedOrgUnits);
            this.selectedOrgUnits.clear();
            this.selectedUnknownOrgUnits.clear();
            this.listViewer_availableOrgUnits.refresh();
            this.listViewer_selectedOrgUnits.refresh();
            this.availableRoles.putAll(this.selectedRoles);
            this.selectedRoles.clear();
            this.selectedUnknownRoles.clear();
            this.listViewer_availableRoles.refresh();
            this.listViewer_selectedRoles.refresh();
            this.selectedDependantConditions.clear();
            if (this.dependenciesArea_listViewerDependantConditions != null) {
                this.dependenciesArea_listViewerDependantConditions.refresh();
            }
        }

        void selectAgents() {
            this.selectEntity(this.availableAgents, this.availableUnknownAgents, this.listViewer_availableAgents, this.selectedAgents, this.selectedUnknownAgents, this.listViewer_selectedAgents);
        }

        void deselectAgents() {
            this.deselectEntity(this.availableAgents, this.availableUnknownAgents, this.listViewer_availableAgents, this.selectedAgents, this.selectedUnknownAgents, this.listViewer_selectedAgents);
        }

        void selectOrgPositions() {
            this.selectEntity(this.availableOrgPositions, this.availableUnknownOrgPositions, this.listViewer_availableOrgPositions, this.selectedOrgPositions, this.selectedUnknownOrgPositions, this.listViewer_selectedOrgPositions);
        }

        void deselectOrgPositions() {
            this.deselectEntity(this.availableOrgPositions, this.availableUnknownOrgPositions, this.listViewer_availableOrgPositions, this.selectedOrgPositions, this.selectedUnknownOrgPositions, this.listViewer_selectedOrgPositions);
        }

        void selectOrgUnits() {
            Table table = (Table)this.listViewer_availableOrgUnits.getControl();
            int index = table.getSelectionIndex();
            StructuredSelection selection = (StructuredSelection)this.listViewer_availableOrgUnits.getSelection();
            if (!selection.isEmpty()) {
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    Entity orgUnit = (Entity)it.next();
                    if (this.button_OrgUnitRoleConnection.getSelection() && !this.comboViewer_roleForOrgUnit.getSelection().isEmpty()) {
                        Entity role = (Entity)((StructuredSelection)this.comboViewer_roleForOrgUnit.getSelection()).getFirstElement();
                        boolean duplicate = false;
                        boolean unknown = false;
                        if (orgUnit.getInteger("id") != Long.MIN_VALUE) {
                            Entity[] entity;
                            Long id = orgUnit.getInteger("id");
                            if (this.selectedOrgUnits.containsKey(id) && this.selectedOrgUnits.get(id) instanceof Entity[] && (entity = (Entity[])this.selectedOrgUnits.get(id))[0].equals((Object)orgUnit) && entity[1].equals((Object)role)) {
                                duplicate = true;
                                break;
                            }
                        } else {
                            unknown = true;
                            for (Object entity : this.selectedUnknownOrgUnits) {
                                if (!(entity instanceof Entity[]) || !((Entity[])entity)[0].equals((Object)orgUnit) || !((Entity[])entity)[1].equals((Object)role)) continue;
                                duplicate = true;
                                break;
                            }
                        }
                        if (duplicate) continue;
                        Entity[] orgUnitRole = new Entity[]{orgUnit, role};
                        if (unknown) {
                            this.selectedUnknownOrgUnits.add(orgUnitRole);
                            continue;
                        }
                        this.selectedOrgUnits.put(orgUnit.getInteger("id"), orgUnitRole);
                        continue;
                    }
                    if (orgUnit.getInteger("id") != Long.MIN_VALUE) {
                        Long id = orgUnit.getInteger("id");
                        this.availableOrgUnits.remove(id);
                        this.selectedOrgUnits.put(id, orgUnit);
                        continue;
                    }
                    Iterator<Entity> entityIterator = this.availableUnknownOrgUnits.iterator();
                    while (it.hasNext()) {
                        Entity unknownEntity = entityIterator.next();
                        if (unknownEntity.getInteger("id") != orgUnit.getInteger("id") || !unknownEntity.get("name").equals(orgUnit.get("name"))) continue;
                        entityIterator.remove();
                    }
                    this.selectedUnknownOrgUnits.add(orgUnit);
                }
                ArrayList<Entity> availableOrgUnits = new ArrayList<Entity>(this.availableOrgUnits.values());
                availableOrgUnits.addAll(this.availableUnknownOrgUnits);
                this.listViewer_availableOrgUnits.setInput(availableOrgUnits);
                this.listViewer_availableOrgUnits.refresh();
                ArrayList<Object> selectedOrgUnits = new ArrayList<Object>(this.selectedOrgUnits.values());
                selectedOrgUnits.addAll(this.selectedUnknownOrgUnits);
                this.listViewer_selectedOrgUnits.setInput(selectedOrgUnits);
                this.listViewer_selectedOrgUnits.refresh();
                if (index >= table.getItemCount()) {
                    index = table.getItemCount() - 1;
                }
                table.setSelection(index);
                this.updateAssistedEditPolicy(false);
            }
        }

        void deselectOrgUnits() {
            Table table = (Table)this.listViewer_selectedOrgUnits.getControl();
            int index = table.getSelectionIndex();
            StructuredSelection selection = (StructuredSelection)this.listViewer_selectedOrgUnits.getSelection();
            if (!selection.isEmpty()) {
                for (Object objectEntity : selection) {
                    Entity[] unknownEntity;
                    Object tempObject;
                    Iterator<Object> entityIterator;
                    Long id;
                    Entity[] entity;
                    if (objectEntity instanceof Entity) {
                        entity = (Entity[])objectEntity;
                        if (entity.getInteger("id") != Long.MIN_VALUE) {
                            id = entity.getInteger("id");
                            this.selectedOrgUnits.remove(id);
                            this.availableOrgUnits.put(id, (Entity)entity);
                            continue;
                        }
                        entityIterator = this.selectedUnknownOrgUnits.iterator();
                        while (entityIterator.hasNext()) {
                            tempObject = entityIterator.next();
                            if (!(tempObject instanceof Entity) || (unknownEntity = (Entity[])tempObject).getInteger("id") != entity.getInteger("id") || !unknownEntity.get("name").equals(entity.get("name"))) continue;
                            entityIterator.remove();
                        }
                        this.availableUnknownOrgUnits.add((Entity)entity);
                        continue;
                    }
                    entity = (Entity[])objectEntity;
                    if (entity[0].getInteger("id") != Long.MIN_VALUE) {
                        id = entity[0].getInteger("id");
                        this.selectedOrgUnits.remove(id);
                        continue;
                    }
                    entityIterator = this.selectedUnknownOrgUnits.iterator();
                    while (entityIterator.hasNext()) {
                        tempObject = entityIterator.next();
                        if (!(tempObject instanceof Entity[]) || (unknownEntity = (Entity[])tempObject)[0].getInteger("id") != entity[0].getInteger("id") || !unknownEntity[0].get("name").equals(entity[0].get("name"))) continue;
                        entityIterator.remove();
                    }
                }
                ArrayList<Entity> availableOrgUnits = new ArrayList<Entity>(this.availableOrgUnits.values());
                availableOrgUnits.addAll(this.availableUnknownOrgUnits);
                this.listViewer_availableOrgUnits.setInput(availableOrgUnits);
                this.listViewer_availableOrgUnits.refresh();
                ArrayList<Object> selectedOrgUnits = new ArrayList<Object>(this.selectedOrgUnits.values());
                selectedOrgUnits.addAll(this.selectedUnknownOrgUnits);
                this.listViewer_selectedOrgUnits.setInput(selectedOrgUnits);
                this.listViewer_selectedOrgUnits.refresh();
                if (index >= table.getItemCount()) {
                    index = table.getItemCount() - 1;
                }
                table.setSelection(index);
                this.updateAssistedEditPolicy(false);
            }
        }

        void selectRoles() {
            this.selectEntity(this.availableRoles, this.availableUnknownRoles, this.listViewer_availableRoles, this.selectedRoles, this.selectedUnknownRoles, this.listViewer_selectedRoles);
        }

        void deselectRoles() {
            this.deselectEntity(this.availableRoles, this.availableUnknownRoles, this.listViewer_availableRoles, this.selectedRoles, this.selectedUnknownRoles, this.listViewer_selectedRoles);
        }

        private void selectEntity(Map<Long, Entity> availableEntities, List<Entity> availableUnknownEntities, StructuredViewer availableEntitiesViewer, Map<Long, Entity> selectedEntities, List<Entity> selectedUnknownEntities, StructuredViewer selectedEntitiesViewer) {
            Table table = (Table)availableEntitiesViewer.getControl();
            int index = table.getSelectionIndex();
            StructuredSelection selection = (StructuredSelection)availableEntitiesViewer.getSelection();
            if (!selection.isEmpty()) {
                for (Entity entity : selection) {
                    if (entity.getInteger("id") != Long.MIN_VALUE) {
                        Long id = entity.getInteger("id");
                        availableEntities.remove(id);
                        selectedEntities.put(id, entity);
                        continue;
                    }
                    String name = entity.containsAttribute("username") ? "username" : "name";
                    Iterator<Entity> entityIterator = availableUnknownEntities.iterator();
                    while (entityIterator.hasNext()) {
                        Entity unknownEntity = entityIterator.next();
                        if (unknownEntity.getInteger("id") != entity.getInteger("id") || !unknownEntity.get(name).equals(entity.get(name))) continue;
                        entityIterator.remove();
                    }
                    selectedUnknownEntities.add(entity);
                }
                this.refreshEntityTablesForEntity(availableEntities.values(), availableUnknownEntities, availableEntitiesViewer, selectedEntities.values(), selectedUnknownEntities, selectedEntitiesViewer);
                if (index >= table.getItemCount()) {
                    index = table.getItemCount() - 1;
                }
                table.setSelection(index);
                this.updateAssistedEditPolicy(false);
            }
        }

        private void deselectEntity(Map<Long, Entity> availableEntities, List<Entity> availableUnknownEntities, StructuredViewer availableEntitiesViewer, Map<Long, Entity> selectedEntities, List<Entity> selectedUnknownEntities, StructuredViewer selectedEntitiesViewer) {
            Table table = (Table)selectedEntitiesViewer.getControl();
            int index = table.getSelectionIndex();
            StructuredSelection selection = (StructuredSelection)selectedEntitiesViewer.getSelection();
            if (!selection.isEmpty()) {
                for (Entity entity : selection) {
                    if (entity.getInteger("id") != Long.MIN_VALUE) {
                        Long id = entity.getInteger("id");
                        selectedEntities.remove(id);
                        availableEntities.put(id, entity);
                        continue;
                    }
                    String name = entity.containsAttribute("username") ? "username" : "name";
                    Iterator<Entity> entityIterator = selectedUnknownEntities.iterator();
                    while (entityIterator.hasNext()) {
                        Entity unknownEntity = entityIterator.next();
                        if (unknownEntity.getInteger("id") != entity.getInteger("id") || !unknownEntity.get(name).equals(entity.get(name))) continue;
                        entityIterator.remove();
                    }
                    availableUnknownEntities.add(entity);
                }
                this.refreshEntityTablesForEntity(availableEntities.values(), availableUnknownEntities, availableEntitiesViewer, selectedEntities.values(), selectedUnknownEntities, selectedEntitiesViewer);
                if (index >= table.getItemCount()) {
                    index = table.getItemCount() - 1;
                }
                table.setSelection(index);
                this.updateAssistedEditPolicy(false);
            }
        }

        void policyPreviewAutoRefreshToggled() {
            if (this.checkbox_assignmentPreviewAutoRefresh.getSelection()) {
                this.button_assignmentPreviewRefresh.setEnabled(false);
                if (this.isInAssistedEditMode()) {
                    this.updateAssistedEditPolicy(true);
                } else {
                    this.updateManualEditPolicy(true);
                }
            } else {
                this.button_assignmentPreviewRefresh.setEnabled(true);
            }
        }

        protected void okPressed() {
            String message = "The staff assignment rule contains ids with <unknown> or names with <not in the org model>. Saving those values are not allowed. Try to switch back to id/name mode or remove those entities.";
            if (this.isInAssistedEditMode()) {
                if (this.assistedEditPolicy.contains(SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY) || this.assistedEditPolicy.contains(SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY)) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"SAR not valid", (String)message);
                    return;
                }
                this.newPolicy = this.assistedEditPolicy;
            } else {
                if (this.text_manualEditPolicy.getText().contains(SimpleStaffAssignmentRuleDialogue.UNKNOWN_ID_DUMMY) || this.text_manualEditPolicy.getText().contains(SimpleStaffAssignmentRuleDialogue.UNKNOWN_NAME_DUMMY)) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"SAR not valid", (String)message);
                    return;
                }
                this.newPolicy = this.text_manualEditPolicy.getText();
                if (SimpleStaffAssignmentRuleDialogue.this.dependencyProvider != null) {
                    this.parameterBindings.clear();
                    this.parameterBindings = this.bindingsUI.getParameterBindings();
                }
            }
            super.okPressed();
        }

        public boolean close() {
            this.color_underlineFailure.dispose();
            this.color_underlineWarning.dispose();
            this.color_highlightAffectedRange.dispose();
            return super.close();
        }

        class UsedParameterLabelProvider
        extends BaseLabelProvider
        implements ITableLabelProvider {
            UsedParameterLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ParameterRef param = (ParameterRef)element;
                switch (columnIndex) {
                    case 0: {
                        return param.getName();
                    }
                    case 1: {
                        return param.getDataType().toString();
                    }
                    case 2: {
                        Dependency dep = ((OldStaffAssignmentRuleDialog)OldStaffAssignmentRuleDialog.this).SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getDependencyOf(param.getName());
                        if (dep == null) {
                            dep = OldStaffAssignmentRuleDialog.this.parameterBindings.get(param.getName());
                        }
                        return ((OldStaffAssignmentRuleDialog)OldStaffAssignmentRuleDialog.this).SimpleStaffAssignmentRuleDialogue.this.dependencyProvider.getLabelForTypeAndArgument(dep);
                    }
                }
                return null;
            }
        }
    }
}

