/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor;

import de.aristaflow.adept2.app.processtemplateeditor.ApplicationActionBarAdvisor;
import de.aristaflow.adept2.ui.processediting.views.ChangeOperationsView;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1024, 768));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowMenuBar(true);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IViewPart changeOpView = this.getWindowConfigurer().getWindow().getActivePage().findView(ChangeOperationsView.ID);
        if (changeOpView == null) {
            this.logger.warning("Could not find the change op view - selections may not be available on start-up.");
        } else {
            changeOpView.setFocus();
        }
        ICoolBarManager coolBarManager = this.getWindowConfigurer().getActionBarConfigurer().getCoolBarManager();
        coolBarManager.remove("org.eclipse.ui.WorkingSetActionSet");
        coolBarManager.remove("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        coolBarManager.remove("org.eclipse.ui.edit.text.actionSet.navigation");
        coolBarManager.update(true);
        IMenuManager menuManager = this.getWindowConfigurer().getActionBarConfigurer().getMenuManager();
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item.getId() != null && item.getId().equals("help")) {
                IMenuManager helpMenu = (IMenuManager)item;
                helpMenu.remove("group.updates");
                helpMenu.remove("group.assist");
                helpMenu.remove("org.eclipse.ui.actionSet.keyBindings");
                helpMenu.remove("org.eclipse.ui.actions.showKeyAssistHandler");
                helpMenu.remove("org.eclipse.update.ui.updateMenu");
                helpMenu.update(true);
                break;
            }
            ++n2;
        }
    }

    public boolean preWindowShellClose() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
        return super.preWindowShellClose();
    }
}

