/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLConstants;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLHelperTools;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.templatemanagerview.TemplateManagerView;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class AddTemplateAction
implements IViewActionDelegate {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private TemplateManagerView view;

    public void run(IAction action) {
        TemplateStatus templateStatus;
        SessionToken session = Activator.getAdministrationService().getSessionToken();
        File file = this.getTemplateFile();
        if (file == null) {
            return;
        }
        ProcessModelFactory factory = Activator.getAdministrationService().getProcessModelFactory();
        factory.setCreateChangeable(false);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(factory);
        Throwable exception = null;
        Document document = null;
        try {
            document = XMLHelperTools.getDocumentFromFile((File)file, (Schema)ProcessModelXMLHelperTools.getSchemaForSchemaType((ProcessModelXMLConstants.SchemaType)ProcessModelXMLConstants.SchemaType.TEMPLATE), null);
        }
        catch (XMLFormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if (document == null) {
            String message = String.format("Couldn't load the template from '%1$s': %2$s", file.toString(), exception);
            this.logger.log(Level.SEVERE, message, exception);
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)exception);
            return;
        }
        Template template = xmlImport.getTemplateFromDocument(document);
        try {
            templateStatus = xmlImport.getTemplateStatusFromDocument(document);
            if (templateStatus == null) {
                throw new IllegalArgumentException("The template document did not contain a status element.");
            }
            Node startNode = template.getStartNode();
            int[] successors = template.getSuccByEdgeType(startNode.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
            Node secondNode = template.getNode(successors[0]);
            if (secondNode.isAutoStartEnabled()) {
                templateStatus.setSubprocessUsage(ProcessConstants.TemplateUsage.NO_SUBPROCESS);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            templateStatus = factory.createDefaultTemplateStatus(template.getID());
        }
        TemplateManager templateManager = Activator.getAdministrationService().getProcessManager().getTemplateManager();
        try {
            String msg;
            CheckReport checkReport = templateManager.storeNewTemplate(session, template, templateStatus);
            if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
                msg = "The template could not be uploaded, because it contains errors:";
                new CheckReportDialogue(new Shell(), checkReport, msg, 8, CheckReport.ResultType.WARNING).open();
            } else {
                msg = "The template was uploaded successfully!";
                new CheckReportDialogue(new Shell(), checkReport, msg, 2, CheckReport.ResultType.INFO).open();
            }
        }
        catch (RuntimeException e) {
            String message = "An exception ocurred while trying to add the template!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            throw e;
        }
        this.view.updateInput();
    }

    private File getTemplateFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setText("Choose Template file");
        String[] extensions = new String[]{"*.template"};
        dialog.setFilterExtensions(extensions);
        dialog.open();
        String fileName = dialog.getFileName();
        if ("".equals(fileName)) {
            return null;
        }
        return new File(String.valueOf(dialog.getFilterPath()) + File.separator + fileName);
    }

    public void init(IViewPart view) {
        this.view = view instanceof TemplateManagerView ? (TemplateManagerView)view : null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.view != null);
    }
}

