/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileInstanceInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileTemplateInput;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenFileAction
extends Action {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".OpenFileAction";
    protected final Logger logger;
    private static final String[] extensions = new String[]{"*.template", "*.instance", "*.*"};
    private IWorkbenchWindow window;
    private static final String PREF_FILE_OPEN_PATH = String.valueOf(Activator.getPluginID()) + ".FileOpenPath";
    private String initialPath;

    public OpenFileAction(IWorkbenchWindow window) {
        this.window = window;
        this.setId(ID);
        this.setText("Open File...");
        this.setEnabled(true);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER")));
        this.logger = LoggerTools.getLogger((Object)((Object)this));
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.initialPath = preferenceStore.getString(PREF_FILE_OPEN_PATH);
        if (this.initialPath == null) {
            this.initialPath = System.getProperty("user.dir");
        }
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.window.getShell(), 4098);
        dialog.setText("Open file");
        if (this.initialPath != null) {
            dialog.setFilterPath(this.initialPath);
        }
        dialog.setFilterExtensions(extensions);
        dialog.open();
        String[] fileNames = dialog.getFileNames();
        if (fileNames != null) {
            this.initialPath = dialog.getFilterPath();
            Activator.getDefault().getPreferenceStore().setValue(PREF_FILE_OPEN_PATH, this.initialPath);
            int i = 0;
            while (i < fileNames.length) {
                File file = new File(String.valueOf(this.initialPath) + File.separator + fileNames[i]);
                String editor = null;
                FileTemplateInput editorInput = null;
                if (fileNames[i].endsWith(".template")) {
                    FileTemplateInput fileInput;
                    editorInput = fileInput = new FileTemplateInput(file);
                    editor = this.getFileEditor(file, null);
                } else if (fileNames[i].endsWith(".instance")) {
                    FileInstanceInput instanceInput = new FileInstanceInput(file);
                    editorInput = instanceInput;
                    editor = this.getFileEditor(file, null);
                }
                if (editor != null) {
                    try {
                        IWorkbenchPage page = this.window.getActivePage();
                        page.openEditor((IEditorInput)editorInput, editor);
                    }
                    catch (PartInitException e) {
                        this.logger.severe(e.toString());
                    }
                } else {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("File Type not Supported: " + file.getName()));
                }
                ++i;
            }
        }
    }

    private String getFileEditor(File file, IContentType contentType) {
        IEditorRegistry editorRegistry = this.window.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor(file.getName(), contentType);
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }
}

