/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.processediting.editorinputs.TransientTemplateInput;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenFileTemplateManagerAction
implements IActionDelegate {
    final Logger logger = LoggerTools.getLogger((Object)this);
    private TemplateReference templateEntry;

    public void run(IAction action) {
        SessionToken session = Activator.getAdministrationService().getSessionToken();
        Template template = Activator.getAdministrationService().getProcessManager().getTemplateManager().getTemplate(session, this.templateEntry.getID());
        TransientTemplateInput templateInput = new TransientTemplateInput(template);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorRegistry editorRegistry = window.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor("file.template");
        try {
            page.openEditor((IEditorInput)templateInput, editorDescriptor.getId());
        }
        catch (PartInitException e) {
            this.logger.log(Level.SEVERE, "Could not instantiate editor for the template.", e);
            MessageDialog d = new MessageDialog(null, "Can not open template", null, "Error while loading the editor for the template", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            d.open();
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.templateEntry = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection tsel = (IStructuredSelection)selection;
            this.templateEntry = (TemplateReference)tsel.getFirstElement();
        }
        action.setEnabled(this.templateEntry != null);
    }
}

