/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.processediting.TemplateStatusEditor;
import de.aristaflow.adept2.ui.processediting.TemplateStatusProcessManagerInput;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenTemplateStatusAction
implements IActionDelegate {
    private TemplateReference templateEntry;

    public void run(IAction action) {
        UUID templateID = this.templateEntry.getID();
        String templateName = this.templateEntry.getName();
        ProcessManager processManager = Activator.getAdministrationService().getProcessManager();
        TemplateStatusProcessManagerInput input = new TemplateStatusProcessManagerInput(processManager, templateID, templateName);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)input, TemplateStatusEditor.ID);
        }
        catch (PartInitException e) {
            String message = "Could not instantiate editor for the template status.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.templateEntry = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            this.templateEntry = (TemplateReference)structSelection.getFirstElement();
        }
        action.setEnabled(this.templateEntry != null);
    }
}

