/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.w3c.dom.Document;

public class UploadTemplateAction
implements IObjectActionDelegate {
    ISelection selection = null;
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".UploadTemplateAction";
    private IWorkbenchPart activePart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public void run(IAction action) {
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        Iterator it = structSelection.iterator();
        while (it.hasNext()) {
            Document templateDoc;
            InputStream inputStream;
            try {
                IFile file = (IFile)it.next();
                if (!file.getFileExtension().equals("template")) {
                    MessageBox mb = new MessageBox(new Shell(), 1);
                    mb.setMessage("Only templates can be uploaded to the server.");
                    mb.open();
                    continue;
                }
                inputStream = file.getContents();
            }
            catch (CoreException e) {
                this.logger.log(Level.SEVERE, "Error while trying to convert the selection into an input stream.", e);
                throw new RuntimeException(e);
            }
            ProcessModelFactory pmf = Activator.getAdministrationService().getProcessModelFactory();
            ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
            try {
                templateDoc = XMLHelperTools.getDocumentFromStream((InputStream)inputStream);
            }
            catch (XMLFormatException e) {
                this.logger.log(Level.SEVERE, "The format of the xml file is not correct.", e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error while trying to read the input stream.", e);
                throw new RuntimeException(e);
            }
            Template template = xmlImport.getTemplateFromDocument(templateDoc);
            TemplateStatus templateStatus = xmlImport.getTemplateStatusFromDocument(templateDoc);
            if (templateStatus == null) {
                templateStatus = pmf.createDefaultTemplateStatus(template.getID());
            } else {
                Node startNode = template.getStartNode();
                int[] successors = template.getSuccByEdgeType(startNode.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
                Node secondNode = template.getNode(successors[0]);
                if (secondNode.isAutoStartEnabled()) {
                    templateStatus.setSubprocessUsage(ProcessConstants.TemplateUsage.NO_SUBPROCESS);
                }
            }
            SessionToken session = Activator.getAdministrationService().getSessionToken();
            try {
                String msg;
                TemplateManager templateManager = Activator.getAdministrationService().getProcessManager().getTemplateManager();
                CheckReport checkReport = templateManager.storeNewTemplate(session, template, templateStatus);
                Shell parentShell = this.activePart.getSite().getShell();
                if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
                    msg = "The template could not be uploaded, because it contains errors:";
                    new CheckReportDialogue(parentShell, checkReport, msg, 8, CheckReport.ResultType.WARNING).open();
                    continue;
                }
                msg = "The template was uploaded successfully!";
                new CheckReportDialogue(parentShell, checkReport, msg, 2, CheckReport.ResultType.INFO).open();
            }
            catch (RuntimeException e) {
                String message = "An exception ocurred while trying to add the template!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                throw e;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

