/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions.testclientconnection;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.app.processtemplateeditor.testclientconnection.TestClientConnection;
import de.aristaflow.adept2.app.processtemplateeditor.views.TestClientInstancesView;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceChangingInput;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AdHocModifyTestInstance
implements IViewActionDelegate {
    private Logger logger = LoggerTools.getLogger((Object)this);
    private TestClientInstancesView view;
    private TestClientConnection tcConnection;
    private UUID instanceID;
    private IStructuredSelection selection;

    public void init(IViewPart view) {
        this.view = (TestClientInstancesView)view;
        this.tcConnection = Activator.getDefault().getTestClientConnection();
    }

    public void run(IAction action) {
        Map.Entry element = (Map.Entry)this.selection.getFirstElement();
        this.instanceID = ((InstanceReference)element.getValue()).getID();
        InstanceChangingInput instanceInput = new InstanceChangingInput(this.instanceID, this.tcConnection.getProcessManager().getInstanceManager(), this.tcConnection.getExecutionManager().getInstanceChanging());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorRegistry editorRegistry = window.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDescriptor = editorRegistry.getDefaultEditor("file.instance");
        try {
            this.view.getViewSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)instanceInput, editorDescriptor.getId());
        }
        catch (PartInitException e) {
            this.logger.log(Level.SEVERE, "Could not instantiate editor for the instance.", e);
            MessageDialog d = new MessageDialog(null, "Can not open instance", null, "Error while loading the editor for the instance", 1, new String[]{"Ok"}, 0);
            d.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
        this.selection = (IStructuredSelection)selection;
    }
}

