/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions.testclientconnection;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.app.processtemplateeditor.testclientconnection.TestClientConnection;
import de.aristaflow.adept2.app.processtemplateeditor.views.TestClientInstancesView;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResetRunningAndFailedStepsAction
implements IViewActionDelegate {
    private IStructuredSelection selection;
    private TestClientInstancesView view;
    private TestClientConnection tcConnection;

    public void init(IViewPart view) {
        this.view = (TestClientInstancesView)view;
        this.tcConnection = Activator.getDefault().getTestClientConnection();
    }

    public void run(IAction action) {
        Map.Entry element = (Map.Entry)this.selection.getFirstElement();
        UUID instanceID = ((InstanceReference)element.getValue()).getID();
        SessionToken session = this.tcConnection.getSession();
        Instance instance = this.tcConnection.getProcessManager().getInstanceManager().getInstance(session, instanceID);
        block6: for (Node node : instance.getTemplate().getNodes()) {
            int nodeID = node.getID();
            ProcessConstants.NodeState state = instance.getNodeState(nodeID);
            EBPType ebpType = node.getExecutableBusinessProcess() == null ? EBPType.NULL : node.getExecutableBusinessProcess().getType();
            switch (state) {
                case NS_RUNNING: 
                case NS_FAILED: {
                    session = this.tcConnection.getSession();
                    EBPInstanceReference activity = Activator.getAdministrationService().getProcessModelFactory().createEBPInstanceReference(ebpType, instanceID, instance.getBaseTemplateID(), nodeID, instance.getNodeIteration(nodeID), node.getExecutableBusinessProcess() instanceof Activity, this.tcConnection.getExecutionManager().getURIs());
                    try {
                        this.tcConnection.getExecutionManager().getActivityStarting().resetActivity(session, activity, true);
                    }
                    catch (InvalidActivityStateException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidInstanceStateException e) {
                        e.printStackTrace();
                    }
                    continue block6;
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        this.selection = (IStructuredSelection)selection;
        action.setEnabled(true);
    }
}

