/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions.testclientconnection;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateInput;
import de.aristaflow.adept2.util.CheckReport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RunTemplate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        if (this.window.getActivePage().getActiveEditor() instanceof Editor) {
            CheckReport checkReport;
            Template template;
            Editor editor = (Editor)this.window.getActivePage().getActiveEditor();
            if (editor.isDirty()) {
                String title = "Unsaved Changes";
                String msg = "The template in the editor contains changes. Do you want to save them before running the template in the Test Client?";
                String[] buttonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dlg = new MessageDialog(this.window.getShell(), title, null, msg, 3, buttonLabels, 0);
                int returnCode = dlg.open();
                switch (returnCode) {
                    case 0: {
                        this.window.getActivePage().saveEditor((IEditorPart)editor, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            ProcessCheckService processChecks = Activator.getModellingClientService().getProcessChecks();
            ProcessTemplateCheckRunner testClientChecks = new ProcessTemplateCheckRunner(new ProcessTemplateCheck[]{processChecks.getConsistencyChecks(), processChecks.getStructureChecks(), processChecks.getExecutionTestClientChecks()});
            boolean result = testClientChecks.performCheck(template = editor.getTemplate(), new NodeRelations(template), checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost")));
            if (!result) {
                String message = "Template does not fulfil test client execution checks, aborting start!";
                new CheckReportDialogue(this.window.getShell(), checkReport, message, 1, CheckReport.ResultType.WARNING).open();
                return;
            }
            boolean updateID = editor.getEditorInput() instanceof RepositoryTemplateInput;
            Activator.getDefault().getTestClientConnection().startTemplate(editor, template, updateID);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

