/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.actions.testclientconnection;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.app.processtemplateeditor.testclientconnection.TestClientConnection;
import de.aristaflow.adept2.app.processtemplateeditor.views.TestClientInstancesView;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class TakeOverModificationsAction
implements IViewActionDelegate {
    private IStructuredSelection selection;
    private TestClientInstancesView view;
    private TestClientConnection tcConnection;

    public void init(IViewPart view) {
        this.view = (TestClientInstancesView)view;
        this.tcConnection = Activator.getDefault().getTestClientConnection();
    }

    public void run(IAction action) {
        Map.Entry element = (Map.Entry)this.selection.getFirstElement();
        UUID instanceID = ((InstanceReference)element.getValue()).getID();
        SessionToken session = Activator.getModellingClientService().getSessionToken();
        Instance instance = this.tcConnection.getProcessManager().getInstanceManager().getInstance(session, instanceID);
        Template template = instance.getTemplate();
        Editor editor = this.tcConnection.getView().getEditors().get(((InstanceReference)element.getValue()).getLogID());
        if (editor == null) {
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)"The editor has already been closed, so the ad-hoc changes could not be applied to the template.", null);
            return;
        }
        TemplateInput.Holder holder = new TemplateInput.Holder(template, editor.getTemplateStatus());
        editor.setTemplate(holder);
        editor.markDirty();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        this.selection = (IStructuredSelection)selection;
        Map.Entry element = (Map.Entry)this.selection.getFirstElement();
        action.setEnabled(((InstanceReference)element.getValue()).isModified());
    }
}

