/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.testclientconnection;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.app.processtemplateeditor.testclientconnection.TestClientInstanceListener;
import de.aristaflow.adept2.app.processtemplateeditor.views.TestClientInstancesView;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TestClientConnection {
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    private static final Pattern SERVICE_PATTERN = Pattern.compile("^Service '(.*)' is available via '(.*)'.$");
    private static final String testClientProduct = "de.aristaflow.adept2.app.testclient.TestClientProduct";
    protected ProcessManager processManager;
    protected ExecutionManager executionManager;
    protected ClientSessionFactory testClientCSF;
    protected Process tcProcess;
    protected Thread waitForExitThread;
    private TestClientInstanceListener tcInstanceListener = Activator.getDefault().getTestClientInstanceListener();

    public TestClientConnection() {
        this.tcInstanceListener.setTestClientConnect(this);
    }

    private synchronized void startTestClient() {
        OrgModelManager orgModelManager;
        if (this.processManager != null) {
            return;
        }
        String processManagerURL = null;
        String executionManagerURL = null;
        String orgModelManagerURL = null;
        try {
            this.tcProcess = this.isDevelopment() ? this.getDevelopmentProcess() : this.getTestClientEXEProcess();
            if (this.tcProcess == null) {
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream stdOut = TestClientConnection.this.tcProcess.getErrorStream();
                    BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(stdOut));
                    try {
                        String line = stdOutReader.readLine();
                        while (line != null) {
                            TestClientConnection.this.logger.fine("TC_CON:STDERR: " + line);
                            line = stdOutReader.readLine();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "TestClientConnection.STDERR").start();
            InputStream stdOut = this.tcProcess.getInputStream();
            BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(stdOut));
            String line = stdOutReader.readLine();
            while (line != null) {
                Matcher matcher = SERVICE_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    line = stdOutReader.readLine();
                    continue;
                }
                String service = matcher.group(1);
                String url = matcher.group(2);
                if (service.startsWith("/OrgModelManager/")) {
                    orgModelManagerURL = url;
                }
                if (service.startsWith("/ProcessManager/")) {
                    processManagerURL = url;
                }
                if (service.startsWith("/ExecutionManager/")) {
                    executionManagerURL = url;
                }
                if (processManagerURL == null || executionManagerURL == null) {
                    line = stdOutReader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)"Unable to start test client!", (Throwable)e);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                InputStream stdOut = TestClientConnection.this.tcProcess.getInputStream();
                BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(stdOut));
                try {
                    String line = stdOutReader.readLine();
                    while (line != null) {
                        TestClientConnection.this.logger.fine("TC_CON:STDOUT: " + line);
                        line = stdOutReader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, "TestClientConnection.STDOUT").start();
        this.waitForExitThread = new Thread(new WaitForExit());
        this.waitForExitThread.start();
        try {
            orgModelManager = orgModelManagerURL == null ? Activator.getAdministrationService().getOrgModelManager() : Activator.getDefault().getService(new URI[]{URI.create(orgModelManagerURL)}, OrgModelManager.class);
            this.processManager = Activator.getDefault().getService(new URI[]{URI.create(processManagerURL)}, ProcessManager.class);
            this.executionManager = Activator.getDefault().getService(new URI[]{URI.create(executionManagerURL)}, ExecutionManager.class);
        }
        catch (ServiceNotKnownException e) {
            e.printStackTrace();
            orgModelManager = null;
            this.processManager = null;
            this.executionManager = null;
            throw new RuntimeException(e);
        }
        SecurityManager sm = orgModelManager.getSecurityManager();
        try {
            this.testClientCSF = sm.authenticate(-1L, -3L, "password");
            this.testClientCSF.setClientURIs(this.tcInstanceListener.getURIs());
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            orgModelManager = null;
            this.processManager = null;
            this.executionManager = null;
            throw new RuntimeException(e);
        }
        catch (DataSourceException e) {
            e.printStackTrace();
            orgModelManager = null;
            this.processManager = null;
            this.executionManager = null;
            throw new RuntimeException(e);
        }
    }

    private Process getTestClientEXEProcess() throws IOException {
        Map<String, String> env = System.getenv();
        String[] enva = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            enva[i] = String.valueOf(e.getKey()) + "=" + e.getValue();
            ++i;
        }
        String testClientCommand = Activator.getDefault().getPreferenceStore().getString("TestClientEXE");
        if (testClientCommand != null && testClientCommand.length() > 0) {
            File execDir = new File(testClientCommand).getParentFile();
            return Runtime.getRuntime().exec(testClientCommand, enva, execDir);
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"TestClient executable not set!", (String)"The executable of the Test Client needs to be set in the preferences.");
        return null;
    }

    private Process getDevelopmentProcess() throws IOException {
        String[] testClientCommand = this.getDevelopmentExecutable();
        return Runtime.getRuntime().exec(testClientCommand);
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public void startTemplate(Editor editor, Template originalTemplate, boolean updateID) {
        Template template;
        this.startTestClient();
        if (this.processManager == null) {
            return;
        }
        ProcessModelFactory pmf = Activator.getAdministrationService().getProcessModelFactory();
        if (updateID) {
            pmf.setCreateChangeable(true);
            template = ProcessModelTools.cloneTemplate((Template)originalTemplate, (ProcessModelFactory)pmf);
            ((ChangeableTemplate)template).updateID(UUIDTools.createPositiveUUID());
        } else {
            template = originalTemplate;
        }
        TemplateStatus templateStatus = pmf.createDefaultTemplateStatus(template.getID());
        templateStatus.setStarterRule("Agent()");
        LinkedList<Template> templateList = new LinkedList<Template>();
        LinkedList<TemplateStatus> templateStatusList = new LinkedList<TemplateStatus>();
        TemplateManager templateManager = Activator.getAdministrationService().getProcessManager().getTemplateManager();
        SessionToken localSession = Activator.getAdministrationService().getSessionToken();
        this.getSubProcessTemplates(templateManager, localSession, template, templateList, templateStatusList);
        templateList.add(template);
        templateStatusList.add(templateStatus);
        Template[] templates = new Template[templateList.size()];
        int counter = 0;
        Iterator iterator = templateList.iterator();
        while (iterator.hasNext()) {
            Template tempTemplate;
            templates[counter] = tempTemplate = (Template)iterator.next();
            ++counter;
        }
        counter = 0;
        TemplateStatus[] templateStatusArray = new TemplateStatus[templateStatusList.size()];
        Iterator iterator2 = templateStatusList.iterator();
        while (iterator2.hasNext()) {
            TemplateStatus tempStatus;
            templateStatusArray[counter] = tempStatus = (TemplateStatus)iterator2.next();
            ++counter;
        }
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SessionToken remoteSession = this.testClientCSF.getSessionToken();
        CheckReport report = this.processManager.getTemplateManager().storeNewTemplates(remoteSession, templates, templateStatusArray);
        if (report.getCheckResult() == CheckReport.ResultType.FAILURE) {
            String msg = "The template could not be started in the test client, because it contains errors:";
            new CheckReportDialogue(parentShell, report, msg, 1, CheckReport.ResultType.FAILURE).open();
            return;
        }
        try {
            UUID instanceID = this.executionManager.getInstanceControl().createAndStartInstance(remoteSession, template.getID(), this.tcInstanceListener.getURIs());
            remoteSession = this.testClientCSF.getSessionToken();
            InstanceReference instance = this.processManager.getInstanceManager().getInstanceReference(remoteSession, instanceID);
            this.getView().instanceStarted(editor, instance);
        }
        catch (InvalidTemplateStateException e) {
            e.printStackTrace();
        }
        catch (InvalidDataContainerException e) {
            e.printStackTrace();
        }
    }

    private void getSubProcessTemplates(TemplateManager templateManager, SessionToken session, Template template, List<Template> templates, List<TemplateStatus> templateStatusList) {
        for (Node node : template.getNodes()) {
            if (!(node.getExecutableBusinessProcess() instanceof ReferencedProcess)) continue;
            UUID templateID = ((ReferencedProcess)node.getExecutableBusinessProcess()).getTemplateID();
            Template subTemplate = templateManager.getTemplate(session, templateID);
            this.getSubProcessTemplates(templateManager, session, subTemplate, templates, templateStatusList);
            templates.add(subTemplate);
            templateStatusList.add(templateManager.getTemplateStatus(session, templateID));
        }
    }

    public TestClientInstancesView getView() {
        final TestClientInstancesView[] view = new TestClientInstancesView[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    view[0] = (TestClientInstancesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(TestClientInstancesView.ID, null, 1);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        return view[0];
    }

    private boolean isDevelopment() {
        String commandsString = System.getProperty("eclipse.commands");
        if (commandsString == null) {
            return false;
        }
        String[] commands = commandsString.split("\n");
        int i = 0;
        while (i < commands.length) {
            if (commands[i].equals("-launcher") && commands.length > i + 1) {
                return !commands[i + 1].contains("ProcessTemplateEditor");
            }
            ++i;
        }
        String launcherString = System.getProperty("eclipse.launcher");
        if (launcherString == null) {
            this.logger.warning("no property found for deciding on development / product mode");
            return false;
        }
        return !launcherString.contains("ProcessTemplateEditor");
    }

    private String[] getDevelopmentExecutable() {
        String launcher = System.getProperty("eclipse.launcher");
        String commandsString = System.getProperty("eclipse.commands");
        String[] commands = commandsString.split("\n");
        int i = 0;
        while (i < commands.length) {
            if (commands[i].equals("-launcher")) {
                if (commands.length > i + 1) {
                    launcher = commands[i + 1];
                    break;
                }
                throw new RuntimeException("Launcher not found!");
            }
            ++i;
        }
        String javaBin = "java";
        String adept2datadir = "-Darflow.datadir=" + SystemProperties.getDataDir();
        String adept2logdir = "-Darflow.logdir=" + System.getProperty("arflow.logdir");
        String adept2libdir = "-Darflow.libdir=" + SystemProperties.getLibDir();
        File confDirBase = new File(System.getProperty("arflow.datadir")).getParentFile();
        confDirBase = new File(confDirBase, "conf");
        String adept2confdir = String.format("-Darflow.confdir=%s%s%s%s%s%s%s", new File(confDirBase, "defaults").getAbsolutePath(), Character.valueOf(File.pathSeparatorChar), new File(confDirBase, "client-defaults").getAbsolutePath(), Character.valueOf(File.pathSeparatorChar), new File(confDirBase, "testclient").getAbsolutePath(), Character.valueOf(File.pathSeparatorChar), new File(confDirBase, "development-overrides-client").getAbsolutePath());
        String classpath = System.getProperty("java.class.path");
        String workspaceDir = String.valueOf(new File(URI.create(System.getProperty("osgi.instance.area").replace("ProcessTemplateEditor", "TestClient"))).getAbsolutePath()) + File.separator;
        String wsConfigDir = System.getProperty("osgi.configuration.area").replace("ProcessTemplateEditor", "TestClient");
        String wsDevProperties = System.getProperty("osgi.dev").replace("ProcessTemplateEditor", "TestClient");
        String os = System.getProperty("osgi.os");
        String ws = System.getProperty("osgi.ws");
        String arch = System.getProperty("osgi.arch");
        String nl = System.getProperty("osgi.nl.user");
        String[] command = new String[]{javaBin, adept2confdir, adept2logdir, adept2datadir, adept2libdir, "-Dfile.encoding=UTF-8", "-classpath", classpath, "org.eclipse.equinox.launcher.Main", "-launcher", launcher, "-name", "Eclipse", "-showsplash", "600", "-product", testClientProduct, "-data", workspaceDir, "-configuration", wsConfigDir, "-dev", wsDevProperties, "-os", os, "-ws", ws, "-arch", arch, "-nl", nl};
        return command;
    }

    public void instanceStateChanged(final UUID instanceID) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SessionToken session = Activator.getAdministrationService().getSessionToken();
                InstanceReference instance = TestClientConnection.this.processManager.getInstanceManager().getInstanceReference(session, instanceID);
                TestClientConnection.this.getView().instanceStateChanged(instance);
            }
        });
    }

    public SessionToken getSession() {
        if (this.testClientCSF == null) {
            return null;
        }
        return this.testClientCSF.getSessionToken();
    }

    public class WaitForExit
    implements Runnable {
        @Override
        public void run() {
            try {
                int ret = TestClientConnection.this.tcProcess.waitFor();
                if (ret != 0) {
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)("The Test Client process exited with code " + ret + "!"), null);
                }
                TestClientConnection.this.tcProcess = null;
                TestClientConnection.this.waitForExitThread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TestClientConnection.this.processManager = null;
            TestClientConnection.this.executionManager = null;
            TestClientConnection.this.testClientCSF = null;
            TestClientConnection.this.getView().testClientExited();
        }
    }
}

