/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.views;

import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.widgets.Composite;

public class InstanceListUIComponent
extends FilteredListUIComponent {
    private static final String COL_INSTANCE_NAME = "instanceName";
    private static final String COL_INSTANCE_EXEC_STATE = "instanceExecState";
    private static final String COL_INSTANCE_MODIFIED_STATE = "instanceModified";
    private Map<UUID, InstanceReference> instances;
    private Map<UUID, Editor> editors;

    public InstanceListUIComponent(Composite parent) {
        super(parent, 65536);
    }

    protected void registerColumns() {
        super.registerColumns();
        this.registerColumn(COL_INSTANCE_NAME, "Name", 16384, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry e = (Map.Entry)element;
                return ((InstanceReference)e.getValue()).getName();
            }
        }, null);
        this.registerColumn(COL_INSTANCE_EXEC_STATE, "Execution State", 0x1000000, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry e = (Map.Entry)element;
                return ((InstanceReference)e.getValue()).getExecutionStatus().readableName;
            }
        }, null);
        this.registerColumn(COL_INSTANCE_MODIFIED_STATE, "Modified", 0x1000000, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry e = (Map.Entry)element;
                return ((InstanceReference)e.getValue()).isModified() ? "yes" : "no";
            }
        }, null);
    }

    public void setInput(Map<UUID, InstanceReference> instances, Map<UUID, Editor> editors) {
        this.instances = instances;
        this.editors = editors;
        super.setInput(instances.entrySet());
    }
}

