/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.processtemplateeditor.views;

import de.aristaflow.adept2.app.processtemplateeditor.Activator;
import de.aristaflow.adept2.app.processtemplateeditor.views.InstanceListUIComponent;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InstanceReference;
import de.aristaflow.adept2.ui.processediting.Editor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TestClientInstancesView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".TestInstances";
    public InstanceListUIComponent instanceList;
    private static Map<UUID, InstanceReference> instances = new HashMap<UUID, InstanceReference>();
    private static Map<UUID, Editor> editors = new HashMap<UUID, Editor>();
    private IPartListener2 partListener = new IPartListener2(){

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart closedPart = partRef.getPart(false);
            if (closedPart instanceof Editor) {
                Iterator iter = editors.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (entry.getValue() != closedPart) continue;
                    iter.remove();
                }
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.instanceList = new InstanceListUIComponent(container);
        this.instanceList.registerFilter("hideTerminated", "Hide Terminated Instances", new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Map.Entry e = (Map.Entry)element;
                ProcessConstants.InstanceExecutionStatus execStatus = ((InstanceReference)e.getValue()).getExecutionStatus();
                return execStatus != ProcessConstants.InstanceExecutionStatus.IE_ABORTED && execStatus != ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED && execStatus != ProcessConstants.InstanceExecutionStatus.IE_FINISHED;
            }
        });
        this.instanceList.activateFilter("hideTerminated");
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.instanceList.getColumnViewer());
        this.instanceList.setInput(instances, editors);
        this.getSite().getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.instanceList.getColumnControl().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void instanceStarted(Editor editor, InstanceReference instance) {
        instances.put(instance.getLogID(), instance);
        editors.put(instance.getLogID(), editor);
        this.instanceList.getColumnControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestClientInstancesView.this.instanceList.getColumnViewer().refresh();
            }
        });
    }

    public void instanceStateChanged(InstanceReference instance) {
        instances.put(instance.getLogID(), instance);
        this.instanceList.getColumnControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestClientInstancesView.this.instanceList.getColumnViewer().refresh();
            }
        });
    }

    public void testClientExited() {
        instances.clear();
        editors.clear();
        this.instanceList.getColumnControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestClientInstancesView.this.instanceList.getColumnViewer().refresh();
            }
        });
    }

    public Map<UUID, Editor> getEditors() {
        return Collections.unmodifiableMap(editors);
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }
}

