/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.checkreportview;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.checkreportview.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processvisualisation.parts.BlockEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import de.aristaflow.adept2.util.CheckReport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CheckReportView
extends ViewPart
implements IPartListener2,
ITabbedPropertySheetPageContributor,
ISelectionChangedListener,
PropertyChangeListener {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".CheckReportView";
    private CheckReportListUIComponent viewer;
    private static final String TYPE_PROPERTY = "type";
    private static final String CHECK_ID_PROPERTY = "check id";
    private static final String MESSAGE_PROPERTY = "message";
    Editor currentEditor;
    private IPropertySheetPage propertyPage;

    public void createPartControl(Composite parent) {
        this.viewer = new CheckReportListUIComponent(parent);
        this.getSite().registerContextMenu(this.viewer.getContextMenu(), (ISelectionProvider)this.viewer.getColumnViewer());
        if (this.getSite().getPage() != null) {
            this.getSite().getPage().addPartListener((IPartListener2)this);
        }
        this.updateEditor(this.getSite().getPage().getActiveEditor(), false);
        this.viewer.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) instanceof IEditorPart) {
            this.updateEditor((IEditorPart)partRef.getPart(false), false);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) == this.currentEditor) {
            this.editorRemoved();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) instanceof IEditorPart) {
            this.updateEditor((IEditorPart)partRef.getPart(false), true);
        }
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            if (this.propertyPage == null) {
                this.propertyPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.propertyPage;
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return ID;
    }

    public synchronized void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)event.getSelection();
            Iterator iterator = sel.iterator();
            if (sel.getFirstElement() instanceof EditPart) {
                ArrayList<CheckReport.ReportEntry> reportEntries = new ArrayList<CheckReport.ReportEntry>();
                while (iterator.hasNext()) {
                    reportEntries.addAll(this.findReportEntries(iterator.next()));
                }
                this.viewer.getColumnViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
                this.viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection(reportEntries));
                this.viewer.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            } else if (sel.getFirstElement() instanceof CheckReport.ReportEntry) {
                this.currentEditor.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this);
                HashSet<EditPart> selectedParts = new HashSet<EditPart>();
                EditPart part = null;
                boolean firstElement = true;
                CheckReport.ReportEntry entry = null;
                while (iterator.hasNext()) {
                    DataElement dataElement;
                    entry = (CheckReport.ReportEntry)iterator.next();
                    if (entry.getAffectedADEPT2ProcessElements().length <= 0) continue;
                    Template template = this.currentEditor.getTemplate();
                    URI uri = entry.getAffectedADEPT2ProcessElements()[0];
                    String scheme = uri.getScheme();
                    String[] split = uri.getPath().split("/");
                    if (split.length < 3) continue;
                    String templateStr = split[1];
                    UUID templateID = UUID.fromString(templateStr);
                    String idStr = split[2];
                    int id = Integer.parseInt(idStr);
                    if (!template.getID().equals(templateID)) continue;
                    if (scheme.startsWith("node") || scheme.startsWith("parameter")) {
                        Node node = this.currentEditor.getTemplate().getNode(id);
                        if (node == null) continue;
                        part = (EditPart)this.currentEditor.getGraphicalViewer().getEditPartRegistry().get(node);
                        IProcessEditPart nodeEditPart = (IProcessEditPart)part;
                        if (!selectedParts.contains(part)) {
                            this.currentEditor.getSelectionManager().editPartClicked(nodeEditPart, !firstElement);
                            selectedParts.add(part);
                        }
                        firstElement = false;
                        continue;
                    }
                    if (!scheme.startsWith("dataelement") || (dataElement = this.currentEditor.getTemplate().getDataElement(id)) == null) continue;
                    part = (EditPart)this.currentEditor.getGraphicalViewer().getEditPartRegistry().get(dataElement);
                    IProcessEditPart dataElementEditPart = (IProcessEditPart)part;
                    if (!selectedParts.contains(part)) {
                        this.currentEditor.getSelectionManager().editPartClicked(dataElementEditPart, !firstElement);
                        selectedParts.add(part);
                    }
                    firstElement = false;
                }
                this.currentEditor.getSelectionManager().addSelectionChangedListener((ISelectionChangedListener)this);
                if (part != null && entry != null) {
                    this.currentEditor.getGraphicalViewer().reveal(part);
                }
            }
        }
    }

    protected void setSelectionProvider(ISelectionProvider provider) {
        this.getSite().setSelectionProvider(provider);
    }

    private void updateEditor(IEditorPart editorPart, boolean inputChanged) {
        if (this.currentEditor == editorPart && !inputChanged) {
            return;
        }
        if (this.currentEditor != null) {
            this.editorRemoved();
        }
        if (editorPart != null && editorPart instanceof Editor) {
            this.editorSet((Editor)editorPart);
        }
    }

    private void editorRemoved() {
        if (this.currentEditor.getSelectionManager() != null) {
            this.currentEditor.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentEditor.getUISettings().removeUIListener((PropertyChangeListener)this);
        this.setSelectionProvider(null);
        this.viewer.setInput(null, null);
    }

    private void editorSet(Editor editor) {
        this.currentEditor = editor;
        this.viewer.setInput(this.currentEditor.getTemplate(), this.currentEditor.getCheckReport());
        this.currentEditor.getUISettings().addUIListener((PropertyChangeListener)this);
        if (this.currentEditor.getSelectionManager() != null) {
            this.currentEditor.getSelectionManager().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelectionProvider((ISelectionProvider)this.currentEditor.getSelectionManager());
            IProcessEditPart activePart = this.currentEditor.getSelectionManager().getActiveEditPart();
            if (activePart != null) {
                List<CheckReport.ReportEntry> reportEntries = this.findReportEntries(activePart);
                this.viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection(reportEntries));
            }
        }
    }

    private List<CheckReport.ReportEntry> findReportEntries(Object part) {
        ArrayList<CheckReport.ReportEntry> reportEntries = new ArrayList<CheckReport.ReportEntry>();
        if (part instanceof DataElementEditPart) {
            DataElement dataElement = (DataElement)((EditPart)part).getModel();
            reportEntries.addAll(this.viewer.getDataElementReports(dataElement.getID()));
        } else if (part instanceof DefaultNodeEditPart) {
            Node node = (Node)((EditPart)part).getModel();
            reportEntries.addAll(this.viewer.getNodeReports(node.getID()));
        } else if (part instanceof TemplateEditPart || part instanceof BlockEditPart) {
            reportEntries.addAll(this.viewer.getTemplateReports());
        }
        return reportEntries;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this);
        if (this.currentEditor != null && this.currentEditor.getSelectionManager() != null) {
            this.currentEditor.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentEditor = null;
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.viewer.getColumnViewer().refresh();
    }

    class CheckReportLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public CheckReportLabelProvider(int column) {
            this.column = column;
        }

        public String getText(Object element) {
            if (!(element instanceof CheckReport.ReportEntry)) {
                throw new RuntimeException("getColumnText: element is not of type ReportEntry!");
            }
            CheckReport.ReportEntry entry = (CheckReport.ReportEntry)element;
            switch (this.column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return entry.getCheckID();
                }
                case 2: {
                    return entry.getMessage();
                }
            }
            return "Invalid column: " + this.column;
        }

        public Image getImage(Object element) {
            if (!(element instanceof CheckReport.ReportEntry)) {
                throw new RuntimeException("getColumnText: element is not of type ReportEntry!");
            }
            CheckReport.ReportEntry entry = (CheckReport.ReportEntry)element;
            switch (this.column) {
                case 0: {
                    switch (entry.getReportEntryType()) {
                        case OK: 
                        case INFO: {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                        }
                        case WARNING: {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                        }
                        case FAILURE: {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }

    public class CheckReportListUIComponent
    extends FilteredListUIComponent {
        private Map<Integer, Set<CheckReport.ReportEntry>> nodeReports;
        private Map<Integer, Set<CheckReport.ReportEntry>> dataElementReports;
        private Set<CheckReport.ReportEntry> templateReports;

        public CheckReportListUIComponent(Composite parent) {
            super(Table.class, parent, 65538, (QuickSearchFilterProvider)new CheckReportQuickSearchProvider());
            this.nodeReports = new HashMap<Integer, Set<CheckReport.ReportEntry>>();
            this.dataElementReports = new HashMap<Integer, Set<CheckReport.ReportEntry>>();
            this.templateReports = new HashSet<CheckReport.ReportEntry>();
            this.initColumns(new String[0], null, null, false);
        }

        protected void registerColumns() {
            super.registerColumns();
            this.registerColumn(CheckReportView.TYPE_PROPERTY, "Type", 16384, new ColumnData(1.0f), (CellLabelProvider)new CheckReportLabelProvider(0), null);
            this.registerColumn(CheckReportView.CHECK_ID_PROPERTY, "Check ID", 16384, new ColumnData(2.0f), (CellLabelProvider)new CheckReportLabelProvider(1), null);
            this.registerColumn(CheckReportView.MESSAGE_PROPERTY, "Message", 16384, new ColumnData(8.0f), (CellLabelProvider)new CheckReportLabelProvider(2), null);
            String sortColumn = CheckReportView.MESSAGE_PROPERTY;
            if (this.isColumnShown(sortColumn)) {
                this.setSortColumn(sortColumn, true);
            }
        }

        Collection<CheckReport.ReportEntry> getNodeReports(int id) {
            HashSet<Object> ret = this.nodeReports.get(id) != null ? new HashSet(this.nodeReports.get(id)) : new HashSet<CheckReport.ReportEntry>();
            return ret;
        }

        Collection<CheckReport.ReportEntry> getTemplateReports() {
            return new HashSet<CheckReport.ReportEntry>(this.templateReports);
        }

        Collection<CheckReport.ReportEntry> getDataElementReports(int id) {
            HashSet<Object> ret = this.dataElementReports.get(id) != null ? new HashSet(this.dataElementReports.get(id)) : new HashSet<CheckReport.ReportEntry>();
            return ret;
        }

        public void setInput(Template template, CheckReport report) {
            if (template == null) {
                this.nodeReports.clear();
                this.dataElementReports.clear();
                this.templateReports.clear();
                super.setInput(null);
                return;
            }
            for (CheckReport.ReportEntry entry : report.getReportEntries()) {
                URI[] uRIArray = entry.getAffectedADEPT2ProcessElements();
                int n = uRIArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Set<CheckReport.ReportEntry> set;
                    int id;
                    URI uri = uRIArray[n2];
                    String scheme = uri.getScheme();
                    String templateStr = uri.getPath().split("/")[1];
                    UUID templateID = UUID.fromString(templateStr);
                    String[] pathElements = uri.getPath().split("/");
                    if (pathElements.length > 2) {
                        String idStr = pathElements[2];
                        id = Integer.parseInt(idStr);
                    } else {
                        id = Integer.MIN_VALUE;
                    }
                    if (!template.getID().equals(templateID)) {
                        System.err.println("Template ID does not match!");
                    }
                    if (scheme.startsWith("node") || scheme.startsWith("parameter")) {
                        set = this.nodeReports.get(id);
                        if (set == null) {
                            set = new HashSet<CheckReport.ReportEntry>();
                        }
                        set.add(entry);
                        this.nodeReports.put(id, set);
                    } else if (scheme.startsWith("dataelement")) {
                        set = this.dataElementReports.get(id);
                        if (set == null) {
                            set = new HashSet<CheckReport.ReportEntry>();
                        }
                        set.add(entry);
                        this.dataElementReports.put(id, set);
                    } else if (scheme.startsWith("template")) {
                        this.templateReports.add(entry);
                    }
                    ++n2;
                }
            }
            super.setInput((Object)report.getReportEntries());
        }
    }

    protected static class CheckReportQuickSearchProvider
    implements QuickSearchFilterProvider {
        private final FilterFactory filterFac = Activator.getService().getFilterFactory();
        private final Attribute checkIDAttribute;
        private final Attribute messageAttribute;

        public CheckReportQuickSearchProvider() {
            AttributeFactory afTempl = this.filterFac.createAttributeFactory(CheckReport.ReportEntry.class);
            this.checkIDAttribute = afTempl.selectAttribute("getCheckID");
            this.messageAttribute = afTempl.selectAttribute("getMessage");
        }

        public ViewerFilter getQuickSearchFilter(String filterString) {
            StringBuilder filter = new StringBuilder("*");
            filter.append(filterString);
            filter.append("*");
            ComparisonFilter nameFilter = this.filterFac.createComparisonFilter(this.checkIDAttribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
            ComparisonFilter descriptionFilter = this.filterFac.createComparisonFilter(this.messageAttribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
            MultipleFilterFilter searchFilter = this.filterFac.createOrFilter(new Filter[]{nameFilter, descriptionFilter});
            return new AdeptFilterWrapper((Filter)searchFilter);
        }
    }
}

