/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor;

import de.aristaflow.adept2.app.activityrepositoryeditor.ApplicationActionBarAdvisor;
import de.aristaflow.adept2.ui.statushandling.WhiteErrorDialogue;
import de.aristaflow.adept2.util.JavaVersion;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        if (!JavaVersion.getCurrent().satisfiesMinimum("1.5")) {
            String msg = "The AristaFlow Activity Repository Editor requires Java %s to run, but was started with version %s! Shutting down.";
            msg = String.format(msg, "1.5", JavaVersion.getCurrent());
            WhiteErrorDialogue.openError(null, (String)"Wrong Java Version detected", (String)msg, null);
            PlatformUI.getWorkbench().close();
        }
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(800, 600));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IMenuManager menuManager = this.getWindowConfigurer().getActionBarConfigurer().getMenuManager();
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item.getId() != null && item.getId().equals("help")) {
                IMenuManager helpMenu = (IMenuManager)item;
                helpMenu.remove("group.updates");
                helpMenu.remove("group.assist");
                helpMenu.remove("org.eclipse.ui.actionSet.keyBindings");
                helpMenu.remove("org.eclipse.ui.actions.showKeyAssistHandler");
                helpMenu.remove("org.eclipse.update.ui.updateMenu");
                helpMenu.update(true);
                break;
            }
            ++n2;
        }
    }
}

