/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle.BundleExport;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.progress.IProgressService;

public class BundleExportAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private static String lastFolder;
    private List<String> selectedECDs = new ArrayList<String>();

    public void run(IAction action) {
        if (this.selectedECDs.size() == 0) {
            return;
        }
        String extension = "*.acb";
        String description = String.format("%s (%s)", "AristaFlow EC Bundle", extension);
        final String ecName = this.selectedECDs.get(0);
        File tempTargetFile = null;
        while (tempTargetFile == null || tempTargetFile.exists()) {
            FileDialog fileDialog = new FileDialog(this.targetPart.getSite().getWorkbenchWindow().getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            fileDialog.setText(String.format("Choose the destination file for the %s", "AristaFlow Executable Component Bundle"));
            fileDialog.setFilterExtensions(new String[]{extension});
            fileDialog.setFilterNames(new String[]{description});
            if (lastFolder != null) {
                fileDialog.setFilterPath(lastFolder);
            }
            fileDialog.setFileName(String.valueOf(ecName) + "." + "acb");
            String filePath = fileDialog.open();
            if (filePath == null) {
                return;
            }
            if (!filePath.endsWith(".acb")) {
                filePath = String.valueOf(filePath) + "." + "acb";
            }
            if ((tempTargetFile = new File(filePath)).exists()) {
                MessageBox msg = new MessageBox(this.targetPart.getSite().getShell(), 196);
                msg.setText("The file already exists");
                msg.setMessage(String.format("The file '%s' already exists. Do you want to replace the existing file?", tempTargetFile.getPath()));
                if (msg.open() == 64) break;
            }
            lastFolder = tempTargetFile.getParent();
        }
        final File targetFile = tempTargetFile;
        final Long branch = ARMHelper.getBranch();
        final Long revision = ARMHelper.getRevision();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    SessionToken session = Activator.getService().getSessionToken();
                    ActivityRepository ar = Activator.getService().getActivityRepository();
                    if (branch != null) {
                        BundleExport.exportBundleBranch(session, ar, ecName, branch, targetFile, monitor);
                    } else {
                        BundleExport.exportBundleRevision(session, ar, ecName, revision, targetFile, monitor);
                    }
                }
                catch (Exception ex) {
                    String msg = "An error occurred while exporting to the %s.";
                    msg = String.format(msg, "EC Bundle");
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                }
            }
        };
        IProgressService ps = this.targetPart.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(operation);
        }
        catch (InvocationTargetException ex) {
            String msg = "An error occurred while importing the %s.";
            msg = String.format(msg, "EC Bundle");
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedECDs.clear();
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object obj : structuredSelection) {
            if (!(obj instanceof ECDReference)) continue;
            this.selectedECDs.add(((ECDReference)obj).getName());
        }
        if (this.selectedECDs.size() > 0) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

