/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle.BundleImport;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.progress.IProgressService;

public class BundleImportAction
extends ActionDelegate
implements IViewActionDelegate {
    private IViewPart view;

    public void init(IViewPart newView) {
        this.view = newView;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ARMHelper.getBranch() != null);
    }

    public void run(IAction action) {
        String extension = "*.acb";
        String description = String.format("%s (%s)", "AristaFlow EC Bundle", extension);
        FileDialog fileDialog = new FileDialog(this.view.getSite().getShell(), 4098);
        fileDialog.setText(String.format("Choose the %s(s) to import", "AristaFlow Executable Component Bundle"));
        fileDialog.setFilterExtensions(new String[]{extension});
        fileDialog.setFilterNames(new String[]{description});
        String filePath = fileDialog.open();
        if (filePath == null) {
            return;
        }
        final String[] fileNames = fileDialog.getFileNames();
        final String fileFilterPath = fileDialog.getFilterPath();
        final SessionToken session = Activator.getService().getSessionToken();
        final ActivityRepository ar = Activator.getService().getActivityRepository();
        final ActivityModelFactory amf = Activator.getService().getActivityModelFactory();
        final long targetBranch = ARMHelper.getBranch();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileNames.length * 100));
                try {
                    try {
                        String[] stringArray = fileNames;
                        int n = fileNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            BundleImport.importBundle(session, ar, amf, new File(fileFilterPath, fileName), targetBranch, (IProgressMonitor)progress.newChild(100));
                            if (progress.isCanceled()) {
                                throw new InterruptedException("user cancelled operation");
                            }
                            ++n2;
                        }
                        BundleImportAction.this.view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ARMHelper.refreshRepositoryBrowserView();
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
                finally {
                    progress.done();
                }
            }
        };
        IProgressService ps = this.view.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(operation);
        }
        catch (InvocationTargetException ex) {
            String msg = "An error occurred while importing the %s.";
            msg = String.format(msg, "EC Bundle");
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }
}

