/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreateBranchAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        ActivityRepository repository = Activator.getService().getActivityRepository();
        CreateBranchWizard wizard = new CreateBranchWizard();
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        Branch branch = repository.getRevisionManager().createBranch(session, wizard.getComment());
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell());
        messageBox.setText("Created branch successfully!");
        String s = String.format("A new branch was created successfully!\n\nThe ID of the new branch is: %s\n\nYou are now working on this new branch!", branch.getBranch());
        messageBox.setMessage(s);
        messageBox.open();
        RepositoryBrowser repoBrowser = ARMHelper.getRepositoryBrowser();
        if (repoBrowser != null) {
            repoBrowser.setWorkingBranch(branch.getBranch());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    private class CreateBranchWizard
    extends Wizard {
        private CreateBranchWizardPage page;

        private CreateBranchWizard() {
        }

        public boolean performFinish() {
            return true;
        }

        public void addPages() {
            this.page = new CreateBranchWizardPage("CreateBranch");
            this.addPage((IWizardPage)this.page);
        }

        public void createPageControls(Composite pageContainer) {
            super.createPageControls(pageContainer);
            this.setWindowTitle("Create new branch");
        }

        public boolean performCancel() {
            return true;
        }

        public boolean canFinish() {
            return this.page.canFlipToNextPage();
        }

        public String getComment() {
            return this.page.getComment();
        }
    }

    private class CreateBranchWizardPage
    extends WizardPage
    implements ModifyListener {
        private Text txtComment;
        private String comment;

        protected CreateBranchWizardPage(String pageName) {
            super(pageName);
            this.setTitle("Create new branch");
            this.setDescription("Specify values of new branch here");
        }

        public void createControl(Composite parent) {
            Composite client = new Composite(parent, 0);
            client.setLayout((Layout)new GridLayout(2, false));
            Label lbl = new Label(client, 0);
            lbl.setText("Comment:");
            this.txtComment = new Text(client, 2048);
            this.txtComment.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtComment.addModifyListener((ModifyListener)this);
            this.modifyText(null);
            this.setControl((Control)client);
        }

        public boolean canFlipToNextPage() {
            return this.getErrorMessage() == null;
        }

        public void setErrorMessage(String newMessage) {
            super.setErrorMessage(newMessage);
            this.getContainer().updateButtons();
        }

        public void modifyText(ModifyEvent e) {
            if (this.txtComment.getText().length() == 0) {
                this.setErrorMessage("Please enter a comment for the new branch");
            } else {
                this.setErrorMessage(null);
                this.comment = this.txtComment.getText();
            }
        }

        public String getComment() {
            return this.comment;
        }
    }
}

