/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.actions.OpenEditorAction;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.OperationWizard;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class NewOperationAction
extends Action
implements IObjectActionDelegate {
    private ExecutableComponentDescription ecd = null;
    private ECDReference ecdReference = null;

    public void run(IAction action) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        if (this.ecd == null && this.ecdReference == null) {
            return;
        }
        ActivityRepository repository = Activator.getService().getActivityRepository();
        SessionToken session = Activator.getService().getSessionToken();
        if (this.ecd == null) {
            this.ecd = repository.getECDManager().getDevelopmentECD(session, this.ecdReference.getName(), ARMHelper.getBranch().longValue());
        }
        OperationWizard wizard = new OperationWizard(this.ecd);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            repository.getOperationManager().storeDevelopmentOperation(session, wizard.getOperation().getStorageOperation(), ARMHelper.getBranch().longValue());
            ARMHelper.refreshRepositoryBrowserView();
            Operation op = repository.getOperationManager().getDevelopmentOperation(session, wizard.getOperation().getExecutableComponentDescription().getName(), wizard.getOperation().getName(), ARMHelper.getBranch().longValue());
            OperationReference opRef = Activator.getService().getActivityModelFactory().createOperationReference(op.getExecutableComponentDescription().getName(), op.getName(), op.getDescription(), op.getDeveloperDescription(), op.getRevision(), op.getState(), op.getIconID(), (PluginDataContainer)op, op.getUserAttributes());
            OpenEditorAction oae = new OpenEditorAction();
            oae.setElement(opRef);
            oae.run();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ARMHelper.getBranch() != null);
        if (selection instanceof StructuredSelection) {
            Object o = ((StructuredSelection)selection).getFirstElement();
            if (o instanceof ExecutableComponentDescription) {
                this.ecd = (ExecutableComponentDescription)o;
                this.ecdReference = null;
            } else if (o instanceof ECDReference) {
                this.ecd = null;
                this.ecdReference = (ECDReference)o;
            } else {
                this.ecd = null;
                this.ecdReference = null;
            }
        } else {
            this.ecd = null;
            this.ecdReference = null;
        }
    }
}

