/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ActivityTemplateDefinitionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ExecutableComponentDescriptionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.IdentifierEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.OperationEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ActivityTemplateDefinitionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ExecutableComponentDescriptionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.IdentifierInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.OperationInput;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.globals.SystemIdentifier;
import de.aristaflow.adept2.ui.activityrepositorybrowser.extensions.OpenAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.UUID;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenEditorAction
extends OpenAction {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private Object element = null;

    public void setElement(Object element) {
        this.element = element;
        if (element == null) {
            return;
        }
        this.logger.info("Element set to " + element);
    }

    public void run() {
        if (this.element instanceof ECDReference) {
            this.openECDReference((ECDReference)this.element);
        }
        if (this.element instanceof ExecutableComponentDescription) {
            this.openECD((ExecutableComponentDescription)this.element);
        }
        if (this.element instanceof Identifier) {
            this.openIdentifier((Identifier)this.element);
        }
        if (this.element instanceof OperationReference) {
            this.openOperationReference((OperationReference)this.element);
        }
        if (this.element instanceof Operation) {
            this.openOperation((Operation)this.element);
        }
        if (this.element instanceof ATDReference) {
            this.openATDReference((ATDReference)this.element);
        }
        if (this.element instanceof ActivityTemplateDefinition) {
            this.openATD((ActivityTemplateDefinition)this.element);
        }
        StructuredSelection sel = new StructuredSelection(this.element);
        ARMHelper.getRepositoryBrowser().setSelection((ISelection)sel);
    }

    private void openECD(ExecutableComponentDescription ecd) {
        ExecutableComponentDescriptionInput input = new ExecutableComponentDescriptionInput(ecd, ARMHelper.getBranch() == null);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, ExecutableComponentDescriptionEditor.ID);
        }
        catch (PartInitException e) {
            throw new RuntimeException("Exception while opening editor", e);
        }
    }

    private void openECDReference(ECDReference ecdRef) {
        SessionToken session = Activator.getService().getSessionToken();
        try {
            ExecutableComponentDescription ecd = ARMHelper.getBranch() != null ? EditorHelper.activityRepository.getECDManager().getDevelopmentECD(session, ecdRef.getName(), ARMHelper.getBranch().longValue()) : EditorHelper.activityRepository.getECDManager().getECDRevision(session, ecdRef.getName(), ARMHelper.getRevision().longValue());
            this.openECD(ecd);
        }
        catch (RuntimeException ex) {
            String msg = "Could not retrieve the ECD from the Activity Repository.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    private void openIdentifier(Identifier id) {
        boolean isSystemIdentifier = SystemIdentifier.isSystemIdentifier((UUID)id.getID());
        IdentifierInput input = new IdentifierInput(id, ARMHelper.getBranch() == null || isSystemIdentifier);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, IdentifierEditor.ID);
        }
        catch (PartInitException e) {
            throw new RuntimeException("Exception while opening editor", e);
        }
    }

    private void openOperationReference(OperationReference ref) {
        SessionToken session = Activator.getService().getSessionToken();
        try {
            Operation op = ARMHelper.getBranch() != null ? EditorHelper.activityRepository.getOperationManager().getDevelopmentOperation(session, ref.getExecutableComponentName(), ref.getName(), ARMHelper.getBranch().longValue()) : EditorHelper.activityRepository.getOperationManager().getOperationRevision(session, ref.getExecutableComponentName(), ref.getName(), ARMHelper.getRevision().longValue());
            this.openOperation(op);
        }
        catch (RuntimeException ex) {
            String msg = "Could not retrieve the Operation from the Activity Repository.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    private void openOperation(Operation op) {
        OperationInput input = new OperationInput(op, ARMHelper.getBranch() == null);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, OperationEditor.ID);
        }
        catch (PartInitException e) {
            throw new RuntimeException("Exception while opening editor", e);
        }
    }

    private void openATDReference(ATDReference ref) {
        SessionToken session = Activator.getService().getSessionToken();
        try {
            ActivityTemplateDefinition atd = ARMHelper.getBranch() != null ? EditorHelper.activityRepository.getATDManager().getDevelopmentATD(session, ref.getExecutableComponentName(), ref.getOperationName(), ref.getName(), ARMHelper.getBranch().longValue()) : EditorHelper.activityRepository.getATDManager().getATDRevision(session, ref.getExecutableComponentName(), ref.getOperationName(), ref.getName(), ARMHelper.getRevision().longValue());
            this.openATD(atd);
        }
        catch (RuntimeException ex) {
            String msg = "Could not retrieve the ATD from the Activity Repository.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    private void openATD(ActivityTemplateDefinition atd) {
        ActivityTemplateDefinitionInput input = new ActivityTemplateDefinitionInput(atd, ARMHelper.getBranch() == null);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, ActivityTemplateDefinitionEditor.ID);
        }
        catch (PartInitException e) {
            throw new RuntimeException("Exception while opening editor", e);
        }
    }
}

