/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.globals.SystemIdentifier;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OutdateAction
extends Action
implements IObjectActionDelegate {
    private Object selectedObject = null;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (ARMHelper.getRevision() == null) {
            return;
        }
        boolean confirmed = MessageDialog.openConfirm((Shell)this.targetPart.getSite().getShell(), (String)"Outdate", (String)"Are you sure you want to outdate the selected entity?");
        if (!confirmed) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        ActivityRepository rep = Activator.getService().getActivityRepository();
        if (this.selectedObject instanceof ECDReference) {
            ECDReference ecd = (ECDReference)this.selectedObject;
            rep.getECDManager().outdateECD(session, ecd.getName());
        } else if (this.selectedObject instanceof OperationReference) {
            OperationReference op = (OperationReference)this.selectedObject;
            rep.getOperationManager().outdateOperation(session, op.getExecutableComponentName(), op.getName());
        } else if (this.selectedObject instanceof ATDReference) {
            ATDReference atd = (ATDReference)this.selectedObject;
            rep.getATDManager().outdateATD(session, atd.getExecutableComponentName(), atd.getOperationName(), atd.getName());
        } else if (this.selectedObject instanceof Identifier) {
            Identifier id = (Identifier)this.selectedObject;
            rep.getIdentifierManager().outdateIdentifier(session, id.getID());
        } else {
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)"Unknown Entitiy", (String)("Can't outdate entitiy of type " + this.selectedObject.getClass().getSimpleName()), null);
        }
        ARMHelper.refreshRepositoryBrowserView();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled;
        if (selection instanceof StructuredSelection) {
            Object o = ((StructuredSelection)selection).getFirstElement();
            enabled = o != null && ARMHelper.getRevision() != null && (o instanceof ECDReference || o instanceof OperationReference || o instanceof ATDReference || o instanceof Identifier);
            this.selectedObject = o;
            if (o instanceof Identifier && SystemIdentifier.isSystemIdentifier((UUID)((Identifier)o).getID())) {
                enabled = false;
            }
        } else {
            enabled = false;
            this.selectedObject = null;
        }
        action.setEnabled(enabled);
    }
}

