/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.InheritanceConflictException;
import de.aristaflow.adept2.model.activitymodel.RevisionConflictException;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import de.aristaflow.adept2.util.CheckReport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ReleaseBranchAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean closed;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(true);
            if (editor instanceof RepositoryEditor && !(closed = workbenchPage.closeEditor(editor, true))) {
                String title = "Branch not released";
                String msg = "The branch cannot be released as long as editors are open. Please save or discard any changes.";
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg);
                return;
            }
            ++n2;
        }
        ReleaseBranchWizard wizard = new ReleaseBranchWizard();
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        ActivityRepository repository = Activator.getService().getActivityRepository();
        try {
            repository.getRevisionManager().releaseBranch(session, ARMHelper.getBranch().longValue(), wizard.getComment());
        }
        catch (RevisionConflictException e) {
            throw new RuntimeException("A RevisionConflictException was thrown though not expected.", e);
        }
        catch (InheritanceConflictException e) {
            throw new RuntimeException("A InheritanceConflictException was thrown though not expected.", e);
        }
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell());
        messageBox.setText("Released branch successfully!");
        messageBox.setMessage("The branch was released successfully! You are viewing the newly created revision now!");
        messageBox.open();
        RepositoryBrowser repoBrowser = ARMHelper.getRepositoryBrowser();
        if (repoBrowser != null) {
            session = Activator.getService().getSessionToken();
            long latestRevision = repository.getRevisionManager().getLatestRevision(session).getRevision();
            repoBrowser.setWorkingRevision(latestRevision);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ARMHelper.getBranch() != null);
    }

    private class ReleaseBranchWizard
    extends Wizard {
        private ReleaseBranchWizardPage page;

        private ReleaseBranchWizard() {
        }

        public boolean performFinish() {
            return true;
        }

        public void addPages() {
            this.page = new ReleaseBranchWizardPage("ReleaseBranch");
            this.addPage((IWizardPage)this.page);
        }

        public void createPageControls(Composite pageContainer) {
            super.createPageControls(pageContainer);
            this.setWindowTitle("Release branch");
        }

        public boolean performCancel() {
            return true;
        }

        public boolean canFinish() {
            return this.page.canFlipToNextPage();
        }

        public String getComment() {
            return this.page.getComment();
        }
    }

    private class ReleaseBranchWizardPage
    extends WizardPage
    implements ModifyListener {
        private Text txtComment;
        private String comment;
        private boolean checkOK;

        protected ReleaseBranchWizardPage(String pageName) {
            super(pageName);
            this.setTitle("Release branch");
            this.setDescription("Specify values here");
        }

        public void createControl(Composite parent) {
            Composite client = new Composite(parent, 0);
            client.setLayout((Layout)new GridLayout(2, false));
            Label lbl = new Label(client, 0);
            lbl.setText("Comment:");
            this.txtComment = new Text(client, 2048);
            this.txtComment.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtComment.addModifyListener((ModifyListener)this);
            lbl = new Label(client, 0);
            lbl.setText("Check report:");
            Text txtCheck = new Text(client, 2122);
            txtCheck.setLayoutData((Object)new GridData(4, 4, true, true));
            ActivityRepository repository = Activator.getService().getActivityRepository();
            SessionToken session = Activator.getService().getSessionToken();
            CheckReport report = repository.getRevisionManager().checkBranch(session, ARMHelper.getBranch().longValue());
            this.txtComment.setText(repository.getRevisionManager().getBranchData(session, ARMHelper.getBranch().longValue()).getComment());
            txtCheck.setText(report.getAREReportSummary());
            this.checkOK = report.getCheckResult() != CheckReport.ResultType.FAILURE;
            this.modifyText(null);
            this.setControl((Control)client);
        }

        public boolean canFlipToNextPage() {
            return this.getErrorMessage() == null;
        }

        public void setErrorMessage(String newMessage) {
            super.setErrorMessage(newMessage);
            this.getContainer().updateButtons();
        }

        public void modifyText(ModifyEvent e) {
            if (!this.checkOK) {
                this.setErrorMessage("The check of the branch was not succcessful. See check report.");
                return;
            }
            if (this.txtComment.getText().length() == 0) {
                this.setErrorMessage("Please enter a comment");
            } else {
                this.setErrorMessage(null);
                this.comment = this.txtComment.getText();
            }
        }

        public String getComment() {
            return this.comment;
        }
    }
}

