/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.ui.activityrepositorybrowser.views.RepositoryBrowser;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RemoveBranchAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        MessageBox msg = new MessageBox(shell, 196);
        msg.setText("Removing branch");
        msg.setMessage("Are you sure to remove the currently displayed branch? It won't be recoverable at all!");
        if (msg.open() != 64) {
            return;
        }
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(true);
            if (editor instanceof RepositoryEditor) {
                workbenchPage.closeEditor(editor, false);
            }
            ++n2;
        }
        SessionToken session = Activator.getService().getSessionToken();
        ActivityRepository rep = Activator.getService().getActivityRepository();
        rep.getRevisionManager().removeBranch(session, ARMHelper.getBranch().longValue());
        msg = new MessageBox(shell, 34);
        msg.setText("Branch removed successfully");
        msg.setMessage("The branch was removed successfully. The latest revision will be shown.");
        msg.open();
        RepositoryBrowser repBrowser = ARMHelper.getRepositoryBrowser();
        if (repBrowser != null) {
            session = Activator.getService().getSessionToken();
            long latestRevision = rep.getRevisionManager().getLatestRevision(session).getRevision();
            repBrowser.setWorkingRevision(latestRevision);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ARMHelper.getBranch() != null);
    }
}

