/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ActivityTemplateDefinitionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ExecutableComponentDescriptionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.IdentifierInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.OperationInput;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RevertItemAction
extends Action
implements IObjectActionDelegate {
    private Object itemToRevert;

    private Collection<IEditorPart> editorsToCloseOnRevert(IEditorReference[] editors, SessionToken session, Object modelObject) {
        HashSet<IEditorPart> res;
        block20: {
            block22: {
                block21: {
                    block19: {
                        res = new HashSet<IEditorPart>();
                        if (!(modelObject instanceof ECDReference)) break block19;
                        ECDReference ecdRef = (ECDReference)modelObject;
                        IEditorReference[] iEditorReferenceArray = editors;
                        int n = editors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IEditorReference editorRef = iEditorReferenceArray[n2];
                            try {
                                ExecutableComponentDescriptionInput input;
                                ExecutableComponentDescription editorECD;
                                if (editorRef.getEditorInput() instanceof ExecutableComponentDescriptionInput && (editorECD = (ExecutableComponentDescription)(input = (ExecutableComponentDescriptionInput)editorRef.getEditorInput()).getAdapter(ExecutableComponentDescription.class)).getName().equals(ecdRef.getName())) {
                                    res.add(editorRef.getEditor(false));
                                }
                            }
                            catch (PartInitException e) {
                                throw new RuntimeException("Could not find editors to close recursively", e);
                            }
                            ++n2;
                        }
                        Collection ops = ARMHelper.getBranch() != null ? EditorHelper.activityRepository.getOperationManager().getDevelopmentOperationReferencesOfECD(session, ecdRef.getName(), ARMHelper.getBranch().longValue()) : EditorHelper.activityRepository.getOperationManager().getOperationReferencesRevisionOfECD(session, ecdRef.getName(), ARMHelper.getRevision().longValue());
                        for (OperationReference op : ops) {
                            res.addAll(this.editorsToCloseOnRevert(editors, session, op));
                        }
                        break block20;
                    }
                    if (!(modelObject instanceof OperationReference)) break block21;
                    OperationReference opRef = (OperationReference)modelObject;
                    IEditorReference[] iEditorReferenceArray = editors;
                    int n = editors.length;
                    int op = 0;
                    while (op < n) {
                        IEditorReference editorRef = iEditorReferenceArray[op];
                        try {
                            OperationInput input;
                            Operation editorOp;
                            if (editorRef.getEditorInput() instanceof OperationInput && (editorOp = (Operation)(input = (OperationInput)editorRef.getEditorInput()).getAdapter(Operation.class)).getName().equals(opRef.getName()) && editorOp.getExecutableComponentDescription().getName().equals(opRef.getExecutableComponentName())) {
                                res.add(editorRef.getEditor(false));
                            }
                        }
                        catch (PartInitException e) {
                            throw new RuntimeException("Could not find editors to close recursively", e);
                        }
                        ++op;
                    }
                    Collection atds = ARMHelper.getBranch() != null ? EditorHelper.activityRepository.getATDManager().getDevelopmentATDReferencesOfOperation(session, opRef.getExecutableComponentName(), opRef.getName(), ARMHelper.getBranch().longValue()) : EditorHelper.activityRepository.getATDManager().getATDReferencesRevisionOfOperation(session, opRef.getExecutableComponentName(), opRef.getName(), ARMHelper.getRevision().longValue());
                    for (ATDReference atd : atds) {
                        res.addAll(this.editorsToCloseOnRevert(editors, session, atd));
                    }
                    break block20;
                }
                if (!(modelObject instanceof ATDReference)) break block22;
                ATDReference atdRef = (ATDReference)modelObject;
                IEditorReference[] iEditorReferenceArray = editors;
                int n = editors.length;
                int n3 = 0;
                while (n3 < n) {
                    IEditorReference editorRef = iEditorReferenceArray[n3];
                    try {
                        ActivityTemplateDefinitionInput input;
                        ActivityTemplateDefinition editorATD;
                        if (editorRef.getEditorInput() instanceof ActivityTemplateDefinitionInput && (editorATD = (ActivityTemplateDefinition)(input = (ActivityTemplateDefinitionInput)editorRef.getEditorInput()).getAdapter(ActivityTemplateDefinition.class)).getName().equals(atdRef.getName()) && editorATD.getOperation().getName().equals(atdRef.getOperationName()) && editorATD.getOperation().getExecutableComponentDescription().getName().equals(atdRef.getExecutableComponentName())) {
                            res.add(editorRef.getEditor(false));
                        }
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException("Could not find editors to close recursively", e);
                    }
                    ++n3;
                }
                break block20;
            }
            if (!(modelObject instanceof Identifier)) break block20;
            Identifier id = (Identifier)modelObject;
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n4 = 0;
            while (n4 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n4];
                try {
                    if (editorRef.getEditorInput() instanceof IdentifierInput) {
                        IdentifierInput input = (IdentifierInput)editorRef.getEditorInput();
                        Identifier editorId = (Identifier)input.getAdapter(Identifier.class);
                        if (id.getID().equals(editorId.getID())) {
                            res.add(editorRef.getEditor(false));
                        }
                    }
                }
                catch (PartInitException e) {
                    throw new RuntimeException("Could not find editors to close recursively", e);
                }
                ++n4;
            }
        }
        return res;
    }

    public void run(IAction action) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        MessageBox msg = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 196);
        msg.setMessage("Do you really want to revert this item? If it was introduced in this branch, all of its subitems will be reverted (removed), too.");
        if (msg.open() != 64) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editors = workbenchPage.getEditorReferences();
        Collection<IEditorPart> editorsToClose = this.editorsToCloseOnRevert(editors, session, this.itemToRevert);
        if (this.itemToRevert instanceof ECDReference) {
            ECDReference ecd = (ECDReference)this.itemToRevert;
            EditorHelper.activityRepository.getECDManager().revertDevelopmentECD(session, ecd.getName(), ARMHelper.getBranch().longValue());
        } else if (this.itemToRevert instanceof OperationReference) {
            OperationReference op = (OperationReference)this.itemToRevert;
            EditorHelper.activityRepository.getOperationManager().revertDevelopmentOperation(session, op.getExecutableComponentName(), op.getName(), ARMHelper.getBranch().longValue());
        } else if (this.itemToRevert instanceof ATDReference) {
            ATDReference atd = (ATDReference)this.itemToRevert;
            EditorHelper.activityRepository.getATDManager().revertDevelopmentATD(session, atd.getExecutableComponentName(), atd.getOperationName(), atd.getName(), ARMHelper.getBranch().longValue());
        } else if (this.itemToRevert instanceof Identifier) {
            Identifier id = (Identifier)this.itemToRevert;
            EditorHelper.activityRepository.getIdentifierManager().revertDevelopmentIdentifier(session, id.getID(), ARMHelper.getBranch().longValue());
        }
        ARMHelper.refreshRepositoryBrowserView();
        for (IEditorPart editor : editorsToClose) {
            workbenchPage.closeEditor(editor, false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        Object selOb = ((StructuredSelection)selection).getFirstElement();
        action.setEnabled(selOb != null && (selOb instanceof ECDReference || selOb instanceof OperationReference || selOb instanceof ATDReference || selOb instanceof Identifier) && ARMHelper.getBranch() != null);
        if (action.isEnabled()) {
            this.itemToRevert = selOb;
        }
    }
}

