/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.actions;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.util.CheckReport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class UpdateBranchAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.setEnabled(ARMHelper.getBranch() != null);
    }

    public void run(IAction action) {
        MessageBox msg = new MessageBox(Display.getCurrent().getActiveShell(), 196);
        msg.setText("Update branch");
        msg.setMessage("Are you sure you want to update the current branch to the latest revision?");
        if (msg.open() != 64) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        ActivityRepository repository = Activator.getService().getActivityRepository();
        CheckReport report = repository.getRevisionManager().updateBranch(session, ARMHelper.getBranch().longValue(), false);
        if (report.getCheckResult() == CheckReport.ResultType.FAILURE) {
            msg = new MessageBox(Display.getCurrent().getActiveShell(), 33);
            msg.setText("Updating branch failed");
            String s = String.format("Updating the branch failed. Errors:\n\n%s", report.getReportSummary());
            msg.setMessage(s);
            msg.open();
            return;
        }
        msg = new MessageBox(Display.getCurrent().getActiveShell(), 34);
        msg.setText("Update successful");
        String s = String.format("Updating the branch successfully completed!", new Object[0]);
        msg.setMessage(s);
        msg.open();
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        workbenchPage.closeAllEditors(false);
        ARMHelper.refreshRepositoryBrowserView();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ARMHelper.getBranch() != null);
    }
}

