/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ActivityTemplateDefinitionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ATDGeneralPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ATDRuntimePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ConfigurationPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ParameterPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.UserAttributePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterTemplateWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterWidget;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityTemplateDefinitionManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class ActivityTemplateDefinitionEditor
extends RepositoryEditor
implements ParameterController,
ParameterTemplateController {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".editors.atd";
    private ActivityTemplateDefinition atd;
    private ParameterPage parameterPage;
    private ConfigurationPage configPage;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ActivityTemplateDefinitionInput)) {
            throw new PartInitException("Invalid input: need ActivityTemplateDefinitionInput");
        }
        super.init(site, input);
        this.atd = (ActivityTemplateDefinition)((ActivityTemplateDefinitionInput)input).getAdapter(ActivityTemplateDefinition.class);
        if (this.atd == null) {
            throw new PartInitException("ATD not available");
        }
        this.setReadOnly(((ActivityTemplateDefinitionInput)input).isReadOnly());
    }

    protected void addPages() {
        try {
            Boolean isPCPInherited = this.atd.isParameterChangePolicyInherited();
            this.parameterPage = new ParameterPage(this, "Parameters", this, this, this.atd.getParameterChangePolicy(), isPCPInherited, true);
            this.configPage = new ConfigurationPage(this, "Configuration", this.atd.getConfigurationDescription(), (InheritedConfiguration)this.atd.getConfiguration(), (InheritedConfiguration)this.atd.getTestConfiguration(), this.isReadOnly());
            this.addPage((IFormPage)new ATDGeneralPage(this));
            this.addPage((IFormPage)new ATDRuntimePage(this));
            this.addPage((IFormPage)this.parameterPage);
            this.addPage((IFormPage)this.configPage);
            this.addPage((IFormPage)new UserAttributePage(this, (UserAttributeContainer)this.atd, this.isReadOnly()));
        }
        catch (PartInitException exp) {
            exp.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        this.startSave(monitor);
        InheritedConfigurationDescription newConfigDescription = this.configPage.getConfigurationDescription();
        InheritedActivityConfiguration newConfig = (InheritedActivityConfiguration)this.configPage.getConfiguration();
        InheritedActivityConfiguration newTestConfig = (InheritedActivityConfiguration)this.configPage.getTestConfiguration();
        if (newConfigDescription != null) {
            this.atd.setConfigurationDescription(newConfigDescription);
        }
        if (newConfig != null) {
            this.atd.setConfiguration(newConfig);
        }
        if (newTestConfig != null) {
            this.atd.setTestConfiguration(newTestConfig);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.parameterPage.isInitialized()) {
            if (this.parameterPage.isParameterChangePolicyInherited()) {
                this.atd.removeOwnParameterChangePolicy();
            } else {
                this.atd.setParameterChangePolicy(this.parameterPage.getParameterChangePolicy());
            }
        }
        ActivityTemplateDefinitionManager atdMan = EditorHelper.activityRepository.getATDManager();
        SessionToken session = Activator.getService().getSessionToken();
        atdMan.storeDevelopmentATD(session, this.atd.getStorageATD(), ARMHelper.getBranch().longValue());
        this.endSave();
        this.parameterPage.setParameterChangePolicy(this.atd.getParameterChangePolicy());
        this.parameterPage.setParameterChangePolicyInherited(this.atd.getParameterChangePolicy() != null);
        this.configPage.setConfigurationDescription(this.atd.getConfigurationDescription());
        this.configPage.setConfiguration((InheritedConfiguration)this.atd.getConfiguration());
        this.configPage.setTestConfiguration((InheritedConfiguration)this.atd.getTestConfiguration());
    }

    public ActivityTemplateDefinition getATD() {
        return this.atd;
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterWidget widget) {
        return this.atd.getOperation().getParameterChangePolicy();
    }

    @Override
    public InheritedCollection<String, ActivityModelParameter> getParameters(ParameterWidget widget, ActivityConstants.AccessType accessType) {
        return this.atd.getParameters(accessType);
    }

    @Override
    public void parametersChanged(InheritedCollection<String, ActivityModelParameter> parameters, ActivityConstants.AccessType accessType) {
        this.atd.setParameters(accessType, parameters);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterTemplateWidget widget) {
        return this.atd.getParameterChangePolicy();
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(ParameterTemplateWidget widget) {
        return this.atd.getParameterTemplates();
    }

    @Override
    public void parameterTemplatesChanged(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.atd.setParameterTemplates(parameterTemplates);
    }
}

