/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EditorHelper {
    public static final ActivityRepository activityRepository = Activator.getService().getActivityRepository();
    public static final ActivityModelFactory activityModelFactory = Activator.getService().getActivityModelFactory();
    public static final Color inheritedColor = new Color(null, 120, 120, 120);

    public static void packTableColumns(Table table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    public static ConfigurationPair openAddUserAttribute() {
        return EditorHelper.openEditUserAttribute(new ConfigurationPair());
    }

    public static ConfigurationPair openEditUserAttribute(ConfigurationPair attrib) {
        final ConfigurationPair newAttrib = new ConfigurationPair();
        final boolean[] okPressed = new boolean[1];
        newAttrib.setName(null);
        Display display = PlatformUI.getWorkbench().getDisplay();
        final Shell shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 67680);
        shell.setText("User defined Attribute");
        shell.setSize(300, 160);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        shell.setLayout((Layout)layout);
        FormToolkit toolkit = new FormToolkit(display);
        ScrolledForm form = toolkit.createScrolledForm((Composite)shell);
        Composite parent = form.getBody();
        layout = new GridLayout(3, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        parent.setLayout((Layout)layout);
        Label label = toolkit.createLabel(parent, "Name");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Text txtName = toolkit.createText(parent, attrib.getName(), 4);
        txtName.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        label = toolkit.createLabel(parent, "Value");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Text txtValue = toolkit.createText(parent, attrib.getValue(), 578);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        gd.heightHint = 50;
        txtValue.setLayoutData((Object)gd);
        toolkit.createLabel(parent, "");
        Button btnOK = toolkit.createButton(parent, "&OK", 8);
        gd = new GridData(3, 1, true, false);
        gd.widthHint = 70;
        btnOK.setLayoutData((Object)gd);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                newAttrib.setName(txtName.getText());
                newAttrib.setValue(txtValue.getText());
                okPressed[0] = true;
                shell.close();
            }
        });
        Button btnCancel = toolkit.createButton(parent, "&Cancel", 8);
        gd = new GridData(1, 1, false, false);
        gd.widthHint = 70;
        btnCancel.setLayoutData((Object)gd);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                newAttrib.setName(null);
                shell.close();
            }
        });
        toolkit.paintBordersFor(parent);
        shell.setDefaultButton(btnOK);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        boolean changed = false;
        changed |= newAttrib.getName() == null && attrib.getName() == null;
        changed |= newAttrib.getName() != null && !newAttrib.getName().equals(attrib.getName());
        changed |= newAttrib.getValue() == null && attrib.getValue() == null;
        if ((changed |= newAttrib.getValue() != null && !newAttrib.getValue().equals(attrib.getValue())) && okPressed[0]) {
            return newAttrib;
        }
        return null;
    }

    public static ConfigurationDescriptionField openAddConfigurationDescription() {
        return EditorHelper.openEditConfigurationDescription(new ConfigurationDescriptionField());
    }

    public static ConfigurationDescriptionField openEditConfigurationDescription(ConfigurationDescriptionField configurationDescription) {
        final ConfigurationDescriptionField newDescription = new ConfigurationDescriptionField();
        Display display = PlatformUI.getWorkbench().getDisplay();
        final Shell shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 67696);
        shell.setText("Configuration field description");
        shell.setSize(500, 300);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        shell.setLayout((Layout)layout);
        FormToolkit toolkit = new FormToolkit(display);
        Form form = toolkit.createForm((Composite)shell);
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite parent = form.getBody();
        layout = new GridLayout(3, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        parent.setLayout((Layout)layout);
        Label label = toolkit.createLabel(parent, "Name");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Text txtName = toolkit.createText(parent, "", 4);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 250;
        gd.horizontalSpan = 2;
        txtName.setLayoutData((Object)gd);
        label = toolkit.createLabel(parent, "Description");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Text txtDescription = toolkit.createText(parent, "", 578);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        txtDescription.setLayoutData((Object)gd);
        label = toolkit.createLabel(parent, "Required");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Button btnRequired = toolkit.createButton(parent, "", 32);
        btnRequired.setSelection(true);
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        btnRequired.setLayoutData((Object)gd);
        toolkit.createLabel(parent, "");
        Button btnOK = toolkit.createButton(parent, "&OK", 8);
        gd = new GridData(0x1000008, 1, true, false);
        gd.widthHint = 70;
        btnOK.setLayoutData((Object)gd);
        Button btnCancel = toolkit.createButton(parent, "&Cancel", 8);
        gd = new GridData(0x1000008, 1, false, false);
        gd.widthHint = 70;
        btnCancel.setLayoutData((Object)gd);
        toolkit.paintBordersFor(parent);
        newDescription.setName(null);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                newDescription.setName(txtName.getText());
                newDescription.setDescription(txtDescription.getText());
                newDescription.setRequired(btnRequired.getSelection());
                shell.close();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        txtName.setText(configurationDescription.getName());
        txtDescription.setText(configurationDescription.getDescription());
        btnRequired.setSelection(configurationDescription.isRequired());
        shell.setDefaultButton(btnOK);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (newDescription.getName() != null) {
            if (newDescription.getName().equals(configurationDescription.getName()) && newDescription.getDescription().equals(configurationDescription.getDescription()) && newDescription.isRequired() == configurationDescription.isRequired()) {
                return null;
            }
            return newDescription;
        }
        return null;
    }

    public static ConfigurationPair openAddConfigurationPair(Map<String, String> configurationDescription) {
        return EditorHelper.openEditConfigurationPair(configurationDescription, new ConfigurationPair(), false);
    }

    public static ConfigurationPair openEditConfigurationPair(Map<String, String> configurationDescription, ConfigurationPair pair) {
        return EditorHelper.openEditConfigurationPair(configurationDescription, pair, true);
    }

    protected static ConfigurationPair openEditConfigurationPair(Map<String, String> configurationDescription, ConfigurationPair pair, boolean fieldReadOnly) {
        final ConfigurationPair newPair = new ConfigurationPair();
        final boolean[] okPressed = new boolean[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        final Shell shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 67680);
        shell.setText("Configuration Editor");
        shell.setSize(300, 160);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        shell.setLayout((Layout)layout);
        FormToolkit toolkit = new FormToolkit(display);
        ScrolledForm form = toolkit.createScrolledForm((Composite)shell);
        Composite parent = form.getBody();
        layout = new GridLayout(4, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        parent.setLayout((Layout)layout);
        Label label = toolkit.createLabel(parent, "Field");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Table tblField = toolkit.createTable(parent, 65540);
        for (Map.Entry<String, String> field : configurationDescription.entrySet()) {
            TableItem item = new TableItem(tblField, 0);
            item.setText(field.getKey());
            item.setData("description", (Object)field.getValue());
            if (!pair.getName().equals(field.getKey())) continue;
            tblField.setSelection(tblField.getItemCount() - 1);
        }
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 150;
        gd.widthHint = 150;
        tblField.setLayoutData((Object)gd);
        tblField.setEnabled(!fieldReadOnly);
        final Text txtFieldDescription = toolkit.createText(parent, "", 578);
        txtFieldDescription.setEditable(false);
        gd = new GridData(4, 4, true, false, 2, 1);
        gd.heightHint = 150;
        gd.widthHint = 150;
        txtFieldDescription.setLayoutData((Object)gd);
        if (tblField.getSelectionCount() == 0) {
            tblField.setSelection(0);
        }
        txtFieldDescription.setText((String)tblField.getSelection()[0].getData("description"));
        label = toolkit.createLabel(parent, "Value");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final Text txtValue = toolkit.createText(parent, pair.getValue(), 578);
        gd = new GridData(4, 1, true, false, 3, 1);
        gd.heightHint = 50;
        txtValue.setLayoutData((Object)gd);
        toolkit.createLabel(parent, "");
        toolkit.createLabel(parent, "");
        final Button btnOK = toolkit.createButton(parent, "&OK", 8);
        gd = new GridData(3, 1, true, false);
        gd.widthHint = 70;
        btnOK.setLayoutData((Object)gd);
        tblField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tblField.getSelection().length <= 0) {
                    btnOK.setEnabled(false);
                    return;
                }
                btnOK.setEnabled(true);
                txtFieldDescription.setText((String)tblField.getSelection()[0].getData("description"));
            }
        });
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                newPair.setName(tblField.getSelection()[0].getText());
                newPair.setValue(txtValue.getText());
                okPressed[0] = true;
                shell.close();
            }
        });
        Button btnCancel = toolkit.createButton(parent, "&Cancel", 8);
        gd = new GridData(1, 1, false, false);
        gd.widthHint = 70;
        btnCancel.setLayoutData((Object)gd);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                newPair.setName(null);
                shell.close();
            }
        });
        toolkit.paintBordersFor(parent);
        shell.setDefaultButton(btnOK);
        shell.pack();
        shell.open();
        if (fieldReadOnly) {
            txtValue.setFocus();
        }
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        boolean changed = false;
        changed |= newPair.getName() == null && pair.getName() == null;
        changed |= newPair.getName() != null && !newPair.getName().equals(pair.getName());
        changed |= newPair.getValue() == null && pair.getValue() == null;
        if ((changed |= newPair.getValue() != null && !newPair.getValue().equals(pair.getValue())) && okPressed[0]) {
            return newPair;
        }
        return null;
    }

    public static String openListSelect(Map<String, String> choices, final Map<String, String> descriptions, String dialogText) {
        if (choices.size() == 0) {
            MessageDialog.openWarning(null, (String)"No choices", (String)"There are no entries to choose from.");
            return null;
        }
        final boolean[] isClosedByOK = new boolean[1];
        final String[] returnKey = new String[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        final Shell shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 66800);
        shell.setText(dialogText);
        shell.setSize(400, 160);
        FormToolkit toolkit = new FormToolkit(display);
        Shell parent = shell;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        parent.setLayout((Layout)layout);
        final Table tblItems = toolkit.createTable((Composite)parent, 65540);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = 400;
        gd.heightHint = 150;
        tblItems.setLayoutData((Object)gd);
        for (Map.Entry<String, String> mapping : choices.entrySet()) {
            TableItem item = new TableItem(tblItems, 0);
            item.setData((Object)mapping.getKey());
            item.setText(mapping.getValue());
        }
        final Text descriptionsText = toolkit.createText((Composite)parent, "", 66);
        descriptionsText.setEditable(false);
        descriptionsText.setEnabled(false);
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.widthHint = 400;
        gd.heightHint = 80;
        descriptionsText.setLayoutData((Object)gd);
        tblItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                returnKey[0] = (String)tblItems.getSelection()[0].getData();
                descriptionsText.setText((String)descriptions.get(returnKey[0]));
            }
        });
        tblItems.setSelection(0);
        returnKey[0] = (String)tblItems.getSelection()[0].getData();
        descriptionsText.setText(descriptions.get(returnKey[0]));
        Button btnOK = toolkit.createButton((Composite)parent, "&OK", 8);
        gd = new GridData(0x1000008, 1, true, false);
        gd.widthHint = 80;
        btnOK.setLayoutData((Object)gd);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                isClosedByOK[0] = true;
                shell.close();
            }
        });
        Button btnCancel = toolkit.createButton((Composite)parent, "&Cancel", 8);
        gd = new GridData(1, 1, false, false);
        gd.widthHint = 80;
        btnCancel.setLayoutData((Object)gd);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                returnKey[0] = null;
                shell.close();
            }
        });
        toolkit.paintBordersFor((Composite)parent);
        shell.setDefaultButton(btnOK);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!isClosedByOK[0]) {
            return null;
        }
        return returnKey[0];
    }

    public static void setFontInherited(Control c, boolean inherited) {
        FontData[] f;
        FontData[] fontDataArray = f = c.getFont().getFontData();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            if (inherited) {
                fd.setStyle(fd.getStyle() | 2);
            } else {
                fd.setStyle(fd.getStyle() & 0xFFFFFFFD);
            }
            ++n2;
        }
        Device dev = c.getFont().getDevice();
        c.setFont(new Font(dev, f));
        if (inherited) {
            c.setForeground(new Color(dev, 120, 120, 120));
        } else {
            c.setForeground(null);
        }
    }

    public static void setFontInherited(TableItem c, boolean inherited) {
        FontData[] f;
        FontData[] fontDataArray = f = c.getFont().getFontData();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            if (inherited) {
                fd.setStyle(fd.getStyle() | 2);
            } else {
                fd.setStyle(fd.getStyle() & 0xFFFFFFFD);
            }
            ++n2;
        }
        Device dev = c.getFont().getDevice();
        c.setFont(new Font(dev, f));
        if (inherited) {
            c.setForeground(new Color(dev, 120, 120, 120));
        } else {
            c.setForeground(null);
        }
    }

    public static class ConfigurationDescriptionField
    extends ConfigurationPair {
        protected boolean required;

        public ConfigurationDescriptionField(String name, String description, boolean required) {
            super(name, description);
            this.required = required;
        }

        public ConfigurationDescriptionField() {
            this.required = false;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public String getDescription() {
            return this.value;
        }

        public void setDescription(String description) {
            this.value = description;
        }
    }

    public static class ConfigurationPair {
        protected String name;
        protected String value;

        public ConfigurationPair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public ConfigurationPair() {
            this.name = "";
            this.value = "";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

