/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.ExecutableComponentDescriptionInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ConfigurationPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ECDGeneralPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ECDRuntimePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ParameterPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.UserAttributePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterTemplateWidget;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ExecutableComponentDescriptionManager;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class ExecutableComponentDescriptionEditor
extends RepositoryEditor
implements ParameterTemplateController {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".editors.ecd";
    private ExecutableComponentDescription ecd;
    private ConfigurationPage configPage;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.ecd = (ExecutableComponentDescription)input.getAdapter(ExecutableComponentDescription.class);
        if (this.getECD() == null) {
            throw new RuntimeException("The editor input is no ExecutableComponentDescription");
        }
        this.setReadOnly(((ExecutableComponentDescriptionInput)input).isReadOnly());
    }

    protected void addPages() {
        try {
            this.configPage = new ConfigurationPage(this, "Configuration", this.getECD().getConfigurationDescription(), null, null, this.isReadOnly());
            this.addPage((IFormPage)new ECDGeneralPage(this, "General", this.getECD()));
            this.addPage((IFormPage)new ECDRuntimePage(this, "Runtime", this.getECD()));
            this.addPage((IFormPage)new ParameterPage(this, "Parameters", null, this, null, null, false));
            this.addPage((IFormPage)this.configPage);
            this.addPage((IFormPage)new UserAttributePage(this, (UserAttributeContainer)this.getECD(), this.isReadOnly()));
        }
        catch (PartInitException exp) {
            exp.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        InheritedConfigurationDescription newConfigDescription = this.configPage.getConfigurationDescription();
        if (newConfigDescription != null) {
            this.ecd.setConfigurationDescription(newConfigDescription);
        }
        this.startSave(monitor);
        if (monitor.isCanceled()) {
            return;
        }
        ExecutableComponentDescriptionManager ecdMan = EditorHelper.activityRepository.getECDManager();
        SessionToken session = Activator.getService().getSessionToken();
        ecdMan.storeDevelopmentECD(session, this.ecd.getStorageECD(), ARMHelper.getBranch().longValue());
        this.endSave();
    }

    public ExecutableComponentDescription getECD() {
        return this.ecd;
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterTemplateWidget widget) {
        return ParameterChangePolicy.GENERIC;
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(ParameterTemplateWidget widget) {
        return this.getECD().getParameterTemplates();
    }

    @Override
    public void parameterTemplatesChanged(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.getECD().setParameterTemplates(parameterTemplates);
    }
}

