/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.IdentifierInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.IdentifierGeneralPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.UserAttributePage;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.IdentifierManager;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class IdentifierEditor
extends RepositoryEditor {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".editors.identifier";
    private Identifier identifier;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IdentifierInput)) {
            throw new PartInitException("Invalid input: need IdentifierInput");
        }
        super.init(site, input);
        this.identifier = (Identifier)((IdentifierInput)input).getAdapter(Identifier.class);
        if (this.identifier == null) {
            throw new PartInitException("Identifier not available");
        }
        this.setReadOnly(((IdentifierInput)input).isReadOnly());
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new IdentifierGeneralPage(this));
            this.addPage((IFormPage)new UserAttributePage(this, (UserAttributeContainer)this.identifier, this.isReadOnly()));
        }
        catch (PartInitException exp) {
            exp.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        this.startSave(monitor);
        if (monitor.isCanceled()) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        IdentifierManager idManager = EditorHelper.activityRepository.getIdentifierManager();
        idManager.storeDevelopmentIdentifier(session, this.identifier, ARMHelper.getBranch().longValue());
        this.endSave();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }
}

